package com.elitesland.tw.tw5.server.prd.task.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.task.payload.TaskInfoPayload;
import com.elitesland.tw.tw5.api.prd.task.query.TaskInfoQuery;
import com.elitesland.tw.tw5.api.prd.task.vo.TaskInfoVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.PmsReasonTypeEnum;
import com.elitesland.tw.tw5.server.prd.task.entity.QTaskInfoDO;
import com.elitesland.tw.tw5.server.prd.task.entity.QTaskPackageDO;
import com.elitesland.tw.tw5.server.prd.task.entity.TaskInfoDO;
import com.elitesland.tw.tw5.server.prd.task.repo.TaskInfoRepo;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;

/**
 * 任务
 *
 * @author xxb
 * @date 2023-11-16
 */
@Repository
@RequiredArgsConstructor
public class TaskInfoDAO {

    private final JPAQueryFactory jpaQueryFactory;
    private final TaskInfoRepo repo;
    private final QTaskInfoDO qdo = QTaskInfoDO.taskInfoDO;

    private final QTaskPackageDO packageQdo = QTaskPackageDO.taskPackageDO;

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<TaskInfoVO> getJpaQuerySelect0() {
        return jpaQueryFactory.select(Projections.bean(TaskInfoVO.class,
                qdo.id,
                qdo.remark,
                qdo.createUserId,
                qdo.creator,
                qdo.createTime,
                qdo.modifyUserId,
                qdo.updater,
                qdo.modifyTime,
                qdo.taskPackageId,
                qdo.taskName,
                qdo.disterResId,
                qdo.taskResId,
                qdo.assId,
                qdo.sourceType,
                qdo.sourceId,
                qdo.relatedActId,
                qdo.planStartDate,
                qdo.planEndDate,
                qdo.taskType,
                qdo.taskDes,
                qdo.accepCriteria,
                qdo.priority,
                qdo.totalEqva,
                qdo.settledEqva,
                qdo.planEqva,
                qdo.originalEqva,
                qdo.additionEqva,
                qdo.splitEqva,
                qdo.usedEqva,
                qdo.validEqva,
                qdo.evaluationflag,
                qdo.taskProgress,
                qdo.taskStatus,
                qdo.taskParentId,
                qdo.taskParentName,
                qdo.taskApplyFlag,
                qdo.taskApplyProcessId,
                qdo.releaseEqva,
                qdo.approvedEqva,
                qdo.taskNo,
                qdo.bw8Flag
        )).from(qdo);
    }

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<TaskInfoVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(TaskInfoVO.class,
                qdo.id,
                qdo.remark,
                qdo.createUserId,
                qdo.creator,
                qdo.createTime,
                qdo.modifyUserId,
                qdo.updater,
                qdo.modifyTime,
                qdo.taskPackageId,
                qdo.taskName,
                qdo.taskResId,
                qdo.assId,
                qdo.sourceType,
                qdo.sourceId,
                qdo.relatedActId,
                qdo.relatedAct,
                qdo.planStartDate,
                qdo.planEndDate,
                qdo.taskType,
                qdo.taskDes,
                qdo.accepCriteria,
                qdo.priority,
                qdo.taskNo,
                qdo.totalEqva,
                qdo.settledEqva,
                qdo.approvedEqva,
                qdo.planEqva,
                qdo.originalEqva,
                qdo.additionEqva,
                qdo.splitEqva,
                qdo.usedEqva,
                qdo.validEqva,
                qdo.evaluationflag,
                qdo.taskProgress,
                qdo.taskStatus,
                qdo.taskParentId,
                qdo.taskParentName,
                qdo.taskApplyFlag,
                qdo.taskApplyProcessId,
                qdo.actualStartDate,
                qdo.actualEndDate,
                qdo.disterResId,
                packageQdo.reasonId,
                packageQdo.reasonName,
                packageQdo.reasonType,
                packageQdo.taskPackageName,
                packageQdo.disterResId.as("disterPackegeResId"),
                packageQdo.receiverResId,
                packageQdo.receiverBuId,
                packageQdo.compositeAbilityId,
                packageQdo.startDate,
                packageQdo.endDate,
                packageQdo.taskPackageStatus,
                packageQdo.taskPackageType,
                packageQdo.taskPackageDes,
                packageQdo.acceptorId,
                packageQdo.acceptMethod,
                packageQdo.pricingMethod,
                packageQdo.autoSettleFlag,
                packageQdo.guaranteeRate,
                packageQdo.settlePrice,
                packageQdo.incomePrice,
                packageQdo.jobType1,
                packageQdo.jobType2,
                packageQdo.taskPackageNo,
                packageQdo.eqvaRatio
        )).from(qdo).leftJoin(packageQdo).on(qdo.taskPackageId.eq(packageQdo.id));
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<TaskInfoVO> getJpaQueryWhere(TaskInfoQuery query) {
        JPAQuery<TaskInfoVO> jpaQuery = getJpaQuerySelect();
        // 条件封装
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        // 动态排序
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
        return jpaQuery;
    }

    /**
     * 统计
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    public long count(TaskInfoQuery query) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory
                .select(qdo.count())
                .from(qdo).leftJoin(packageQdo).on(qdo.taskPackageId.eq(packageQdo.id));
        ;
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        long total = jpaQuery.fetchOne();
        return total;
    }

    /**
     * 查询条件封装
     *
     * @param query 条件
     * @return {@link Predicate}
     */
    private Predicate where(TaskInfoQuery query) {
        List<Predicate> list = new ArrayList<>();
        /** 记录唯一ID 精确 */
        if (!ObjectUtils.isEmpty(query.getId())) {
            list.add(qdo.id.eq(query.getId()));
        }
        if (!ObjectUtils.isEmpty(query.getIdList())) {
            list.add(qdo.id.in(query.getIdList()));
        }
        if (!ObjectUtils.isEmpty(query.getTaskPackageId())) {
            list.add(qdo.taskPackageId.eq(query.getTaskPackageId()));
        }
        if (!ObjectUtils.isEmpty(query.getTaskNo())) {
            list.add(qdo.taskNo.like(SqlUtil.toSqlLikeString(query.getTaskNo())));
        }
        if (!ObjectUtils.isEmpty(query.getTaskName())) {
            list.add(qdo.taskName.like(SqlUtil.toSqlLikeString(query.getTaskName())));
        }
        if (!ObjectUtils.isEmpty(query.getTaskResId())) {
            list.add(qdo.taskResId.eq(query.getTaskResId()));
        }
        if (!ObjectUtils.isEmpty(query.getAssId())) {
            list.add(qdo.assId.eq(query.getAssId()));
        }
        if (!ObjectUtils.isEmpty(query.getRelatedActId())) {
            list.add(qdo.relatedActId.eq(query.getRelatedActId()));
        }
        if (!ObjectUtils.isEmpty(query.getRelatedAct())) {
            list.add(qdo.relatedAct.eq(query.getRelatedAct()));
        }
        if (!ObjectUtils.isEmpty(query.getPlanStartDate())) {
            list.add(qdo.planStartDate.eq(query.getPlanStartDate()));
        }
        if (!ObjectUtils.isEmpty(query.getPlanEndDate())) {
            list.add(qdo.planEndDate.eq(query.getPlanEndDate()));
        }
        //是否逾期标记
        Integer overdue = query.getOverdue();
        if (!ObjectUtils.isEmpty(overdue)) {
            if (overdue == 1) {
                list.add(qdo.planEndDate.before(LocalDate.now()));
            } else {
                list.add(qdo.planEndDate.after(LocalDate.now()));
            }
        }
        if (!ObjectUtils.isEmpty(query.getTaskType())) {
            list.add(qdo.taskType.eq(query.getTaskType()));
        }
        if (!ObjectUtils.isEmpty(query.getTaskDes())) {
            list.add(qdo.taskDes.eq(query.getTaskDes()));
        }
        if (!ObjectUtils.isEmpty(query.getAccepCriteria())) {
            list.add(qdo.accepCriteria.eq(query.getAccepCriteria()));
        }
        if (!ObjectUtils.isEmpty(query.getPriority())) {
            list.add(qdo.priority.eq(query.getPriority()));
        }
        if (!ObjectUtils.isEmpty(query.getTotalEqva())) {
            list.add(qdo.totalEqva.eq(query.getTotalEqva()));
        }
        if (!ObjectUtils.isEmpty(query.getSettledEqva())) {
            list.add(qdo.settledEqva.eq(query.getSettledEqva()));
        }
        if (!ObjectUtils.isEmpty(query.getPlanEqva())) {
            list.add(qdo.planEqva.eq(query.getPlanEqva()));
        }
        if (!ObjectUtils.isEmpty(query.getAdditionEqva())) {
            list.add(qdo.additionEqva.eq(query.getAdditionEqva()));
        }
        if (!ObjectUtils.isEmpty(query.getSplitEqva())) {
            list.add(qdo.splitEqva.eq(query.getSplitEqva()));
        }
        if (!ObjectUtils.isEmpty(query.getUsedEqva())) {
            list.add(qdo.usedEqva.eq(query.getUsedEqva()));
        }
        if (!ObjectUtils.isEmpty(query.getValidEqva())) {
            list.add(qdo.validEqva.eq(query.getValidEqva()));
        }
        if (!ObjectUtils.isEmpty(query.getEvaluationflag())) {
            list.add(qdo.evaluationflag.eq(query.getEvaluationflag()));
        }
        if (!ObjectUtils.isEmpty(query.getTaskProgress())) {
            list.add(qdo.taskProgress.eq(query.getTaskProgress()));
        }
        if (!ObjectUtils.isEmpty(query.getTaskStatus())) {
            list.add(qdo.taskStatus.eq(query.getTaskStatus()));
        }
        if (!ObjectUtils.isEmpty(query.getSourceType())) {
            list.add(qdo.sourceType.eq(query.getSourceType()));
        }
        if (!ObjectUtils.isEmpty(query.getSourceId())) {
            list.add(qdo.sourceId.eq(query.getSourceId()));
        }
        //状态集合查询
        if (!ObjectUtils.isEmpty(query.getTaskStatuss())) {
            if (query.getTaskStatusFlag() != null && query.getTaskStatusFlag() == 0) {
                list.add(qdo.taskStatus.notIn(query.getTaskStatuss()));
            } else {
                list.add(qdo.taskStatus.in(query.getTaskStatuss()));
            }

        }
        Integer receiverFlag = query.getReceiverFlag();
        if (!ObjectUtils.isEmpty(receiverFlag) && receiverFlag == 1) {
            query.setTaskResId(GlobalUtil.getLoginUserId());
        }
        Integer initiatorFlag = query.getInitiatorFlag();
        if (!ObjectUtils.isEmpty(initiatorFlag) && initiatorFlag == 1) {
            query.setCreateUserId(GlobalUtil.getLoginUserId());
        }
        if (!ObjectUtils.isEmpty(query.getTaskApplyFlag())) {
            list.add(qdo.taskApplyFlag.eq(query.getTaskApplyFlag()));
        }
        if (!ObjectUtils.isEmpty(query.getTaskProgress())) {
            list.add(qdo.taskProgress.eq(query.getTaskProgress()));
        }
        if (!ObjectUtils.isEmpty(query.getDisterResId())) {
            list.add(qdo.disterResId.eq(query.getDisterResId()));
        }
        if (!ObjectUtils.isEmpty(query.getReasonType())) {
            list.add(packageQdo.reasonType.eq(query.getReasonType()));
        }
        if (!ObjectUtils.isEmpty(query.getReasonId())) {
            list.add(packageQdo.reasonId.eq(query.getReasonId()));
        }
        if (!ObjectUtils.isEmpty(query.getReasonName())) {
            list.add(packageQdo.reasonName.like(SqlUtil.toSqlLikeString(query.getReasonName())));
        }
        if (!ObjectUtils.isEmpty(query.getTaskPackageName())) {
            list.add(packageQdo.taskPackageName.like(SqlUtil.toSqlLikeString(query.getTaskPackageName())));
        }
        if (!ObjectUtils.isEmpty(query.getAcceptorId())) {
            list.add(packageQdo.acceptorId.eq(query.getAcceptorId()));
        }
        if (query.getPermissionFlag()) {
            BooleanExpression orExpression = qdo.disterResId.eq(query.getLoginUserId()).or(qdo.taskResId.eq(query.getLoginUserId()));
            if (!ObjectUtils.isEmpty(query.getPmsProjIds())) {
                orExpression = orExpression.or((packageQdo.reasonType.eq(PmsReasonTypeEnum.PROJ_CONTRACT.getCode()).and(packageQdo.reasonId.in(query.getPmsProjIds()))));
            }
            if (!ObjectUtils.isEmpty(query.getBuProjIds())) {
                orExpression = orExpression.or((packageQdo.reasonType.eq(PmsReasonTypeEnum.PROJ_BU.getCode()).and(packageQdo.reasonId.in(query.getBuProjIds()))));
            }
            if (!ObjectUtils.isEmpty(query.getOppProjIds())) {
                orExpression = orExpression.or((packageQdo.reasonType.eq(PmsReasonTypeEnum.PROJ_OPPO.getCode()).and(packageQdo.reasonId.in(query.getOppProjIds()))));
            }
            list.add(orExpression);
        }
        return ExpressionUtils.allOf(list);
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public TaskInfoVO queryByKey0(Long id) {
        JPAQuery<TaskInfoVO> jpaQuery = getJpaQuerySelect0();
        jpaQuery.where(qdo.id.eq(id));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    public TaskInfoVO queryByKey(Long id) {
        JPAQuery<TaskInfoVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.id.eq(id));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    public TaskInfoVO queryByTaskNo(String taskNo) {
        JPAQuery<TaskInfoVO> jpaQuery = getJpaQuerySelect0();
        jpaQuery.where(qdo.taskNo.eq(taskNo));
        return jpaQuery.fetchFirst();
    }

    /**
     * 根据任务包ID查询
     *
     * @param taskPackageId 任务包ID
     * @return 结果
     */
    public List<TaskInfoVO> queryByTaskPackageId(Long taskPackageId) {
        JPAQuery<TaskInfoVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.taskPackageId.eq(taskPackageId));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetch();
    }

    /**
     * 根据任务包ID查询
     *
     * @param taskPackageId 任务包ID
     * @return 结果
     */
    public BigDecimal queryTotalEqvaByTaskPackageId(Long taskPackageId) {
        JPAQuery<BigDecimal> jpaQuery = jpaQueryFactory
                .select(qdo.totalEqva.sum())
                .from(qdo);
        jpaQuery.where(qdo.taskPackageId.eq(taskPackageId));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchOne();
    }
//    /**
//     * 统计
//     *
//     * @param query 查询参数
//     * @return jpaQuery对象
//     */
//    public long count(TaskInfoQuery query) {
//        JPAQuery<Long> jpaQuery = jpaQueryFactory
//                .select(qdo.count())
//                .from(qdo).leftJoin(packageQdo).on(qdo.taskPackageId.eq(packageQdo.id));
//        ;
//        jpaQuery.where(where(query));
//        // 常用基础查询条件拼装
//        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
//        long total = jpaQuery.fetchOne();
//        return total;
//    }

    /**
     * 根据任务包ID查询
     *
     * @param taskPackageIds 任务包ID
     * @return 结果
     */
    public List<TaskInfoVO> queryByTaskPackageIds(List<Long> taskPackageIds) {
        JPAQuery<TaskInfoVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.taskPackageId.in(taskPackageIds));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetch();
    }

    /**
     * 根据主键集合查询
     *
     * @param ids 主键集合
     * @return 结果
     */
    public List<TaskInfoVO> queryByKeys(List<Long> ids) {
        JPAQuery<TaskInfoVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.id.in(ids));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetch();
    }

    /**
     * 动态查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<TaskInfoVO> queryListDynamic(TaskInfoQuery query) {
        JPAQuery<TaskInfoVO> jpaQuery = getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<TaskInfoVO> queryPaging(TaskInfoQuery query) {
        long total = count(query);
        if (total == 0) {
            return PagingVO.empty();
        }
        JPAQuery<TaskInfoVO> jpaQuery = getJpaQueryWhere(query);
        List<TaskInfoVO> result = jpaQuery
                .offset(query.getPageRequest().getOffset())
                .limit(query.getPageRequest().getPageSize())
                .fetch();
        return PagingVO.<TaskInfoVO>builder().records(result).total(total).build();
    }

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public TaskInfoDO save(TaskInfoDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<TaskInfoDO> saveAll(List<TaskInfoDO> dos) {
        return repo.saveAll(dos);
    }

//    /**
//     * 根据事由查询 任务
//     *
//     * @param reasonType
//     * @param reasonId
//     * @return
//     */
//    public List<TaskInfoVO> queryTaskByReason(String reasonType, Long reasonId) {
//        JPAQuery<TaskInfoVO> jpaQuery = jpaQueryFactory.select(Projections.bean(TaskInfoVO.class,
//                        qdo.id,
//                        qdo.relatedActId,
//                        qdo.totalEqva,
//                        qdo.settledEqva,
//                        qdo.planEqva,
//                        qdo.disterResId,
//                        qdo.originalEqva,
//                        qdo.additionEqva,
//                        qdo.splitEqva,
//                        qdo.usedEqva,
//                        qdo.validEqva,
//                        qdo.taskProgress,
//                        qdo.taskStatus
//                )).from(qdo).leftJoin(packageQdo).on(qdo.taskPackageId.eq(packageQdo.id))
//                .where(packageQdo.reasonType.eq(reasonType))
//                .where(packageQdo.reasonId.eq(reasonId))
//                .where(packageQdo.deleteFlag.eq(0))
//                .where(qdo.taskStatus.ne(TaskStatusEnum.CREATE.getCode()));
//        return jpaQuery.fetch();
//    }
//
//    /**
//     * 根据事由查询 任务
//     *
//     * @param reasonTypes
//     * @param reasonIds
//     * @return
//     */
//    public List<TaskInfoVO> queryTaskByReasons(List<String> reasonTypes, List<Long> reasonIds) {
//        JPAQuery<TaskInfoVO> jpaQuery = jpaQueryFactory.select(Projections.bean(TaskInfoVO.class,
//                        qdo.id,
//                        qdo.relatedActId,
//                        qdo.totalEqva,
//                        qdo.settledEqva,
//                        qdo.planEqva,
//                        qdo.originalEqva,
//                        qdo.additionEqva,
//                        qdo.splitEqva,
//                        qdo.usedEqva,
//                        qdo.validEqva,
//                        qdo.taskProgress,
//                        qdo.taskStatus,
//                        packageQdo.reasonType,
//                        packageQdo.reasonId
//                )).from(qdo).leftJoin(packageQdo).on(qdo.taskPackageId.eq(packageQdo.id))
//                .where(packageQdo.reasonType.in(reasonTypes)).where(packageQdo.reasonId.in(reasonIds)).where(packageQdo.deleteFlag.eq(0)).where(qdo.taskStatus.ne(TaskStatusEnum.CREATE.getCode()));
//        return jpaQuery.fetch();
//    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    @Transactional
    public long updateByKeyDynamic(TaskInfoPayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .where(qdo.id.eq(payload.getId()));
        if (payload.getTaskPackageId() != null) {
            update.set(qdo.taskPackageId, payload.getTaskPackageId());
        }
        if (payload.getTaskName() != null) {
            update.set(qdo.taskName, payload.getTaskName());
        }
        if (payload.getTaskResId() != null) {
            update.set(qdo.taskResId, payload.getTaskResId());
        }
        if (payload.getAssId() != null) {
            update.set(qdo.assId, payload.getAssId());
        }
        if (payload.getRelatedActId() != null) {
            update.set(qdo.relatedActId, payload.getRelatedActId());
        }
        if (payload.getRelatedAct() != null) {
            update.set(qdo.relatedAct, payload.getRelatedAct());
        }
        if (payload.getPlanStartDate() != null) {
            update.set(qdo.planStartDate, payload.getPlanStartDate());
        }
        if (payload.getPlanEndDate() != null) {
            update.set(qdo.planEndDate, payload.getPlanEndDate());
        }
        if (payload.getTaskType() != null) {
            update.set(qdo.taskType, payload.getTaskType());
        }
        if (payload.getTaskDes() != null) {
            update.set(qdo.taskDes, payload.getTaskDes());
        }
        if (payload.getAccepCriteria() != null) {
            update.set(qdo.accepCriteria, payload.getAccepCriteria());
        }
        if (payload.getPriority() != null) {
            update.set(qdo.priority, payload.getPriority());
        }
        if (payload.getTotalEqva() != null) {
            update.set(qdo.totalEqva, payload.getTotalEqva());
        }
        if (payload.getSettledEqva() != null) {
            update.set(qdo.settledEqva, payload.getSettledEqva());
        }
        if (payload.getPlanEqva() != null) {
            update.set(qdo.planEqva, payload.getPlanEqva());
        }
        if (payload.getOriginalEqva() != null) {
            update.set(qdo.originalEqva, payload.getOriginalEqva());
        }
        if (payload.getAdditionEqva() != null) {
            update.set(qdo.additionEqva, payload.getAdditionEqva());
        }
        if (payload.getSplitEqva() != null) {
            update.set(qdo.splitEqva, payload.getSplitEqva());
        }
        if (payload.getUsedEqva() != null) {
            update.set(qdo.usedEqva, payload.getUsedEqva());
        }
        if (payload.getValidEqva() != null) {
            update.set(qdo.validEqva, payload.getValidEqva());
        }
        if (payload.getEvaluationflag() != null) {
            update.set(qdo.evaluationflag, payload.getEvaluationflag());
        }
        if (payload.getTaskProgress() != null) {
            update.set(qdo.taskProgress, payload.getTaskProgress());
        }
        if (payload.getTaskStatus() != null) {
            update.set(qdo.taskStatus, payload.getTaskStatus());
        }
        if (payload.getTaskApplyFlag() != null) {
            update.set(qdo.taskApplyFlag, payload.getTaskApplyFlag());
        }
        if (payload.getTaskApplyProcessId() != null) {
            update.set(qdo.taskApplyProcessId, payload.getTaskApplyProcessId());
        }
        if (payload.getActualStartDate() != null) {
            update.set(qdo.actualStartDate, payload.getActualStartDate());
        }
        if (payload.getActualEndDate() != null) {
            update.set(qdo.actualEndDate, payload.getActualEndDate());
        }

        if (payload.getReleaseEqva() != null) {
            update.set(qdo.releaseEqva, payload.getReleaseEqva());
        }

        if (payload.getApprovedEqva() != null) {
            update.set(qdo.approvedEqva, payload.getApprovedEqva());
        }
        if (payload.getDisterResId() != null) {
            update.set(qdo.disterResId, payload.getDisterResId());
        }

        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        // 执行修改
        return update.execute();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主集合
     * @return 删除的行数
     */
    @Transactional
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.deleteFlag, 1)
                .where(qdo.id.in(keys));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }

    /**
     * 根据任务包主键删除
     *
     * @param packageIds
     * @return
     */
    public long deleteSoftByPackageIds(List<Long> packageIds) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.deleteFlag, 1)
                .where(qdo.taskPackageId.in(packageIds));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }

    /**
     * 根据任务包id修改任务状态
     *
     * @param taskPackageId
     * @param taskStatus
     * @param taskResId
     * @return
     */
    @Transactional
    public long updateStatusByTaskPackageId(Long taskPackageId, String taskStatus, Long taskResId) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.taskStatus, taskStatus)
                .set(qdo.taskResId, taskResId)
                .where(qdo.taskPackageId.eq(taskPackageId));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        // 执行修改
        return update.execute();
    }

    /**
     * 批量更改任务任务状态
     *
     * @param key
     * @param taskStatus
     * @param taskResId
     * @return
     */
    @Transactional
    public long updateStatus(Long key, String taskStatus, Long taskResId) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .where(qdo.id.eq(key));
        update.set(qdo.taskStatus, taskStatus);
        if (taskResId != null) {
            update.set(qdo.taskResId, taskResId);
        }
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        // 执行修改
        return update.execute();

    }


    /**
     * 批量更改任务进度
     *
     * @param keys
     * @param taskProgress
     * @return
     */
    @Transactional
    public long updateTaskProgress(List<Long> keys, BigDecimal taskProgress) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.taskProgress, taskProgress)
                .where(qdo.id.in(keys));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        // 执行修改
        return update.execute();
    }

    /**
     * 拉取可以结算的任务列表
     *
     * @param taskInfoQuery 任务状态
     * @return
     */
    public List<TaskInfoVO> queryTaskSettleList(TaskInfoQuery taskInfoQuery) {
        JPAQuery<TaskInfoVO> jpaQuery = getJpaQuerySelect0();
        if (!ObjectUtils.isEmpty(taskInfoQuery.getTaskStatus())) {
            jpaQuery.where(qdo.taskStatus.eq(taskInfoQuery.getTaskStatus()));
        }
        if (!ObjectUtils.isEmpty(taskInfoQuery.getSourceType())) {
            jpaQuery.where(qdo.sourceType.eq(taskInfoQuery.getSourceType()));
        }
        if (taskInfoQuery.getSourceId() != null) {
            jpaQuery.where(qdo.sourceId.eq(taskInfoQuery.getSourceId()));
        }
        if (!ObjectUtils.isEmpty(taskInfoQuery.getTaskStatuss())) {
            jpaQuery.where(qdo.taskStatus.in(taskInfoQuery.getTaskStatuss()));
        }
        if (!ObjectUtils.isEmpty(taskInfoQuery.getTaskResIds())) {
            jpaQuery.where(qdo.taskResId.in(taskInfoQuery.getTaskResIds()));
        }
        jpaQuery.where((qdo.totalEqva.subtract(qdo.settledEqva)).gt(0).and((qdo.approvedEqva.subtract(qdo.settledEqva)).gt(0)));
        return jpaQuery.fetch();
    }

    /**
     * 简单任务查询
     *
     * @param taskInfoQuery 任务状态
     * @return
     */
    public List<TaskInfoVO> queryTaskSimpleList(TaskInfoQuery taskInfoQuery) {
        JPAQuery<TaskInfoVO> jpaQuery = getJpaQuerySelect0();

        if (!ObjectUtils.isEmpty(taskInfoQuery.getTaskStatus())) {
            jpaQuery.where(qdo.taskStatus.eq(taskInfoQuery.getTaskStatus()));
        }
        if (!ObjectUtils.isEmpty(taskInfoQuery.getSourceType())) {
            jpaQuery.where(qdo.sourceType.eq(taskInfoQuery.getSourceType()));
        }
        if (taskInfoQuery.getSourceId() != null) {
            jpaQuery.where(qdo.sourceId.eq(taskInfoQuery.getSourceId()));
        }
        if (!ObjectUtils.isEmpty(taskInfoQuery.getTaskStatuss())) {
            jpaQuery.where(qdo.taskStatus.in(taskInfoQuery.getTaskStatuss()));
        }
        if (!ObjectUtils.isEmpty(taskInfoQuery.getTaskResIds())) {
            jpaQuery.where(qdo.taskResId.in(taskInfoQuery.getTaskResIds()));
        }
        return jpaQuery.fetch();
    }
}

