/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.common;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class RedisCacheUtil {
    private static final Logger log = LoggerFactory.getLogger(RedisCacheUtil.class);
    @Autowired
    private StringRedisTemplate redisTemplate;
    private final String DEFAULT_KEY_PREFIX = "tw_";
    private final int EXPIRE_TIME = 1;
    private final TimeUnit EXPIRE_TIME_TYPE = TimeUnit.DAYS;

    public <K, V> void add(K key, V value) {
        try {
            if (value != null) {
                this.redisTemplate.opsForValue().set((Object)("tw_" + key), (Object)JSON.toJSONString(value));
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException("\u6570\u636e\u7f13\u5b58\u81f3redis\u5931\u8d25");
        }
    }

    public <K, V> void add(K key, V value, long timeout, TimeUnit unit) {
        try {
            if (value != null) {
                this.redisTemplate.opsForValue().set((Object)("tw_" + key), (Object)JSON.toJSONString(value), timeout, unit);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException("\u6570\u636e\u7f13\u5b58\u81f3redis\u5931\u8d25");
        }
    }

    public <K, SK, V> void addHashCache(K key, SK subKey, V value) {
        this.redisTemplate.opsForHash().put((Object)("tw_" + key), subKey, value);
    }

    public <K, SK, V> void addHashCache(K key, SK subKey, V value, long timeout, TimeUnit unit) {
        this.redisTemplate.opsForHash().put((Object)("tw_" + key), subKey, value);
        this.redisTemplate.expire((Object)("tw_" + key), timeout, unit);
    }

    public <K, SK> Object getHashCache(K key, SK subKey) {
        return this.redisTemplate.opsForHash().get((Object)("tw_" + key), subKey);
    }

    public <K, V> V getObject(K key, Class<V> clazz) {
        String value = this.get(key);
        Object result = null;
        if (StringUtils.hasLength((String)value)) {
            result = JSONObject.parseObject((String)value, clazz);
        }
        return (V)result;
    }

    public <K, V> List<V> getList(K key, Class<V> clazz) {
        String value = this.get(key);
        List result = Collections.emptyList();
        if (StringUtils.hasLength((String)value)) {
            result = JSONArray.parseArray((String)value, clazz);
        }
        return result;
    }

    public <K> String get(K key) {
        String value;
        try {
            value = (String)this.redisTemplate.opsForValue().get((Object)("tw_" + key));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException("\u4eceredis\u7f13\u5b58\u4e2d\u83b7\u53d6\u7f13\u5b58\u6570\u636e\u5931\u8d25");
        }
        return value;
    }

    public void delete(String key) {
        this.redisTemplate.delete((Object)key);
    }

    public void delete(Collection<String> keys) {
        this.redisTemplate.delete(keys);
    }

    public byte[] dump(String key) {
        return this.redisTemplate.dump((Object)key);
    }

    public Boolean hasKey(String key) {
        return this.redisTemplate.hasKey((Object)key);
    }

    public Boolean expire(String key, long timeout, TimeUnit unit) {
        return this.redisTemplate.expire((Object)key, timeout, unit);
    }

    public Boolean expireAt(String key, Date date) {
        return this.redisTemplate.expireAt((Object)key, date);
    }

    public Boolean persist(String key) {
        return this.redisTemplate.persist((Object)key);
    }

    public Long getExpire(String key, TimeUnit unit) {
        return this.redisTemplate.getExpire((Object)key, unit);
    }

    public Long getExpire(String key) {
        return this.redisTemplate.getExpire((Object)key);
    }
}

