/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.acc.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.acc.payload.AccBusinessItemPayload;
import com.elitesland.tw.tw5.api.prd.acc.query.AccBusinessItemQuery;
import com.elitesland.tw.tw5.api.prd.acc.service.AccBusinessItemService;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccBusinessItemVO;
import com.elitesland.tw.tw5.server.common.ExcelUtil;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.service.TransactionUtilService;
import com.elitesland.tw.tw5.server.prd.acc.convert.AccBusinessItemConvert;
import com.elitesland.tw.tw5.server.prd.acc.dao.AccBusinessItemDAO;
import com.elitesland.tw.tw5.server.prd.acc.entity.AccBusinessItemDO;
import com.elitesland.tw.tw5.server.prd.acc.repo.AccBusinessItemRepo;
import com.elitesland.tw.tw5.server.udc.UdcUtil;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
public class AccBusinessItemServiceImpl
extends BaseServiceImpl
implements AccBusinessItemService {
    private static final Logger log = LoggerFactory.getLogger(AccBusinessItemServiceImpl.class);
    private final AccBusinessItemRepo accBusinessItemRepo;
    private final AccBusinessItemDAO accBusinessItemDAO;
    private final ExcelUtil excelUtil;
    private final UdcUtil udcUtil;
    private final TransactionUtilService transactionUtilService;

    public PagingVO<AccBusinessItemVO> queryPaging(AccBusinessItemQuery query) {
        return this.accBusinessItemDAO.queryPaging(query);
    }

    public List<AccBusinessItemVO> queryListDynamic(AccBusinessItemQuery query) {
        return this.accBusinessItemDAO.queryListDynamic(query);
    }

    public AccBusinessItemVO queryByKey(Long key) {
        return this.accBusinessItemDAO.queryByKey(key);
    }

    @Transactional(rollbackFor={Exception.class})
    public AccBusinessItemVO insert(AccBusinessItemPayload payload) {
        this.checkData(payload);
        List<Long> ids = this.accBusinessItemDAO.queryByCodeAndName(payload.getBusinessCode(), payload.getBusinessName());
        if (ObjectUtils.isEmpty(ids)) {
            if (!StringUtils.hasText((String)payload.getBusinessStatus())) {
                payload.setBusinessStatus("ACTIVE");
            }
            payload.setBusinessLevel(Integer.valueOf(1));
            if (!ObjectUtils.isEmpty((Object)payload.getParentId())) {
                AccBusinessItemVO accBusinessItemVO = this.accBusinessItemDAO.queryByKey(payload.getParentId());
                payload.setBusinessLevel(Integer.valueOf(accBusinessItemVO.getBusinessLevel() + 1));
            }
            AccBusinessItemDO entityDo = AccBusinessItemConvert.INSTANCE.toDo(payload);
            return AccBusinessItemConvert.INSTANCE.toVo((AccBusinessItemDO)this.accBusinessItemRepo.save(entityDo));
        }
        throw TwException.error("", "\u79d1\u76ee\u7f16\u53f7\u548c\u540d\u79f0\u4e0d\u53ef\u91cd\u590d");
    }

    void checkData(AccBusinessItemPayload payload) {
        if (!StringUtils.hasText((String)payload.getBusinessCode()) || !StringUtils.hasText((String)payload.getBusinessName())) {
            throw TwException.error("", "\u7f16\u53f7\u548c\u540d\u79f0\u4e0d\u53ef\u4e3a\u7a7a");
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public long updateByKeyDynamic(AccBusinessItemPayload payload) {
        List<Long> ids = this.accBusinessItemDAO.queryByCodeAndName(payload.getBusinessCode(), payload.getBusinessName());
        if (ObjectUtils.isEmpty(ids) || ids.size() == 1 && ids.get(0).equals(payload.getId())) {
            payload.setBusinessLevel(Integer.valueOf(1));
            if (!ObjectUtils.isEmpty((Object)payload.getParentId())) {
                AccBusinessItemVO accBusinessItemVO = this.accBusinessItemDAO.queryByKey(payload.getParentId());
                payload.setBusinessLevel(Integer.valueOf(accBusinessItemVO.getBusinessLevel() + 1));
            }
            long result = this.accBusinessItemDAO.updateByKeyDynamic(payload);
            return result;
        }
        throw TwException.error("", "\u79d1\u76ee\u7f16\u53f7\u548c\u540d\u79f0\u4e0d\u53ef\u91cd\u590d");
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            this.accBusinessItemDAO.deleteSoft(keys);
        }
    }

    public void downloadPlus(HttpServletResponse response, AccBusinessItemQuery query) {
        ClassPathResource classPathResource = new ClassPathResource("template/accBusinessItem.xlsx");
        try {
            InputStream inputStream = classPathResource.getInputStream();
            Workbook workbook = WorkbookFactory.create((InputStream)inputStream);
            XSSFSheet batchProjectSheet = (XSSFSheet)workbook.getSheet("\u79d1\u76ee\u6570\u636e");
            this.excelUtil.generateRangeList(batchProjectSheet, 4, 1, "LOV", 2, "C");
            this.excelUtil.generateRangeList(batchProjectSheet, 5, 1, "LOV", 2, "E");
            this.excelUtil.generateRangeList(batchProjectSheet, 9, 1, "LOV", 2, "A");
            this.excelUtil.generateRangeList(batchProjectSheet, 3, 1, "\u79d1\u76ee\u6570\u636e", 2, "C");
            String fileName = "\u6838\u7b97\u9879\u76ee\u6570\u636e-" + LocalDate.now();
            Boolean isHave = false;
            if (!StringUtils.hasText((String)query.getDownloadType()) || query.getDownloadType().equals("data")) {
                List accBusinessItemVOS = this.accBusinessItemDAO.queryListDynamic(query);
                if (!ObjectUtils.isEmpty(accBusinessItemVOS)) {
                    accBusinessItemVOS = this.udcUtil.translateList(accBusinessItemVOS);
                    isHave = true;
                    int nextRow = 1;
                    for (AccBusinessItemVO accBusinessItemVO : accBusinessItemVOS) {
                        XSSFRow row = batchProjectSheet.createRow(nextRow);
                        Optional<AccBusinessItemVO> first = accBusinessItemVOS.stream().filter(vo -> vo.getId().equals(accBusinessItemVO.getParentId())).findFirst();
                        if (first.isPresent()) {
                            this.excelUtil.setCellValue((Row)row, 3, first.get().getBusinessName());
                        }
                        this.excelUtil.setCellValue((Row)row, 0, nextRow);
                        this.excelUtil.setCellValue((Row)row, 1, accBusinessItemVO.getBusinessCode());
                        this.excelUtil.setCellValue((Row)row, 2, accBusinessItemVO.getBusinessName());
                        this.excelUtil.setCellValue((Row)row, 4, accBusinessItemVO.getBusinessStatusDesc());
                        this.excelUtil.setCellValue((Row)row, 5, accBusinessItemVO.getBusinessTypeDesc());
                        this.excelUtil.setCellValue((Row)row, 6, accBusinessItemVO.getBusinessType2());
                        this.excelUtil.setCellValue((Row)row, 7, accBusinessItemVO.getBusinessType3());
                        this.excelUtil.setCellValue((Row)row, 8, accBusinessItemVO.getDtlAcc());
                        String sumFlag = "\u662f";
                        if (accBusinessItemVO.getSumFlag() == null || accBusinessItemVO.getSumFlag() == 0) {
                            sumFlag = "\u5426";
                        }
                        this.excelUtil.setCellValue((Row)row, 9, sumFlag);
                        this.excelUtil.setCellValue((Row)row, 10, accBusinessItemVO.getLedgerType());
                        this.excelUtil.setCellValue((Row)row, 11, accBusinessItemVO.getRemark());
                        ++nextRow;
                    }
                }
            } else {
                fileName = "\u6838\u7b97\u9879\u76ee\u5bfc\u5165\u6a21\u677f-" + LocalDate.now();
            }
            if (!isHave.booleanValue()) {
                this.excelUtil.setColumnFormulas(batchProjectSheet, 12, "VLOOKUP(D:rowNo,B:C,1,FALSE)");
                this.excelUtil.setColumnFormulas(batchProjectSheet, 13, "VLOOKUP(E:rowNo,LOV!C:D,2,FALSE)");
                this.excelUtil.setColumnFormulas(batchProjectSheet, 14, "VLOOKUP(F:rowNo,LOV!E:F,2,FALSE)");
                this.excelUtil.setColumnFormulas(batchProjectSheet, 15, "VLOOKUP(K:rowNo,LOV!A:B,2,FALSE)");
            }
            batchProjectSheet.setColumnHidden(12, true);
            batchProjectSheet.setColumnHidden(13, true);
            batchProjectSheet.setColumnHidden(14, true);
            batchProjectSheet.setColumnHidden(15, true);
            ExcelUtil.writeResponse(response, fileName, workbook);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean batchImport(MultipartFile file) {
        if (file == null) {
            throw TwException.error("", "\u4e0a\u4f20\u6587\u4ef6\u5f02\u5e38");
        }
        Workbook workbook = null;
        try {
            workbook = WorkbookFactory.create((InputStream)file.getInputStream());
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage());
            throw TwException.error("", "\u6587\u4ef6\u89e3\u6790\u5f02\u5e38");
        }
        Sheet sheet = workbook.getSheet("\u79d1\u76ee\u6570\u636e");
        if (sheet == null) {
            throw TwException.error("", "\u8868\u7ed3\u6784\u9519\u8bef");
        }
        int dataStartRow = 1;
        ArrayList<CallSite> codeNames = new ArrayList<CallSite>();
        HashMap<String, String> map = new HashMap<String, String>();
        ArrayList<AccBusinessItemPayload> accBusinessItemPayloads = new ArrayList<AccBusinessItemPayload>();
        for (int i = dataStartRow; i <= sheet.getLastRowNum(); ++i) {
            String sumFlag;
            Row row = sheet.getRow(i);
            String accCode = ExcelUtil.getCellFormatValue(row.getCell(1));
            String accName = ExcelUtil.getCellFormatValue(row.getCell(2));
            if (!StringUtils.hasText((String)accCode) || !StringUtils.hasText((String)accName)) break;
            map.put(accName, accCode);
            String codeStr = "," + accCode + ",";
            String nameStr = "," + accName + ",";
            if (codeNames.contains(codeStr) || codeNames.contains(nameStr)) {
                throw TwException.error("", "\u79d1\u76ee\u7f16\u53f7\u6216\u540d\u79f0\u4e0d\u53ef\u91cd\u590d:\u3010" + accCode + "-" + accName + "\u3011");
            }
            codeNames.add((CallSite)((Object)codeStr));
            codeNames.add((CallSite)((Object)nameStr));
            String upperName = ExcelUtil.getCellFormatValue(row.getCell(3));
            String accType2 = ExcelUtil.getCellFormatValue(row.getCell(6));
            String accType3 = ExcelUtil.getCellFormatValue(row.getCell(7));
            String dtlAcc = ExcelUtil.getCellFormatValue(row.getCell(8));
            String ledgerType = ExcelUtil.getCellFormatValue(row.getCell(10));
            String remark = ExcelUtil.getCellFormatValue(row.getCell(11));
            String upperCode = ExcelUtil.getCellFormatValue(row.getCell(12));
            String accStatus = ExcelUtil.getCellFormatValue(row.getCell(13));
            String businessType = ExcelUtil.getCellFormatValue(row.getCell(14));
            if (!StringUtils.hasText((String)accStatus)) {
                accStatus = "ACTIVE";
            }
            if (!StringUtils.hasText((String)(sumFlag = ExcelUtil.getCellFormatValue(row.getCell(15))))) {
                sumFlag = "0";
            }
            AccBusinessItemPayload accBusinessItemPayload2 = new AccBusinessItemPayload();
            accBusinessItemPayload2.setBusinessName(accName);
            accBusinessItemPayload2.setBusinessCode(accCode);
            accBusinessItemPayload2.setBusinessStatus(accStatus);
            accBusinessItemPayload2.setParentCode(upperCode);
            accBusinessItemPayload2.setParentName(upperName);
            accBusinessItemPayload2.setBusinessType(businessType);
            accBusinessItemPayload2.setBusinessType2(accType2);
            accBusinessItemPayload2.setBusinessType3(accType3);
            accBusinessItemPayload2.setLedgerType(ledgerType);
            accBusinessItemPayload2.setSumFlag(Integer.valueOf(sumFlag));
            accBusinessItemPayload2.setRemark(remark);
            accBusinessItemPayload2.setDtlAcc(dtlAcc);
            if (!StringUtils.hasText((String)upperName) && !StringUtils.hasText((String)upperCode)) {
                accBusinessItemPayload2.setBusinessLevel(Integer.valueOf(1));
            }
            accBusinessItemPayloads.add(accBusinessItemPayload2);
        }
        ArrayList<AccBusinessItemDO> accBusinessItemDOs = new ArrayList<AccBusinessItemDO>();
        accBusinessItemPayloads.forEach(accBusinessItemPayload -> {
            String upperName = accBusinessItemPayload.getParentName();
            String upperCode = accBusinessItemPayload.getParentCode();
            if (StringUtils.hasText((String)upperName)) {
                if (!StringUtils.hasText((String)upperCode)) {
                    accBusinessItemPayload.setParentCode((String)map.get(upperName));
                }
                this.setLevel((List<AccBusinessItemPayload>)accBusinessItemPayloads, (AccBusinessItemPayload)accBusinessItemPayload);
            }
            accBusinessItemDOs.add(AccBusinessItemConvert.INSTANCE.toDo((AccBusinessItemPayload)accBusinessItemPayload));
        });
        List<AccBusinessItemDO> accBusinessItemDOS = this.accBusinessItemDAO.saveAll(accBusinessItemDOs);
        ArrayList updataDOs = new ArrayList();
        accBusinessItemDOS.forEach(accBusinessItemDO -> {
            if (StringUtils.hasText((String)accBusinessItemDO.getParentCode())) {
                AccBusinessItemDO updataDO = accBusinessItemDOS.stream().filter(masPayload -> masPayload.getBusinessCode().equals(accBusinessItemDO.getParentCode())).findFirst().get();
                accBusinessItemDO.setParentId(updataDO.getId());
                updataDOs.add(accBusinessItemDO);
            }
        });
        this.transactionUtilService.executeWithRunnable(() -> this.accBusinessItemDAO.saveAll(updataDOs));
        return true;
    }

    void setLevel(List<AccBusinessItemPayload> accBusinessItemPayloads, AccBusinessItemPayload accBusinessItemPayload) {
        Optional<AccBusinessItemPayload> optional = accBusinessItemPayloads.stream().filter(masPayload -> masPayload.getBusinessCode().equals(accBusinessItemPayload.getParentCode())).findFirst();
        if (optional.isPresent()) {
            AccBusinessItemPayload payload = optional.get();
            if (payload.getBusinessLevel() == null) {
                this.setLevel(accBusinessItemPayloads, payload);
            }
            accBusinessItemPayload.setBusinessLevel(Integer.valueOf(payload.getBusinessLevel() + 1));
        } else {
            accBusinessItemPayload.setBusinessLevel(Integer.valueOf(1));
        }
    }

    public AccBusinessItemServiceImpl(AccBusinessItemRepo accBusinessItemRepo, AccBusinessItemDAO accBusinessItemDAO, ExcelUtil excelUtil, UdcUtil udcUtil, TransactionUtilService transactionUtilService) {
        this.accBusinessItemRepo = accBusinessItemRepo;
        this.accBusinessItemDAO = accBusinessItemDAO;
        this.excelUtil = excelUtil;
        this.udcUtil = udcUtil;
        this.transactionUtilService = transactionUtilService;
    }
}

