/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.crm.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmGiftInfoPayload;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmGiftInfoQuery;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmGiftListQuery;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmGiftInfoVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmGiftInfoDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.QCrmGiftInfoDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.QCrmGiftListDO;
import com.elitesland.tw.tw5.server.prd.crm.repo.CrmGiftInfoRepo;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Repository
public class CrmGiftInfoDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final CrmGiftInfoRepo repo;
    private final QCrmGiftInfoDO qdo = QCrmGiftInfoDO.crmGiftInfoDO;
    private final QCrmGiftListDO qgiftList = QCrmGiftListDO.crmGiftListDO;

    private JPAQuery<CrmGiftInfoVO> getJpaQuerySelect() {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(CrmGiftInfoVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.createUserId, this.qdo.creator, this.qdo.giftListId, this.qdo.giftName, this.qdo.giftNumber, this.qdo.giftUnit, this.qdo.customerId, this.qdo.custName, this.qdo.custAddress, this.qdo.custOperBu, this.qdo.jobDetail, this.qdo.mobile, this.qdo.locationDetail, this.qdo.reason, this.qdo.peopleId, this.qdo.peopleName})).from((EntityPath)this.qdo);
    }

    private JPAQuery<CrmGiftInfoVO> getJpaQuerySelect2() {
        return (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(CrmGiftInfoVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.giftListId, this.qdo.giftName, this.qdo.giftNumber, this.qdo.giftUnit, this.qdo.customerId, this.qdo.custName, this.qdo.custAddress, this.qdo.custOperBu, this.qdo.jobDetail, this.qdo.mobile, this.qdo.locationDetail, this.qdo.reason, this.qdo.peopleId, this.qdo.peopleName, this.qgiftList.giftNo, this.qgiftList.applyUserId, this.qgiftList.applyUserBuId, this.qgiftList.createUserBuId, this.qgiftList.applyDate, this.qgiftList.applyStatus, this.qgiftList.giftType1, this.qgiftList.giftType2, this.qgiftList.specialUsersFlag, this.qgiftList.procInstId, this.qgiftList.createUserId, this.qgiftList.creator})).from((EntityPath)this.qdo)).leftJoin((EntityPath)this.qgiftList)).on((Predicate)this.qdo.giftListId.eq(this.qgiftList.id));
    }

    private JPAQuery<CrmGiftInfoVO> getJpaQueryWhere(CrmGiftInfoQuery query) {
        JPAQuery<CrmGiftInfoVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.qdo._super, (TwQueryParam)query);
        jpaQuery.orderBy(SqlUtil.getSortedColumn(this.qdo, query.getOrders()));
        return jpaQuery;
    }

    private JPAQuery<CrmGiftInfoVO> getJpaQueryWhere(CrmGiftListQuery query) {
        JPAQuery<CrmGiftInfoVO> jpaQuery = this.getJpaQuerySelect2();
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.qdo._super, (TwQueryParam)query);
        jpaQuery.orderBy(SqlUtil.getSortedColumn(this.qgiftList, query.getOrders()));
        return jpaQuery;
    }

    public long count(CrmGiftInfoQuery query) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)this.qdo.count()).from((EntityPath)this.qdo);
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.qdo._super, (TwQueryParam)query);
        long total = (Long)jpaQuery.fetchOne();
        return total;
    }

    public long count(CrmGiftListQuery query) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)this.qdo.count()).from((EntityPath)this.qdo);
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.qdo._super, (TwQueryParam)query);
        long total = (Long)jpaQuery.fetchOne();
        return total;
    }

    private Predicate where(CrmGiftInfoQuery query) {
        ArrayList<BooleanExpression> list = new ArrayList<BooleanExpression>();
        if (!ObjectUtils.isEmpty((Object)query.getId())) {
            list.add(this.qdo.id.eq((Object)query.getId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getGiftListId())) {
            list.add(this.qdo.giftListId.eq((Object)query.getGiftListId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getGiftName())) {
            list.add(this.qdo.giftName.eq((Object)query.getGiftName()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getGiftNumber())) {
            list.add(this.qdo.giftNumber.eq((Object)query.getGiftNumber()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getGiftUnit())) {
            list.add(this.qdo.giftUnit.eq((Object)query.getGiftUnit()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCustName())) {
            list.add(this.qdo.custName.like(SqlUtil.toSqlLikeString(query.getCustName())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCustAddress())) {
            list.add(this.qdo.custAddress.eq((Object)query.getCustAddress()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCustOperBu())) {
            list.add(this.qdo.custOperBu.eq((Object)query.getCustOperBu()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getJobDetail())) {
            list.add(this.qdo.jobDetail.eq((Object)query.getJobDetail()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getMobile())) {
            list.add(this.qdo.mobile.eq((Object)query.getMobile()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getLocationDetail())) {
            list.add(this.qdo.locationDetail.eq((Object)query.getLocationDetail()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getReason())) {
            list.add(this.qdo.reason.eq((Object)query.getReason()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getPeopleName())) {
            list.add(this.qdo.peopleName.eq((Object)query.getPeopleName()));
        }
        return ExpressionUtils.allOf(list);
    }

    private Predicate where(CrmGiftListQuery query) {
        ArrayList<BooleanExpression> list = new ArrayList<BooleanExpression>();
        if (ObjectUtils.isEmpty((Object)query.getApplyUserId())) {
            if (!ObjectUtils.isEmpty((Object)query.getUserIds())) {
                list.add(this.qgiftList.createUserId.in((Collection)query.getUserIds()).or((Predicate)this.qgiftList.applyUserId.in((Collection)query.getUserIds())));
            }
        } else {
            list.add(this.qgiftList.applyUserId.eq((Object)query.getApplyUserId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getGiftNo())) {
            list.add(this.qgiftList.giftNo.like(SqlUtil.toSqlLikeString(query.getGiftNo())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getApplyUserBuId())) {
            list.add(this.qgiftList.applyUserBuId.eq((Object)query.getApplyUserBuId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCreateUserBuId())) {
            list.add(this.qgiftList.createUserBuId.eq((Object)query.getCreateUserBuId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getGiftType1())) {
            list.add(this.qgiftList.giftType1.eq((Object)query.getGiftType1()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getGiftType2())) {
            list.add(this.qgiftList.giftType2.eq((Object)query.getGiftType2()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getSpecialUsersFlag())) {
            list.add(this.qgiftList.specialUsersFlag.eq((Object)query.getSpecialUsersFlag()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getApplyStatus())) {
            list.add(this.qgiftList.applyStatus.eq((Object)query.getApplyStatus()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getProcInstStatus())) {
            list.add(this.qgiftList.procInstStatus.eq((Object)query.getProcInstStatus()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getApplyDate())) {
            list.add(this.qgiftList.applyDate.eq((Object)query.getApplyDate()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCustomerId())) {
            list.add(this.qdo.customerId.eq((Object)query.getCustomerId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCustName())) {
            list.add(this.qdo.custName.like(SqlUtil.toSqlLikeString(query.getCustName())));
        }
        if (!ObjectUtils.isEmpty((Object[])query.getKeys())) {
            list.add(this.qdo.id.in((Object[])query.getKeys()));
        }
        return ExpressionUtils.allOf(list);
    }

    public CrmGiftInfoVO queryByKey(Long id) {
        JPAQuery<CrmGiftInfoVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.id.eq((Object)id));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (CrmGiftInfoVO)jpaQuery.fetchFirst();
    }

    public List<CrmGiftInfoVO> queryListDynamic(CrmGiftInfoQuery query) {
        JPAQuery<CrmGiftInfoVO> jpaQuery = this.getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    public PagingVO<CrmGiftInfoVO> queryPaging(CrmGiftInfoQuery query) {
        long total = this.count(query);
        if (total == 0L) {
            return PagingVO.empty();
        }
        JPAQuery<CrmGiftInfoVO> jpaQuery = this.getJpaQueryWhere(query);
        List result = ((JPAQuery)((JPAQuery)jpaQuery.offset(query.getPageRequest().getOffset())).limit((long)query.getPageRequest().getPageSize())).fetch();
        return PagingVO.builder().records(result).total(total).build();
    }

    public PagingVO<CrmGiftInfoVO> pagingByGiftList(CrmGiftListQuery query) {
        JPAQuery<CrmGiftInfoVO> jpaQuery = this.getJpaQueryWhere(query);
        List result = jpaQuery.fetch();
        long total = result.size();
        if (total == 0L) {
            return PagingVO.empty();
        }
        List info = result.stream().skip(query.getPageRequest().getOffset()).limit(query.getPageRequest().getPageSize()).collect(Collectors.toList());
        return PagingVO.builder().records(info).total(total).build();
    }

    public List<CrmGiftInfoVO> byGiftList(CrmGiftListQuery query) {
        JPAQuery<CrmGiftInfoVO> jpaQuery = this.getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    public CrmGiftInfoDO save(CrmGiftInfoDO ado) {
        return (CrmGiftInfoDO)this.repo.save(ado);
    }

    public List<CrmGiftInfoDO> saveAll(List<CrmGiftInfoDO> dos) {
        return this.repo.saveAll(dos);
    }

    @Transactional
    public long updateByKeyDynamic(CrmGiftInfoPayload payload) {
        List nullFields;
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).where(new Predicate[]{this.qdo.id.eq((Object)payload.getId())});
        if (payload.getId() != null) {
            update.set(this.qdo.id, (Object)payload.getId());
        }
        if (payload.getGiftListId() != null) {
            update.set(this.qdo.giftListId, (Object)payload.getGiftListId());
        }
        if (payload.getGiftName() != null) {
            update.set((Path)this.qdo.giftName, (Object)payload.getGiftName());
        }
        if (payload.getGiftNumber() != null) {
            update.set((Path)this.qdo.giftNumber, (Object)payload.getGiftNumber());
        }
        if (payload.getGiftUnit() != null) {
            update.set((Path)this.qdo.giftUnit, (Object)payload.getGiftUnit());
        }
        if (payload.getCustName() != null) {
            update.set((Path)this.qdo.custName, (Object)payload.getCustName());
        }
        if (payload.getCustAddress() != null) {
            update.set((Path)this.qdo.custAddress, (Object)payload.getCustAddress());
        }
        if (payload.getCustOperBu() != null) {
            update.set((Path)this.qdo.custOperBu, (Object)payload.getCustOperBu());
        }
        if (payload.getJobDetail() != null) {
            update.set((Path)this.qdo.jobDetail, (Object)payload.getJobDetail());
        }
        if (payload.getMobile() != null) {
            update.set((Path)this.qdo.mobile, (Object)payload.getMobile());
        }
        if (payload.getLocationDetail() != null) {
            update.set((Path)this.qdo.locationDetail, (Object)payload.getLocationDetail());
        }
        if (payload.getReason() != null) {
            update.set((Path)this.qdo.reason, (Object)payload.getReason());
        }
        if (payload.getPeopleName() != null) {
            update.set((Path)this.qdo.peopleName, (Object)payload.getPeopleName());
        }
        if ((nullFields = payload.getNullFields()) != null && nullFields.size() > 0) {
            if (nullFields.contains("id")) {
                update.setNull(this.qdo.id);
            }
            if (nullFields.contains("giftListId")) {
                update.setNull(this.qdo.giftListId);
            }
            if (nullFields.contains("giftName")) {
                update.setNull((Path)this.qdo.giftName);
            }
            if (nullFields.contains("giftNumber")) {
                update.setNull((Path)this.qdo.giftNumber);
            }
            if (nullFields.contains("giftUnit")) {
                update.setNull((Path)this.qdo.giftUnit);
            }
            if (nullFields.contains("custName")) {
                update.setNull((Path)this.qdo.custName);
            }
            if (nullFields.contains("custAddress")) {
                update.setNull((Path)this.qdo.custAddress);
            }
            if (nullFields.contains("custOperBu")) {
                update.setNull((Path)this.qdo.custOperBu);
            }
            if (nullFields.contains("jobDetail")) {
                update.setNull((Path)this.qdo.jobDetail);
            }
            if (nullFields.contains("mobile")) {
                update.setNull((Path)this.qdo.mobile);
            }
            if (nullFields.contains("locationDetail")) {
                update.setNull((Path)this.qdo.locationDetail);
            }
            if (nullFields.contains("reason")) {
                update.setNull((Path)this.qdo.reason);
            }
            if (nullFields.contains("peopleName")) {
                update.setNull((Path)this.qdo.peopleName);
            }
        }
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.id.in(keys)});
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public CrmGiftInfoDAO(JPAQueryFactory jpaQueryFactory, CrmGiftInfoRepo repo) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.repo = repo;
    }
}

