/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.crm.service;

import com.elitesland.tw.tw5.api.prd.crm.query.CrmLeadsOffshoreQuery;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmPotentialCustomerQuery;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmCommonService;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectQuery;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmLeadsOffshoreDAO;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmPotentialCustomerDAO;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmLeadsOffshoreDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmPotentialCustomerDO;
import com.elitesland.tw.tw5.server.prd.pms.dao.PmsProjectDAO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class CrmCommonSerciceImpl
implements CrmCommonService {
    private static final Logger log = LoggerFactory.getLogger(CrmCommonSerciceImpl.class);
    private final CrmLeadsOffshoreDAO leadsOffshoreDAO;
    private final CrmPotentialCustomerDAO potentialCustomerDAO;
    private final PmsProjectDAO pmsProjectDAO;
    private final CacheUtil cacheUtil;

    public List<Map<String, Object>> checkRepeat(String type, String checkValue) {
        HashMap<String, Object> map;
        CrmPotentialCustomerQuery query = new CrmPotentialCustomerQuery();
        CrmLeadsOffshoreQuery leadsQuery = new CrmLeadsOffshoreQuery();
        List<Object> crmPotentialCustomerDOs = new ArrayList();
        List<Object> leadsDOs = new ArrayList();
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        switch (type) {
            case "company": {
                leadsQuery.setCustomerNameEqual(checkValue);
                query.setCustomerNameEqual(checkValue);
                crmPotentialCustomerDOs = this.queryPotentialCustomerList(query);
                leadsDOs = this.queryLeadsList(leadsQuery);
                break;
            }
            case "phone": {
                leadsQuery.setContactsPhone(checkValue);
                query.setCustomerPhone(checkValue);
                crmPotentialCustomerDOs = this.queryPotentialCustomerList(query);
                leadsDOs = this.queryLeadsList(leadsQuery);
            }
        }
        if (crmPotentialCustomerDOs != null && !crmPotentialCustomerDOs.isEmpty()) {
            for (CrmPotentialCustomerDO customer : crmPotentialCustomerDOs) {
                map = new HashMap<String, Object>();
                map.put("repeatType", "\u6f5c\u5728\u5ba2\u6237");
                map.put("id", customer.getId());
                map.put("companyName", customer.getCustomerName());
                map.put("contactsName", customer.getCustomerContacts());
                map.put("contactsPhone", customer.getCustomerPhone());
                map.put("salesMan", null);
                list.add(map);
            }
        }
        if (leadsDOs != null && !leadsDOs.isEmpty()) {
            for (CrmLeadsOffshoreDO leadsOffshoreDO : leadsDOs) {
                map = new HashMap();
                map.put("repeatType", "\u7ebf\u7d22");
                map.put("id", leadsOffshoreDO.getId());
                map.put("companyName", leadsOffshoreDO.getLeads().getCustomer().getCustomerName());
                map.put("contactsName", leadsOffshoreDO.getLeads().getCustomer().getCustomerContacts());
                map.put("contactsPhone", leadsOffshoreDO.getLeads().getCustomer().getContactsPhone());
                Long saleUserId = leadsOffshoreDO.getLeads().getSaleUserId();
                if (saleUserId != null) {
                    map.put("salesMan", this.cacheUtil.getUserName(saleUserId));
                } else {
                    map.put("salesMan", null);
                }
                list.add(map);
            }
        }
        return list;
    }

    public List<Map<String, Object>> checkRepeatPro(Map<String, Object> param, String type, String checkValue) {
        HashMap<String, Object> map;
        List crmPotentialCustomerDOList = (List)param.get("crmPotentialCustomerDOList");
        List crmLeadsOffshoreDOList = (List)param.get("crmLeadsOffshoreDOList");
        List<Object> crmPotentialCustomerDOs = new ArrayList();
        List<Object> leadsDOs = new ArrayList();
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        switch (type) {
            case "company": {
                crmPotentialCustomerDOs = crmPotentialCustomerDOList.stream().filter(crmPotentialCustomerDO -> StringUtils.hasText((String)crmPotentialCustomerDO.getCustomerName()) && crmPotentialCustomerDO.getCustomerName().equals(checkValue)).collect(Collectors.toList());
                leadsDOs = crmLeadsOffshoreDOList.stream().filter(crmLeadsOffshoreDO -> crmLeadsOffshoreDO.getLeads().getCustomer().getCustomerName().equals(checkValue)).collect(Collectors.toList());
                break;
            }
            case "phone": {
                crmPotentialCustomerDOs = crmPotentialCustomerDOList.stream().filter(crmPotentialCustomerDO -> StringUtils.hasText((String)crmPotentialCustomerDO.getCustomerPhone()) && crmPotentialCustomerDO.getCustomerPhone().equals(checkValue)).collect(Collectors.toList());
                leadsDOs = crmLeadsOffshoreDOList.stream().filter(crmLeadsOffshoreDO -> crmLeadsOffshoreDO.getLeads().getCustomer().getContactsPhone() != null && crmLeadsOffshoreDO.getLeads().getCustomer().getContactsPhone().equals(checkValue)).collect(Collectors.toList());
            }
        }
        if (crmPotentialCustomerDOs != null && !crmPotentialCustomerDOs.isEmpty()) {
            for (CrmPotentialCustomerDO customer : crmPotentialCustomerDOs) {
                map = new HashMap<String, Object>();
                map.put("repeatType", "\u6f5c\u5728\u5ba2\u6237");
                map.put("id", customer.getId());
                map.put("companyName", customer.getCustomerName());
                map.put("contactsName", customer.getCustomerContacts());
                map.put("contactsPhone", customer.getCustomerPhone());
                map.put("salesMan", null);
                list.add(map);
            }
        }
        if (leadsDOs != null && !leadsDOs.isEmpty()) {
            for (CrmLeadsOffshoreDO leadsOffshoreDO : leadsDOs) {
                map = new HashMap();
                map.put("repeatType", "\u7ebf\u7d22");
                map.put("id", leadsOffshoreDO.getId());
                map.put("companyName", leadsOffshoreDO.getLeads().getCustomer().getCustomerName());
                map.put("contactsName", leadsOffshoreDO.getLeads().getCustomer().getCustomerContacts());
                map.put("contactsPhone", leadsOffshoreDO.getLeads().getCustomer().getContactsPhone());
                Long saleUserId = leadsOffshoreDO.getLeads().getSaleUserId();
                if (saleUserId != null) {
                    map.put("salesMan", this.cacheUtil.getUserName(saleUserId));
                } else {
                    map.put("salesMan", null);
                }
                list.add(map);
            }
        }
        return list;
    }

    public List<CrmLeadsOffshoreDO> queryLeadsList(CrmLeadsOffshoreQuery leadsOffshoreQuery) {
        Specification<CrmLeadsOffshoreDO> spec = this.leadsOffshoreDAO.getSpec(leadsOffshoreQuery);
        List<CrmLeadsOffshoreDO> content = this.leadsOffshoreDAO.findAll(spec);
        return content;
    }

    public List<CrmPotentialCustomerDO> queryPotentialCustomerList(CrmPotentialCustomerQuery query) {
        Specification<CrmPotentialCustomerDO> spec = this.potentialCustomerDAO.getSpec(query);
        return this.potentialCustomerDAO.findAll(spec);
    }

    public long queryProjectNum(Long customerId) {
        PmsProjectQuery query = new PmsProjectQuery();
        query.setCustomerId(customerId);
        query.setMainType("SUB");
        return this.pmsProjectDAO.count(query);
    }

    public CrmCommonSerciceImpl(CrmLeadsOffshoreDAO leadsOffshoreDAO, CrmPotentialCustomerDAO potentialCustomerDAO, PmsProjectDAO pmsProjectDAO, CacheUtil cacheUtil) {
        this.leadsOffshoreDAO = leadsOffshoreDAO;
        this.potentialCustomerDAO = potentialCustomerDAO;
        this.pmsProjectDAO = pmsProjectDAO;
        this.cacheUtil = cacheUtil;
    }
}

