/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.file.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.file.payload.PrdFileRefPayload;
import com.elitesland.tw.tw5.api.prd.file.query.PrdFileRefQuery;
import com.elitesland.tw.tw5.api.prd.file.service.PrdFileRefService;
import com.elitesland.tw.tw5.api.prd.file.service.PrdFileService;
import com.elitesland.tw.tw5.api.prd.file.vo.PrdFileRefVO;
import com.elitesland.tw.tw5.api.prd.file.vo.PrdFileVO;
import com.elitesland.tw.tw5.server.common.QueryHelp;
import com.elitesland.tw.tw5.server.common.util.PageUtil;
import com.elitesland.tw.tw5.server.prd.file.convert.PrdFileRefConvert;
import com.elitesland.tw.tw5.server.prd.file.entity.PrdFileRefDO;
import com.elitesland.tw.tw5.server.prd.file.repo.PrdFileRefRepo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class PrdFileRefServiceImpl
implements PrdFileRefService {
    private static final Logger log = LoggerFactory.getLogger(PrdFileRefServiceImpl.class);
    private final PrdFileRefRepo prdFileRefRepo;
    private final PrdFileService prdFileService;

    @Transactional(rollbackFor={Exception.class})
    public PrdFileRefVO insert(PrdFileRefPayload payload) {
        PrdFileRefDO entityDo = PrdFileRefConvert.INSTANCE.toDo(payload);
        this.prdFileRefRepo.save(entityDo);
        return PrdFileRefConvert.INSTANCE.toVo(entityDo);
    }

    @Transactional(rollbackFor={Exception.class})
    public PrdFileRefVO insert(Long fileId, Long docId, String businessType, String docType) {
        PrdFileRefDO entity = new PrdFileRefDO();
        entity.setFileId(fileId);
        entity.setBusinessType(businessType);
        entity.setDocType(docType);
        entity.setDocId(docId);
        this.prdFileRefRepo.save(entity);
        return PrdFileRefConvert.INSTANCE.toVo(entity);
    }

    public List<PrdFileVO> listFile(Long docId, String businessType, String docType) {
        Assert.notNull((Object)docId, (String)"docId is not null");
        Assert.hasLength((String)businessType, (String)"businessType is not empty");
        Assert.hasLength((String)docType, (String)"docType is not empty");
        PrdFileRefQuery query = new PrdFileRefQuery();
        query.setDocId(docId);
        query.setBusinessType(businessType);
        query.setDocType(docType);
        List<PrdFileRefVO> prdFileRefVOS = this.queryList(query);
        ArrayList<PrdFileVO> listFile = new ArrayList<PrdFileVO>();
        prdFileRefVOS.forEach(prdFileRefVO -> {
            PrdFileVO prdFileVO = this.prdFileService.queryByKey(prdFileRefVO.getFileId());
            listFile.add(prdFileVO);
        });
        return listFile;
    }

    @Transactional(rollbackFor={Exception.class})
    public PrdFileRefVO update(PrdFileRefPayload payload) {
        PrdFileRefDO entity = this.prdFileRefRepo.findById(payload.getId()).orElseGet(PrdFileRefDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u9644\u4ef6\u4e0d\u5b58\u5728");
        PrdFileRefDO entityDo = PrdFileRefConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return PrdFileRefConvert.INSTANCE.toVo((PrdFileRefDO)this.prdFileRefRepo.save(entity));
    }

    public PrdFileRefVO queryByKey(Long key) {
        PrdFileRefDO entity = this.prdFileRefRepo.findById(key).orElseGet(PrdFileRefDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u9644\u4ef6\u4e0d\u5b58\u5728");
        return PrdFileRefConvert.INSTANCE.toVo(entity);
    }

    public List<PrdFileRefVO> queryList(PrdFileRefQuery query) {
        return PrdFileRefConvert.INSTANCE.toVoList(this.prdFileRefRepo.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder)));
    }

    public PagingVO<PrdFileRefVO> paging(PrdFileRefQuery query) {
        Page page = this.prdFileRefRepo.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder), (Pageable)query.getPageRequest());
        return PageUtil.toPageVo(page.map(PrdFileRefConvert.INSTANCE::toVo));
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            this.prdFileRefRepo.deleteSoft(keys);
        }
    }

    public PrdFileRefServiceImpl(PrdFileRefRepo prdFileRefRepo, PrdFileService prdFileService) {
        this.prdFileRefRepo = prdFileRefRepo;
        this.prdFileService = prdFileService;
    }
}

