/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.my.service;

import cn.hutool.core.bean.BeanUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.my.payload.TimesheetPlanListPayload;
import com.elitesland.tw.tw5.api.prd.my.payload.TimesheetPlanPayload;
import com.elitesland.tw.tw5.api.prd.my.query.TimesheetBiweeklyQuery;
import com.elitesland.tw.tw5.api.prd.my.query.TimesheetPlanQuery;
import com.elitesland.tw.tw5.api.prd.my.service.PmsTimesheetPlanService;
import com.elitesland.tw.tw5.api.prd.my.vo.ProjectAndTaskVO;
import com.elitesland.tw.tw5.api.prd.my.vo.TimesheetPlanVO;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectActivityService;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectService;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectVO;
import com.elitesland.tw.tw5.api.prd.task.service.TaskInfoService;
import com.elitesland.tw.tw5.api.prd.task.service.TaskPackageService;
import com.elitesland.tw.tw5.api.prd.task.vo.TaskInfoVO;
import com.elitesland.tw.tw5.api.prd.task.vo.TaskPackageVO;
import com.elitesland.tw.tw5.server.common.QueryHelp;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.util.DateUtil;
import com.elitesland.tw.tw5.server.common.util.PageUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.my.convert.TimesheetPlanConvert;
import com.elitesland.tw.tw5.server.prd.my.entity.QTimesheetPlanDO;
import com.elitesland.tw.tw5.server.prd.my.entity.TimesheetPlanDO;
import com.elitesland.tw.tw5.server.prd.my.repo.TimesheetBiweeklyReadFlagRepo;
import com.elitesland.tw.tw5.server.prd.my.repo.TimesheetBiweeklyRepo;
import com.elitesland.tw.tw5.server.prd.my.repo.TimesheetPlanRepo;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class PmsTimesheetPlanServiceImpl
implements PmsTimesheetPlanService {
    private static final Logger log = LoggerFactory.getLogger(PmsTimesheetPlanServiceImpl.class);
    private final TimesheetPlanRepo timesheetPlanRepo;
    private final PmsProjectService pmsProjectService;
    private final TaskPackageService taskPackageService;
    private final TaskInfoService taskInfoService;
    private final PmsProjectActivityService pmsProjectActivityService;
    private final JPAQueryFactory jpaQueryFactory;
    private final TimesheetBiweeklyRepo timesheetBiweeklyRepo;
    private final TimesheetBiweeklyReadFlagRepo biweeklyReadFlagRepo;

    public PagingVO<TimesheetPlanVO> paging(TimesheetPlanQuery query) {
        Page page = this.timesheetPlanRepo.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder), (Pageable)query.getPageRequest());
        return PageUtil.toPageVo(page.map(TimesheetPlanConvert.INSTANCE::toVo));
    }

    public List<TimesheetPlanVO> queryList(TimesheetPlanQuery query) {
        return TimesheetPlanConvert.INSTANCE.toVoList(this.timesheetPlanRepo.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder)));
    }

    private List<TimesheetPlanDO> queryDoList(TimesheetPlanQuery query) {
        return this.timesheetPlanRepo.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder));
    }

    public TimesheetPlanVO queryByKey(Long key) {
        TimesheetPlanDO entity = this.timesheetPlanRepo.findById(key).orElseGet(TimesheetPlanDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        TimesheetPlanVO vo = TimesheetPlanConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public TimesheetPlanVO insert(TimesheetPlanPayload payload) {
        payload.setTsUserId(GlobalUtil.getLoginUserId());
        this.check(payload);
        this.dataProcess(payload);
        this.biweeklyReadFlagRepo.updateReadFlag(payload.getTsUserId(), 0);
        TimesheetPlanDO entityDo = TimesheetPlanConvert.INSTANCE.toDo(payload);
        return TimesheetPlanConvert.INSTANCE.toVo((TimesheetPlanDO)((Object)this.timesheetPlanRepo.save((Object)entityDo)));
    }

    private void check(TimesheetPlanPayload payload) {
        LocalDate workDate = payload.getWorkDate();
        if (!(!workDate.isBefore(LocalDate.now()) || workDate.isEqual(LocalDate.now()) || payload.getExt5() != null && payload.getExt5().equals("EMPTY"))) {
            throw TwException.error("", "\u53ea\u5141\u8bb8\u63d0\u4ea4\u4eca\u5929\u53ca\u4ee5\u540e\u7684\u8ba1\u5212\uff01");
        }
        if (null == payload.getProjId()) {
            throw TwException.error("", "\u53c2\u6570\u5f02\u5e38\uff1aprojId");
        }
        if (null == payload.getTaskPackageId()) {
            throw TwException.error("", "\u53c2\u6570\u5f02\u5e38\uff1ataskPackageId");
        }
    }

    private void dataProcess(TimesheetPlanPayload payload) {
        if (payload.getWorkDate() != null) {
            payload.setYearWeek(Integer.valueOf(Integer.parseInt(DateUtil.getYearWeek(payload.getWorkDate()))));
            payload.setWeekStartDate(DateUtil.getStartWeekDay(payload.getWorkDate()));
        }
        if (null != payload.getProjId()) {
            PmsProjectVO projectVO = this.pmsProjectService.queryByKeySimple(payload.getProjId());
            if (!StringUtils.hasText((String)payload.getProjNo())) {
                payload.setProjNo(null != projectVO ? projectVO.getProjNo() : "");
            }
            if (!StringUtils.hasText((String)payload.getProjName())) {
                payload.setProjName(null != projectVO ? projectVO.getProjName() : "");
            }
        }
        if (payload.getTaskPackageId() != null) {
            TaskPackageVO taskPackageVO = this.taskPackageService.queryByKey(payload.getTaskPackageId(), Boolean.valueOf(false));
            if (!StringUtils.hasText((String)payload.getTaskPackageNo())) {
                payload.setTaskPackageNo(null != taskPackageVO ? taskPackageVO.getTaskPackageNo() : "");
            }
            if (!StringUtils.hasText((String)payload.getTaskPackageName())) {
                payload.setTaskPackageName(null != taskPackageVO ? taskPackageVO.getTaskPackageName() : "");
            }
            if (ObjectUtils.isEmpty((Object)payload.getReasonId())) {
                payload.setReasonId(null != taskPackageVO ? taskPackageVO.getReasonId() : null);
            }
            if (!StringUtils.hasText((String)payload.getReasonType())) {
                payload.setReasonType(null != taskPackageVO ? taskPackageVO.getReasonType() : "");
            }
            if (!StringUtils.hasText((String)payload.getReasonName())) {
                payload.setReasonName(null != taskPackageVO ? taskPackageVO.getReasonName() : "");
            }
        }
        if (null != payload.getTaskId()) {
            TaskInfoVO taskVO = this.taskInfoService.queryByKey(payload.getTaskId(), Boolean.valueOf(false));
            if (!StringUtils.hasText((String)payload.getTaskNo())) {
                payload.setTaskNo(null != taskVO ? taskVO.getTaskNo() : "");
            }
            if (!StringUtils.hasText((String)payload.getTaskName())) {
                payload.setTaskName(null != taskVO ? taskVO.getTaskName() : "");
            }
            if (null == payload.getEqva()) {
                payload.setEqva(null != taskVO ? taskVO.getValidEqva() : BigDecimal.ZERO);
            }
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public TimesheetPlanVO update(TimesheetPlanPayload payload) {
        TimesheetPlanDO entity = this.timesheetPlanRepo.findById(payload.getId()).orElseGet(TimesheetPlanDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        this.dataProcess(payload);
        TimesheetPlanDO entityDo = TimesheetPlanConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return TimesheetPlanConvert.INSTANCE.toVo((TimesheetPlanDO)((Object)this.timesheetPlanRepo.save((Object)entity)));
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional optional = this.timesheetPlanRepo.findById(id);
                if (!optional.isEmpty()) {
                    TimesheetPlanDO entity = (TimesheetPlanDO)((Object)((Object)optional.get()));
                    TimesheetBiweeklyQuery timesheetBiweeklyQuery = new TimesheetBiweeklyQuery();
                    timesheetBiweeklyQuery.setYearWeek(entity.getYearWeek());
                    timesheetBiweeklyQuery.setTsUserId(entity.getTsUserId());
                    Long count = this.timesheetBiweeklyRepo.count((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, timesheetBiweeklyQuery, criteriaBuilder));
                    if (count > 0L) {
                        throw TwException.error("", "\u5ba1\u6279\u4e2d\u7684\u6570\u636e\u4e0d\u53ef\u4ee5\u5220\u9664");
                    }
                    this.timesheetPlanRepo.deleteSoft(Collections.singletonList(id));
                }
            });
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoftByYearWeek(Integer yeerWeek, Long loginUserId) {
        if (null != yeerWeek) {
            LocalDateTime now = LocalDateTime.now();
            QTimesheetPlanDO qTimesheetPlanDO = QTimesheetPlanDO.timesheetPlanDO;
            JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)qTimesheetPlanDO).set(qTimesheetPlanDO.deleteFlag, (Object)1).set((Path)qTimesheetPlanDO.updater, (Object)GlobalUtil.getLoginUserName()).set(qTimesheetPlanDO.modifyTime, (Object)now).where(new Predicate[]{qTimesheetPlanDO.yearWeek.eq((Object)yeerWeek)}).where(new Predicate[]{qTimesheetPlanDO.tsUserId.eq((Object)loginUserId)});
            update.execute();
        }
    }

    public List<ProjectAndTaskVO> listProjAndTask(String keyword, String type, boolean test) {
        ArrayList<ProjectAndTaskVO> list = new ArrayList<ProjectAndTaskVO>();
        return list;
    }

    public List<TimesheetPlanVO> batchInsert(TimesheetPlanListPayload payload) {
        ArrayList<TimesheetPlanVO> list = new ArrayList<TimesheetPlanVO>();
        List timesheetPlanList = payload.getTimesheetPlanList();
        if (!CollectionUtils.isEmpty((Collection)timesheetPlanList)) {
            timesheetPlanList.forEach(timesheetPlanPayload -> list.add(this.insert((TimesheetPlanPayload)timesheetPlanPayload)));
        }
        return list;
    }

    @Transactional(rollbackFor={Exception.class})
    public List<TimesheetPlanVO> copyLastWeek(String date) {
        LocalDate localDate = LocalDate.now();
        if (StringUtils.hasText((String)date)) {
            localDate = LocalDate.parse(date);
        }
        LocalDate lastWeekDate = localDate.plusDays(-7L);
        int yearWeek = Integer.parseInt(DateUtil.getYearWeek(localDate));
        String lastYearWeek = DateUtil.getYearWeek(lastWeekDate);
        TimesheetPlanQuery timesheetPlanQuery = new TimesheetPlanQuery();
        timesheetPlanQuery.setYearWeek(Integer.valueOf(Integer.parseInt(lastYearWeek)));
        Long loginUserId = GlobalUtil.getLoginUserId();
        timesheetPlanQuery.setTsUserId(loginUserId);
        List<TimesheetPlanDO> timesheetPlanDOS = this.queryDoList(timesheetPlanQuery);
        TimesheetBiweeklyQuery timesheetBiweeklyQuery = new TimesheetBiweeklyQuery();
        timesheetBiweeklyQuery.setYearWeek(Integer.valueOf(yearWeek));
        timesheetBiweeklyQuery.setTsUserId(loginUserId);
        Long count = this.timesheetBiweeklyRepo.count((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, timesheetBiweeklyQuery, criteriaBuilder));
        if (count > 0L) {
            throw TwException.error("", "\u5de5\u4f5c\u8ba1\u5212\u63d0\u4ea4\u540e\u4e0d\u53ef\u4fee\u6539");
        }
        this.deleteSoftByYearWeek(yearWeek, loginUserId);
        ArrayList<TimesheetPlanVO> result = new ArrayList<TimesheetPlanVO>();
        if (!CollectionUtils.isEmpty(timesheetPlanDOS)) {
            timesheetPlanDOS.forEach(timesheetPlanDO -> {
                TimesheetPlanDO entity = new TimesheetPlanDO();
                BeanUtil.copyProperties((Object)timesheetPlanDO, (Object)((Object)entity), (String[])new String[0]);
                entity.setId(null);
                entity.setCreateTime(LocalDateTime.now());
                entity.setCreator(GlobalUtil.getLoginUserName());
                entity.setCreateUserId(loginUserId);
                entity.setModifyTime(LocalDateTime.now());
                entity.setModifyUserId(loginUserId);
                entity.setUpdater(GlobalUtil.getLoginUserName());
                LocalDate workDate = timesheetPlanDO.getWorkDate();
                if (null != workDate) {
                    LocalDate nextWeekWorkDate = workDate.plusDays(7L);
                    entity.setWorkDate(nextWeekWorkDate);
                    entity.setYearWeek(Integer.parseInt(DateUtil.getYearWeek(nextWeekWorkDate)));
                    entity.setWeekStartDate(DateUtil.getStartWeekDay(nextWeekWorkDate));
                    entity.setExt1("\u590d\u5236\u4e0a\u5468");
                }
                TimesheetPlanDO save = (TimesheetPlanDO)((Object)((Object)this.timesheetPlanRepo.save((Object)entity)));
                result.add(TimesheetPlanConvert.INSTANCE.toVo(save));
            });
        }
        return result;
    }

    public void syncWorkPlanTo4(String param) {
        log.warn("\u5de5\u4f5c\u8ba1\u5212\u540c\u6b65\u5df2\u5e9f\u5f03...");
    }

    public PmsTimesheetPlanServiceImpl(TimesheetPlanRepo timesheetPlanRepo, PmsProjectService pmsProjectService, TaskPackageService taskPackageService, TaskInfoService taskInfoService, PmsProjectActivityService pmsProjectActivityService, JPAQueryFactory jpaQueryFactory, TimesheetBiweeklyRepo timesheetBiweeklyRepo, TimesheetBiweeklyReadFlagRepo biweeklyReadFlagRepo) {
        this.timesheetPlanRepo = timesheetPlanRepo;
        this.pmsProjectService = pmsProjectService;
        this.taskPackageService = taskPackageService;
        this.taskInfoService = taskInfoService;
        this.pmsProjectActivityService = pmsProjectActivityService;
        this.jpaQueryFactory = jpaQueryFactory;
        this.timesheetBiweeklyRepo = timesheetBiweeklyRepo;
        this.biweeklyReadFlagRepo = biweeklyReadFlagRepo;
    }
}

