/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.pms.service;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdCompositeAbilityQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdCompositeAbilityService;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdCompositeAbilityVO;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsProjectMembersPayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectMembersQuery;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectMembersService;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectMembersVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemSettingVO;
import com.elitesland.tw.tw5.api.prd.task.service.TaskCommonService;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.PmsReasonTypeEnum;
import com.elitesland.tw.tw5.server.prd.pms.convert.PmsProjectMembersConvert;
import com.elitesland.tw.tw5.server.prd.pms.dao.PmsProjectMembersDAO;
import com.elitesland.tw.tw5.server.prd.pms.entity.PmsProjectMembersDO;
import com.elitesland.tw.tw5.server.prd.pms.repo.PmsProjectMembersRepo;
import com.elitesland.tw.tw5.server.prd.system.constant.SystemSettingsItemEnum;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class PmsProjectMembersServiceImpl
extends BaseServiceImpl
implements PmsProjectMembersService {
    private static final Logger log = LoggerFactory.getLogger(PmsProjectMembersServiceImpl.class);
    private final PmsProjectMembersRepo pmsProjectMembersRepo;
    private final PmsProjectMembersDAO pmsProjectMembersDAO;
    private final PrdCompositeAbilityService prdCompositeAbilityService;
    private final TaskCommonService taskCommonService;
    private final CacheUtil cacheUtil;

    public Long countTreeByProjId(PmsProjectMembersQuery query) {
        return this.pmsProjectMembersDAO.count(query);
    }

    public List<PmsProjectMembersVO> queryTreeByProjId(PmsProjectMembersQuery query) {
        List<PmsProjectMembersVO> membersVOS = this.pmsProjectMembersDAO.queryListDynamic(query);
        return membersVOS;
    }

    public PagingVO<PmsProjectMembersVO> queryPaging(PmsProjectMembersQuery query) {
        return this.pmsProjectMembersDAO.queryPaging(query);
    }

    public List<PmsProjectMembersVO> queryListDynamic(PmsProjectMembersQuery query) {
        if (ObjectUtils.isEmpty((Object)query.getProjId())) {
            throw TwException.error("", "\u9879\u76eeid \u4e0d\u80fd\u4e3a\u7a7a ");
        }
        List<PmsProjectMembersVO> membersVOS = this.pmsProjectMembersDAO.queryListDynamic(query);
        this.setCapaInfo(membersVOS);
        return membersVOS;
    }

    public PmsProjectMembersVO queryByKey(Long key) {
        PmsProjectMembersDO entity = this.pmsProjectMembersRepo.findById(key).orElseGet(PmsProjectMembersDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        PmsProjectMembersVO vo = PmsProjectMembersConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public PmsProjectMembersVO insertOrUpdate(PmsProjectMembersPayload payload) {
        PmsProjectMembersVO vo;
        this.checkData(payload);
        if (ObjectUtils.isEmpty((Object)payload.getWorkbenchFlag())) {
            payload.setWorkbenchFlag(Integer.valueOf(1));
        }
        if (!(ObjectUtils.isEmpty((Object)payload.getResId()) || ObjectUtils.isEmpty((Object)(vo = this.pmsProjectMembersDAO.queryByProjAndRes(payload.getProjId(), payload.getResId()))) || payload.getId() != null && vo.getId().equals(payload.getId()))) {
            throw TwException.error("", "\u9879\u76ee\u6210\u5458\u5df2\u7ecf\u5b58\u5728\uff01");
        }
        PmsProjectMembersDO save = this.pmsProjectMembersDAO.save(PmsProjectMembersConvert.INSTANCE.toDo(payload));
        PrdSystemSettingVO settingVO = this.cacheUtil.getSystemSetting(SystemSettingsItemEnum.prj_member_init_task.getCode());
        if (settingVO != null && StringUtils.hasText((String)settingVO.getSettingValue()) && "true".equals(settingVO.getSettingValue())) {
            this.taskCommonService.batchCreatTaskPackage(PmsReasonTypeEnum.PROJ_CONTRACT.getCode(), payload.getProjId(), Arrays.asList(payload.getResId()), null);
        }
        return PmsProjectMembersConvert.INSTANCE.toVo(save);
    }

    public PmsProjectMembersVO insertFromTask(Long projId, Long resId) {
        PmsProjectMembersVO pmsProjectMembersVO = this.pmsProjectMembersDAO.queryByProjAndRes(projId, resId);
        if (ObjectUtils.isEmpty((Object)pmsProjectMembersVO)) {
            PmsProjectMembersPayload membersPayload = new PmsProjectMembersPayload();
            membersPayload.setProjId(projId);
            membersPayload.setResId(resId);
            membersPayload.setWorkbenchFlag(Integer.valueOf(1));
            return PmsProjectMembersConvert.INSTANCE.toVo(this.pmsProjectMembersDAO.save(PmsProjectMembersConvert.INSTANCE.toDo(membersPayload)));
        }
        return null;
    }

    @Transactional(rollbackFor={Exception.class})
    public long updateByKeyDynamic(PmsProjectMembersPayload payload) {
        PmsProjectMembersDO entity = this.pmsProjectMembersRepo.findById(payload.getId()).orElseGet(PmsProjectMembersDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        long result = this.pmsProjectMembersDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        List<PmsProjectMembersVO> pmsProjectMembersVOS;
        if (!keys.isEmpty() && (pmsProjectMembersVOS = this.pmsProjectMembersDAO.queryByKeys(keys)).size() > 0) {
            List collect = pmsProjectMembersVOS.stream().map(PmsProjectMembersVO::getProjId).distinct().collect(Collectors.toList());
            if (collect.size() > 1) {
                throw TwException.error("", "\u4e0d\u53ef\u540c\u65f6\u5220\u9664\u591a\u9879\u76ee\u4e0b\u7684\u6210\u5458");
            }
            List resIds = pmsProjectMembersVOS.stream().map(PmsProjectMembersVO::getResId).distinct().collect(Collectors.toList());
            List timesheetVOS = this.taskCommonService.queryTimeSheets(PmsReasonTypeEnum.PROJ_CONTRACT.getCode(), (Long)collect.get(0), resIds);
            if (!ObjectUtils.isEmpty((Object)timesheetVOS)) {
                throw TwException.error("", "\u5df2\u63d0\u4ea4\u5de5\u65f6\uff0c\u4e0d\u53ef\u5220\u9664\u6210\u5458");
            }
            this.pmsProjectMembersDAO.deleteSoft(keys);
        }
    }

    private void checkData(PmsProjectMembersPayload payload) {
        if (ObjectUtils.isEmpty((Object)payload.getProjId())) {
            throw TwException.error("", "\u9879\u76eeId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)payload.getRole())) {
            throw TwException.error("", "\u89d2\u8272\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        if (!ObjectUtils.isEmpty((Object)payload.getPlanStartDate()) && !ObjectUtils.isEmpty((Object)payload.getPlanEndDate()) && payload.getPlanStartDate().isAfter(payload.getPlanEndDate())) {
            throw TwException.error("", "\u9884\u8ba1\u7ed3\u675f\u65e5\u671f\u4e0d\u5e94\u8be5\u65e9\u4e8e\u9884\u8ba1\u5f00\u59cb\u65e5\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
    }

    private void setCapaInfo(List<PmsProjectMembersVO> membersVOS) {
        List capasetLevelIds;
        if (!ObjectUtils.isEmpty(membersVOS) && !ObjectUtils.isEmpty(capasetLevelIds = membersVOS.stream().filter(v -> !ObjectUtils.isEmpty((Object)v.getCapasetLevelId())).map(v -> v.getCapasetLevelId()).collect(Collectors.toList()))) {
            PrdCompositeAbilityQuery prdCompositeAbilityQuery = new PrdCompositeAbilityQuery();
            prdCompositeAbilityQuery.setIds(capasetLevelIds);
            List levelVOS = this.prdCompositeAbilityService.getList(prdCompositeAbilityQuery);
            Map info = levelVOS.stream().collect(Collectors.toMap(BaseViewModel::getId, Function.identity()));
            membersVOS.forEach(v -> {
                PrdCompositeAbilityVO levelVO;
                Long capasetLevelId = v.getCapasetLevelId();
                if (!ObjectUtils.isEmpty((Object)capasetLevelId) && !ObjectUtils.isEmpty((Object)(levelVO = (PrdCompositeAbilityVO)info.get(capasetLevelId)))) {
                    v.setEqvaRatio(levelVO.getDlRatio());
                    v.setCapasetLevelDesc(levelVO.getName());
                }
            });
        }
    }

    public PmsProjectMembersServiceImpl(PmsProjectMembersRepo pmsProjectMembersRepo, PmsProjectMembersDAO pmsProjectMembersDAO, PrdCompositeAbilityService prdCompositeAbilityService, TaskCommonService taskCommonService, CacheUtil cacheUtil) {
        this.pmsProjectMembersRepo = pmsProjectMembersRepo;
        this.pmsProjectMembersDAO = pmsProjectMembersDAO;
        this.prdCompositeAbilityService = prdCompositeAbilityService;
        this.taskCommonService = taskCommonService;
        this.cacheUtil = cacheUtil;
    }
}

