/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.pms.service;

import cn.zhxu.bs.BeanSearcher;
import cn.zhxu.bs.FieldOp;
import cn.zhxu.bs.FieldOps;
import cn.zhxu.bs.util.FieldFns;
import cn.zhxu.bs.util.MapBuilder;
import cn.zhxu.bs.util.MapUtils;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsProjectSummaryPayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectSummaryQuery;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectSummaryService;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectSummaryVO;
import com.elitesland.tw.tw5.server.common.permission.PermissionBeanSearcherFactory;
import com.elitesland.tw.tw5.server.common.permission.enums.PermissionDomainEnum;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.pms.convert.PmsProjectSummaryConvert;
import com.elitesland.tw.tw5.server.prd.pms.dao.PmsProjectSummaryDAO;
import com.elitesland.tw.tw5.server.prd.pms.entity.PmsProjectSummaryDO;
import com.elitesland.tw.tw5.server.prd.pms.repo.PmsProjectSummaryRepo;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class PmsProjectSummaryServiceImpl
extends BaseServiceImpl
implements PmsProjectSummaryService {
    private static final Logger log = LoggerFactory.getLogger(PmsProjectSummaryServiceImpl.class);
    private final PmsProjectSummaryRepo pmsProjectSummaryRepo;
    private final PmsProjectSummaryDAO pmsProjectSummaryDAO;
    private BeanSearcher beanSearcher;

    @Autowired
    public void setBeanSearcher(PermissionBeanSearcherFactory permissionBeanSearcherFactory) {
        this.beanSearcher = permissionBeanSearcherFactory.getBeanSearcherService(PermissionDomainEnum.PMS_PROJECT_SUMMARY);
    }

    public PagingVO<PmsProjectSummaryVO> queryPaging(PmsProjectSummaryQuery query) {
        return this.pmsProjectSummaryDAO.queryPaging(query);
    }

    public List<PmsProjectSummaryVO> queryListDynamic(PmsProjectSummaryQuery query) {
        return this.pmsProjectSummaryDAO.queryListDynamic(query);
    }

    public PmsProjectSummaryVO queryByKey(Long key) {
        return this.pmsProjectSummaryDAO.queryByKey(key);
    }

    @Transactional(rollbackFor={Exception.class})
    public PmsProjectSummaryVO insert(PmsProjectSummaryPayload payload) {
        LocalDate summaryDate = LocalDate.now();
        String summaryName = payload.getProjName() + "-" + summaryDate.format(DateTimeFormatter.ofPattern("yyyy/MM/dd"));
        PmsProjectSummaryQuery pmsProjectSummaryQuery = new PmsProjectSummaryQuery();
        pmsProjectSummaryQuery.setSummaryName(summaryName);
        List<PmsProjectSummaryVO> pmsProjectSummaryVOS = this.pmsProjectSummaryDAO.queryListDynamic(pmsProjectSummaryQuery);
        if (!CollectionUtils.isEmpty(pmsProjectSummaryVOS)) {
            List collect = pmsProjectSummaryVOS.stream().sorted(Comparator.comparing(PmsProjectSummaryVO::getCreateTime).reversed()).collect(Collectors.toList());
            String lastSummaryName = ((PmsProjectSummaryVO)collect.get(0)).getSummaryName();
            int i = Integer.parseInt(lastSummaryName.split("-")[lastSummaryName.split("-").length - 1]);
            summaryName = summaryName + "-" + String.valueOf(i + 1);
        } else {
            summaryName = summaryName + "-1";
        }
        payload.setSummaryDate(summaryDate);
        payload.setSummaryName(summaryName);
        String code = this.generateSeqNum("PROJ_SUMMARY", new String[0]);
        payload.setSummaryNo(code);
        PmsProjectSummaryDO entityDo = PmsProjectSummaryConvert.INSTANCE.toDo(payload);
        return PmsProjectSummaryConvert.INSTANCE.toVo((PmsProjectSummaryDO)this.pmsProjectSummaryRepo.save(entityDo));
    }

    @Transactional(rollbackFor={Exception.class})
    public PmsProjectSummaryVO update(PmsProjectSummaryPayload payload) {
        PmsProjectSummaryDO entity = this.pmsProjectSummaryRepo.findById(payload.getId()).orElseGet(PmsProjectSummaryDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        PmsProjectSummaryDO entityDo = PmsProjectSummaryConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return PmsProjectSummaryConvert.INSTANCE.toVo((PmsProjectSummaryDO)this.pmsProjectSummaryRepo.save(entity));
    }

    @Transactional(rollbackFor={Exception.class})
    public long updateByKeyDynamic(PmsProjectSummaryPayload payload) {
        PmsProjectSummaryDO entity = this.pmsProjectSummaryRepo.findById(payload.getId()).orElseGet(PmsProjectSummaryDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        long result = this.pmsProjectSummaryDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            this.pmsProjectSummaryDAO.deleteSoft(keys);
        }
    }

    public PagingVO<PmsProjectSummaryVO> pagingPermission(PmsProjectSummaryQuery query) {
        MapBuilder mapBuilder = this.whereBuilder(query);
        Number totalNum = this.beanSearcher.searchCount(PmsProjectSummaryVO.class, mapBuilder.build());
        long total = (Long)totalNum;
        if (total == 0L) {
            return PagingVO.empty();
        }
        List pmsProjectSummaryVOS = this.beanSearcher.searchList(PmsProjectSummaryVO.class, mapBuilder.build());
        return PagingVO.builder().records(pmsProjectSummaryVOS).total(total).build();
    }

    public List<PmsProjectSummaryVO> listPermissionDynamic(PmsProjectSummaryQuery query) {
        query.setSize(Integer.valueOf(999));
        MapBuilder mapBuilder = this.whereBuilder(query);
        return this.beanSearcher.searchList(PmsProjectSummaryVO.class, mapBuilder.build());
    }

    private MapBuilder whereBuilder(PmsProjectSummaryQuery query) {
        MapBuilder builder = MapUtils.builder();
        if (!ObjectUtils.isEmpty((Object)query.getSummaryNo())) {
            ((MapBuilder)builder.field(PmsProjectSummaryVO::getSummaryNo, new Object[]{query.getSummaryNo()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getSummaryName())) {
            String likeStr = "%" + query.getSummaryName() + "%";
            ((MapBuilder)builder.field(PmsProjectSummaryVO::getSummaryName, new FieldFns.FieldFn[0])).sql("$1 like ?", new Object[]{likeStr});
        }
        if (!ObjectUtils.isEmpty((Object)query.getProjSearch())) {
            String projSerchLikeStr = "%" + query.getProjSearch() + "%";
            ((MapBuilder)builder.field(PmsProjectSummaryVO::getProjName, new FieldFns.FieldFn[]{PmsProjectSummaryVO::getProjNo})).sql("$1 like ? or $2 like ?", new Object[]{projSerchLikeStr, projSerchLikeStr});
        }
        if (!ObjectUtils.isEmpty((Object)query.getProjId())) {
            ((MapBuilder)builder.field(PmsProjectSummaryVO::getProjId, new Object[]{query.getProjId()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getPmResId())) {
            ((MapBuilder)builder.field(PmsProjectSummaryVO::getPmResId, new Object[]{query.getPmResId()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getDeliBuId())) {
            ((MapBuilder)builder.field(PmsProjectSummaryVO::getDeliBuId, new Object[]{query.getDeliBuId()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getDeliUserId())) {
            ((MapBuilder)builder.field(PmsProjectSummaryVO::getDeliUserId, new Object[]{query.getDeliUserId()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getCreateUserId())) {
            ((MapBuilder)builder.field(PmsProjectSummaryVO::getCreateUserId, new Object[]{query.getCreateUserId()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getSummaryDate())) {
            ((MapBuilder)builder.field(PmsProjectSummaryVO::getSummaryDate, new Object[]{query.getSummaryDate().get(0), query.getSummaryDate().get(1)})).op((FieldOp)FieldOps.Between);
        }
        if (!ObjectUtils.isEmpty((Object)query.getWorkType())) {
            ((MapBuilder)builder.field(PmsProjectSummaryVO::getWorkType, new Object[]{query.getWorkType()})).op((FieldOp)FieldOps.Equal);
        }
        ArrayList<OrderItem> orderse = new ArrayList<OrderItem>();
        orderse.add(OrderItem.desc((String)"createTime"));
        query.setOrders(orderse);
        SqlUtil.handleBS(builder, (TwQueryParam)query);
        return builder;
    }

    public PmsProjectSummaryServiceImpl(PmsProjectSummaryRepo pmsProjectSummaryRepo, PmsProjectSummaryDAO pmsProjectSummaryDAO) {
        this.pmsProjectSummaryRepo = pmsProjectSummaryRepo;
        this.pmsProjectSummaryDAO = pmsProjectSummaryDAO;
    }
}

