/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.purchase.service;

import cn.hutool.extra.spring.SpringUtil;
import cn.hutool.json.JSONUtil;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.bank.feign.payload.PayListPayload;
import com.elitesland.tw.tw5.api.bank.feign.payload.PayPayload;
import com.elitesland.tw.tw5.api.bank.feign.service.TwBankPayService;
import com.elitesland.tw.tw5.api.bank.vo.BkPayDetailVO;
import com.elitesland.tw.tw5.api.prd.humanresources.service.ResWithdrawApplyService;
import com.elitesland.tw.tw5.api.prd.partner.common.service.BookAccountService;
import com.elitesland.tw.tw5.api.prd.partner.common.service.BusinessPartnerService;
import com.elitesland.tw.tw5.api.prd.partner.common.vo.BookAccountVO;
import com.elitesland.tw.tw5.api.prd.pay.payload.BkPayDetailRecordPayload;
import com.elitesland.tw.tw5.api.prd.pay.payload.TDocHistPayload;
import com.elitesland.tw.tw5.api.prd.pay.service.BkPayDetailRecordService;
import com.elitesland.tw.tw5.api.prd.pay.service.TDocHistService;
import com.elitesland.tw.tw5.api.prd.purchase.payload.PaymentSlipPayload;
import com.elitesland.tw.tw5.api.prd.purchase.payload.PurchaseContractManagerPayload;
import com.elitesland.tw.tw5.api.prd.purchase.payload.PurchasePaymentPayload;
import com.elitesland.tw.tw5.api.prd.purchase.query.PaymentSlipQuery;
import com.elitesland.tw.tw5.api.prd.purchase.service.PaymentSlipService;
import com.elitesland.tw.tw5.api.prd.purchase.service.PurchaseAgreementService;
import com.elitesland.tw.tw5.api.prd.purchase.service.PurchaseContractManagerService;
import com.elitesland.tw.tw5.api.prd.purchase.service.PurchasePaymentService;
import com.elitesland.tw.tw5.api.prd.purchase.vo.DibPaymentSlipEmailVO;
import com.elitesland.tw.tw5.api.prd.purchase.vo.PaymentSlipVO;
import com.elitesland.tw.tw5.api.prd.purchase.vo.PurchaseContractManagerVO;
import com.elitesland.tw.tw5.api.prd.purchase.vo.PurchasePaymentVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdMessageConfigService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdMessageConfigVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.purchase.convert.PaymentSlipConvert;
import com.elitesland.tw.tw5.server.prd.purchase.dao.PaymentSlipDAO;
import com.elitesland.tw.tw5.server.prd.purchase.entity.PaymentSlipDO;
import com.elitesland.tw.tw5.server.prd.purchase.purenum.PurchaseContractStatusEnum;
import com.elitesland.tw.tw5.server.prd.purchase.purenum.PurchasePaymentEnum;
import com.elitesland.tw.tw5.server.prd.purchase.repo.PaymentSlipRepo;
import com.querydsl.core.Tuple;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class PaymentSlipServiceImpl
extends BaseServiceImpl
implements PaymentSlipService {
    private static final Logger log = LoggerFactory.getLogger(PaymentSlipServiceImpl.class);
    private final PaymentSlipRepo paymentSlipRepo;
    private final PaymentSlipDAO paymentSlipDAO;
    private final BusinessPartnerService businessPartnerService;
    @Autowired
    @Lazy
    private PurchaseContractManagerService purchaseContractManagerService;
    private final PurchaseAgreementService purchaseAgreementService;
    @Resource
    private TwBankPayService payService;
    private final BookAccountService bookAccountService;
    private final BkPayDetailRecordService bkPayDetailRecordService;
    private final TDocHistService tDocHistService;
    private final CacheUtil cacheUtil;
    @Autowired
    @Lazy
    private PurchasePaymentService purchasePaymentService;
    @Value(value="${tw5.payment.platform:TW5}")
    private String platform;
    @Value(value="${tw5.payment.bank:CMB}")
    private String bank;
    @Value(value="${tw5.payment.secretKey:123456}")
    private String secretKey;
    private final ResWithdrawApplyService resWithdrawApplyService;
    private final PrdMessageConfigService messageConfigService;

    public PagingVO<PaymentSlipVO> queryPaging(PaymentSlipQuery query) {
        PagingVO<PaymentSlipVO> paymentSlipVOPagingVO = this.paymentSlipDAO.queryPaging(query);
        if (!CollectionUtils.isEmpty((Collection)paymentSlipVOPagingVO.getRecords())) {
            ArrayList bookIdList = new ArrayList();
            ArrayList accountIdList = new ArrayList();
            HashMap<Long, String> resultMap = new HashMap();
            HashMap<Long, List<BookAccountVO>> accountMap = new HashMap();
            paymentSlipVOPagingVO.stream().forEach(p -> {
                if (p.getPayCompanyBookId() != null) {
                    bookIdList.add(p.getPayCompanyBookId());
                }
                if (p.getReceivingCompanyBookId() != null) {
                    bookIdList.add(p.getReceivingCompanyBookId());
                }
                if (StringUtils.hasText((String)p.getReceivingAccount())) {
                    accountIdList.add(Long.valueOf(p.getReceivingAccount()));
                }
                if (StringUtils.hasText((String)p.getPaymentAccount())) {
                    accountIdList.add(Long.valueOf(p.getPaymentAccount()));
                }
            });
            if (!CollectionUtils.isEmpty(bookIdList)) {
                resultMap = this.businessPartnerService.findNameByBookIds(bookIdList);
            }
            if (!CollectionUtils.isEmpty(accountIdList)) {
                accountMap = this.bookAccountService.queryByIdList(accountIdList);
            }
            for (PaymentSlipVO paymentSlipVO : paymentSlipVOPagingVO.getRecords()) {
                this.translate(paymentSlipVO, resultMap, accountMap);
            }
        }
        return paymentSlipVOPagingVO;
    }

    public PagingVO<PaymentSlipVO> queryAccountPaging(PaymentSlipQuery query) {
        PagingVO<PaymentSlipVO> paymentSlipVOPagingVO = this.paymentSlipDAO.queryAccountPaging(query);
        if (!CollectionUtils.isEmpty((Collection)paymentSlipVOPagingVO.getRecords())) {
            ArrayList bookIdList = new ArrayList();
            ArrayList accountIdList = new ArrayList();
            HashMap<Long, String> resultMap = new HashMap();
            HashMap<Long, List<BookAccountVO>> accountMap = new HashMap();
            paymentSlipVOPagingVO.stream().forEach(p -> {
                if (p.getPayCompanyBookId() != null) {
                    bookIdList.add(p.getPayCompanyBookId());
                }
                if (p.getReceivingCompanyBookId() != null) {
                    bookIdList.add(p.getReceivingCompanyBookId());
                }
                if (StringUtils.hasText((String)p.getReceivingAccount())) {
                    accountIdList.add(Long.valueOf(p.getReceivingAccount()));
                }
                if (StringUtils.hasText((String)p.getPaymentAccount())) {
                    accountIdList.add(Long.valueOf(p.getPaymentAccount()));
                }
            });
            if (!CollectionUtils.isEmpty(bookIdList)) {
                resultMap = this.businessPartnerService.findNameByBookIds(bookIdList);
            }
            if (!CollectionUtils.isEmpty(accountIdList)) {
                accountMap = this.bookAccountService.queryByIdList(accountIdList);
            }
            for (PaymentSlipVO paymentSlipVO : paymentSlipVOPagingVO.getRecords()) {
                this.translate(paymentSlipVO, resultMap, accountMap);
            }
        }
        return paymentSlipVOPagingVO;
    }

    public PagingVO<PaymentSlipVO> paymentApproveGroupPaging(PaymentSlipQuery query) {
        PagingVO<PaymentSlipVO> paymentSlipVOPagingVO = this.paymentSlipDAO.paymentApproveGroupPaging(query);
        if (!CollectionUtils.isEmpty((Collection)paymentSlipVOPagingVO.getRecords())) {
            ArrayList bookIdList = new ArrayList();
            ArrayList accountIdList = new ArrayList();
            HashMap<Long, String> resultMap = new HashMap();
            HashMap<Long, List<BookAccountVO>> accountMap = new HashMap();
            paymentSlipVOPagingVO.stream().forEach(p -> {
                if (p.getPayCompanyBookId() != null) {
                    bookIdList.add(p.getPayCompanyBookId());
                }
                if (p.getReceivingCompanyBookId() != null) {
                    bookIdList.add(p.getReceivingCompanyBookId());
                }
                if (StringUtils.hasText((String)p.getReceivingAccount())) {
                    accountIdList.add(Long.valueOf(p.getReceivingAccount()));
                }
                if (StringUtils.hasText((String)p.getPaymentAccount())) {
                    accountIdList.add(Long.valueOf(p.getPaymentAccount()));
                }
            });
            if (!CollectionUtils.isEmpty(bookIdList)) {
                resultMap = this.businessPartnerService.findNameByBookIds(bookIdList);
            }
            if (!CollectionUtils.isEmpty(accountIdList)) {
                accountMap = this.bookAccountService.queryByIdList(accountIdList);
            }
            for (PaymentSlipVO paymentSlipVO : paymentSlipVOPagingVO.getRecords()) {
                this.translate(paymentSlipVO, resultMap, accountMap);
            }
        }
        return paymentSlipVOPagingVO;
    }

    public List<PaymentSlipVO> queryListDynamic(PaymentSlipQuery query) {
        List<PaymentSlipVO> paymentSlipVOS = this.paymentSlipDAO.queryListDynamic(query);
        if (!CollectionUtils.isEmpty(paymentSlipVOS)) {
            ArrayList bookIdList = new ArrayList();
            ArrayList accountIdList = new ArrayList();
            HashMap<Long, String> resultMap = new HashMap();
            HashMap<Long, List<BookAccountVO>> accountMap = new HashMap();
            paymentSlipVOS.forEach(p -> {
                if (p.getPayCompanyBookId() != null) {
                    bookIdList.add(p.getPayCompanyBookId());
                }
                if (p.getReceivingCompanyBookId() != null) {
                    bookIdList.add(p.getReceivingCompanyBookId());
                }
                if (StringUtils.hasText((String)p.getReceivingAccount())) {
                    accountIdList.add(Long.valueOf(p.getReceivingAccount()));
                }
                if (StringUtils.hasText((String)p.getPaymentAccount())) {
                    accountIdList.add(Long.valueOf(p.getPaymentAccount()));
                }
            });
            if (!CollectionUtils.isEmpty(bookIdList)) {
                resultMap = this.businessPartnerService.findNameByBookIds(bookIdList);
            }
            if (!CollectionUtils.isEmpty(accountIdList)) {
                accountMap = this.bookAccountService.queryByIdList(accountIdList);
            }
            for (PaymentSlipVO paymentSlipVO : paymentSlipVOS) {
                this.translate(paymentSlipVO, resultMap, accountMap);
            }
        }
        return paymentSlipVOS;
    }

    public List<PaymentSlipVO> queryListByIds(List<Long> idList) {
        List<PaymentSlipVO> paymentSlipVOS = this.paymentSlipDAO.queryListByIds(idList);
        if (!CollectionUtils.isEmpty(paymentSlipVOS)) {
            ArrayList bookIdList = new ArrayList();
            ArrayList accountIdList = new ArrayList();
            HashMap<Long, String> resultMap = new HashMap();
            HashMap<Long, List<BookAccountVO>> accountMap = new HashMap();
            paymentSlipVOS.forEach(p -> {
                if (p.getPayCompanyBookId() != null) {
                    bookIdList.add(p.getPayCompanyBookId());
                }
                if (p.getReceivingCompanyBookId() != null) {
                    bookIdList.add(p.getReceivingCompanyBookId());
                }
                if (StringUtils.hasText((String)p.getReceivingAccount())) {
                    accountIdList.add(Long.valueOf(p.getReceivingAccount()));
                }
                if (StringUtils.hasText((String)p.getPaymentAccount())) {
                    accountIdList.add(Long.valueOf(p.getPaymentAccount()));
                }
            });
            if (!CollectionUtils.isEmpty(bookIdList)) {
                resultMap = this.businessPartnerService.findNameByBookIds(bookIdList);
            }
            if (!CollectionUtils.isEmpty(accountIdList)) {
                accountMap = this.bookAccountService.queryByIdList(accountIdList);
            }
            for (PaymentSlipVO paymentSlipVO : paymentSlipVOS) {
                this.translate(paymentSlipVO, resultMap, accountMap);
            }
        }
        return paymentSlipVOS;
    }

    public PaymentSlipVO queryByKey(Long key) {
        PaymentSlipVO paymentSlipVO = this.paymentSlipDAO.queryByKey(key);
        if (paymentSlipVO == null) {
            throw TwException.error("", "\u4ed8\u6b3e\u8bb0\u5f55\u5bf9\u8c61\u4e0d\u5b58\u5728");
        }
        return paymentSlipVO;
    }

    @Transactional(rollbackFor={Exception.class})
    public PaymentSlipVO insert(PaymentSlipPayload payload) {
        PaymentSlipDO entityDo = PaymentSlipConvert.INSTANCE.toDo(payload);
        return PaymentSlipConvert.INSTANCE.toVo((PaymentSlipDO)this.paymentSlipRepo.save(entityDo));
    }

    @Transactional(rollbackFor={Exception.class})
    public PaymentSlipVO update(PaymentSlipPayload payload) {
        PaymentSlipDO entity = this.paymentSlipRepo.findById(payload.getId()).orElseGet(PaymentSlipDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        PaymentSlipDO entityDo = PaymentSlipConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return PaymentSlipConvert.INSTANCE.toVo((PaymentSlipDO)this.paymentSlipRepo.save(entity));
    }

    @Transactional(rollbackFor={Exception.class})
    public long updateByKeyDynamic(PaymentSlipPayload payload) {
        PaymentSlipDO entity = this.paymentSlipRepo.findById(payload.getId()).orElseGet(PaymentSlipDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        long result = this.paymentSlipDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public long updateBankCallBack(PaymentSlipPayload payload) {
        long result = this.paymentSlipDAO.updateBankCallBack(payload);
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            this.paymentSlipDAO.deleteSoft(keys);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void insertAll(List<PaymentSlipPayload> paymentSlipPayloads) {
        this.paymentSlipRepo.saveAll(PaymentSlipConvert.INSTANCE.toDoList(paymentSlipPayloads));
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteByPaymentApplyId(Long paymentApplyId) {
        this.paymentSlipDAO.deleteByPaymentApplyId(paymentApplyId);
    }

    public List<PaymentSlipVO> queryListByPaymentApplyId(Long paymentApplyId) {
        List<PaymentSlipVO> paymentSlipVOS = this.paymentSlipDAO.queryListByPaymentApplyId(paymentApplyId);
        if (!CollectionUtils.isEmpty(paymentSlipVOS)) {
            ArrayList bookIdList = new ArrayList();
            ArrayList accountIdList = new ArrayList();
            HashMap<Long, String> resultMap = new HashMap();
            HashMap<Long, List<BookAccountVO>> accountMap = new HashMap();
            paymentSlipVOS.forEach(p -> {
                if (p.getPayCompanyBookId() != null) {
                    bookIdList.add(p.getPayCompanyBookId());
                }
                if (p.getReceivingCompanyBookId() != null) {
                    bookIdList.add(p.getReceivingCompanyBookId());
                }
                if (StringUtils.hasText((String)p.getReceivingAccount())) {
                    accountIdList.add(Long.valueOf(p.getReceivingAccount()));
                }
                if (StringUtils.hasText((String)p.getPaymentAccount())) {
                    accountIdList.add(Long.valueOf(p.getPaymentAccount()));
                }
            });
            if (!CollectionUtils.isEmpty(bookIdList)) {
                resultMap = this.businessPartnerService.findNameByBookIds(bookIdList);
            }
            if (!CollectionUtils.isEmpty(accountIdList)) {
                accountMap = this.bookAccountService.queryByIdList(accountIdList);
            }
            for (PaymentSlipVO paymentSlipVO : paymentSlipVOS) {
                this.translate(paymentSlipVO, resultMap, accountMap);
            }
        }
        return paymentSlipVOS;
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateStatusByPaymentApplyId(Long paymentApplyId, String state) {
        this.paymentSlipDAO.updateStatusByPaymentApplyId(paymentApplyId, state);
    }

    @Transactional(rollbackFor={Exception.class})
    public void confirmOfflinePayment(List<PaymentSlipPayload> paymentSlipPayloadList) {
        Long userId = GlobalUtil.getLoginUserId();
        List<Long> idList = paymentSlipPayloadList.stream().map(p -> p.getId()).collect(Collectors.toList());
        this.dealPaymentData(idList);
        if (!CollectionUtils.isEmpty(paymentSlipPayloadList)) {
            paymentSlipPayloadList.stream().forEach(p -> {
                p.setState(PurchasePaymentEnum.PaymentSlipStatus.PAID.getCode());
                p.setPayMode(PurchasePaymentEnum.PayModeEnum.PAYMANUAL.getCode());
                p.setPayStatus(PurchasePaymentEnum.PayStatusEnum.SUCCESS.getCode());
                p.setPayTime(LocalDateTime.now());
                this.update((PaymentSlipPayload)p);
                TDocHistPayload tDocHistPayload = new TDocHistPayload();
                tDocHistPayload.setDocId(p.getId());
                tDocHistPayload.setDocNo(p.getPaymentApplyNo());
                tDocHistPayload.setHistTime(LocalDateTime.now());
                tDocHistPayload.setOwnerId(userId);
                tDocHistPayload.setCreateUserId(userId);
                tDocHistPayload.setDocType(PurchasePaymentEnum.PayDocType.CONTANT.getCode());
                tDocHistPayload.setHistType(PurchasePaymentEnum.PayHistType.HISTTYPE1.getDesc());
                tDocHistPayload.setHistDtl(PurchasePaymentEnum.PayHistDtl.DTL1.getDesc());
                this.tDocHistService.insert(tDocHistPayload);
            });
            this.sendEmail(idList);
        }
    }

    private void sendEmail(List<Long> idList) {
        List<DibPaymentSlipEmailVO> paymentSlipEmailByIds = this.paymentSlipDAO.findPaymentSlipEmailByIds(idList);
        PrdMessageConfigVO configVO = this.messageConfigService.queryByMessageCode("MC20240719000001");
        paymentSlipEmailByIds.forEach(dibPaymentSlipEmailVO -> {
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("supplierLegalBookName", dibPaymentSlipEmailVO.getSupplierLegalBookName());
            result.put("purchaseName", dibPaymentSlipEmailVO.getPurchaseName());
            result.put("paymentNo", dibPaymentSlipEmailVO.getPaymentNo());
            result.put("paymentAmt", dibPaymentSlipEmailVO.getPaymentAmt());
            if (dibPaymentSlipEmailVO.getPayTime() != null) {
                result.put("payTime", dibPaymentSlipEmailVO.getPayTime().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
            }
            if (dibPaymentSlipEmailVO.getPurchaseInchargeResId() != null) {
                String noticeSource = dibPaymentSlipEmailVO.getPurchaseInchargeResId().toString();
                log.debug(dibPaymentSlipEmailVO.getPurchaseName() + "\u4ed8\u6b3e\u652f\u4ed8\u6210\u529f\u53d1\u9001\u90ae\u4ef6\uff1a\uff1a\uff1a\uff1a\uff1a" + noticeSource);
                this.messageConfigService.sendMessageConfig(configVO, result, "appoint_people", noticeSource);
                log.debug(dibPaymentSlipEmailVO.getPurchaseName() + "\u4ed8\u6b3e\u652f\u4ed8\u6210\u529f\u53d1\u9001\u90ae\u4ef6\u5b8c\u6210\uff1a\uff1a\uff1a\uff1a\uff1a" + noticeSource);
            } else {
                log.error(dibPaymentSlipEmailVO.getPurchaseName() + "\u7f3a\u5c11\u7533\u8bf7\u4eba\uff0c\u65e0\u6cd5\u53d1\u9001\u90ae\u4ef6");
            }
        });
    }

    @Transactional
    public void dealPaymentData(List<Long> idList) {
        List<PaymentSlipVO> paymentSlipVOS = this.paymentSlipDAO.queryPaymentSlipVOListByIdlist(idList);
        Map<Long, List<PaymentSlipVO>> paymentApplyIdMap = paymentSlipVOS.stream().collect(Collectors.groupingBy(PaymentSlipVO::getPaymentApplyId));
        paymentApplyIdMap.forEach((k, v) -> {
            BigDecimal paymentAmt = v.stream().map(p -> p.getPaymentAmt()).reduce(BigDecimal.ZERO, BigDecimal::add);
            this.closePaymentContractAndUpdatePaymentApply((Long)k, paymentAmt);
        });
    }

    @Transactional(rollbackFor={Exception.class})
    public void commitOnlinePayment(List<PaymentSlipPayload> paymentSlipPayloadList) {
        Long userId = GlobalUtil.getLoginUserId();
        if (CollectionUtils.isEmpty(paymentSlipPayloadList)) {
            throw TwException.error("", "\u52fe\u9009\u7684\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<Long> idList = paymentSlipPayloadList.stream().map(p -> p.getId()).collect(Collectors.toList());
        List<PaymentSlipVO> paymentSlipVOS = this.queryListByIds(idList);
        if (CollectionUtils.isEmpty(paymentSlipVOS)) {
            throw TwException.error("", "\u52fe\u9009\u7684\u6570\u636e\u4e0d\u5b58\u5728,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        ArrayList accountList = new ArrayList();
        List receiveAccList = paymentSlipVOS.stream().filter(p -> StringUtils.hasText((String)p.getReceivingAccount())).map(s -> Long.valueOf(s.getReceivingAccount())).collect(Collectors.toList());
        List paymentAccList = paymentSlipVOS.stream().filter(p -> StringUtils.hasText((String)p.getPaymentAccount())).map(s -> Long.valueOf(s.getPaymentAccount())).collect(Collectors.toList());
        accountList.addAll(paymentAccList);
        accountList.addAll(receiveAccList);
        Map bookAccountVOMap = this.bookAccountService.queryByIdList(accountList);
        if (CollectionUtils.isEmpty((Map)bookAccountVOMap)) {
            throw TwException.error("", "\u6536\u6b3e\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String bthnbr = this.generateSeqNum("BTHNBR", new String[0]);
        if (paymentSlipVOS.size() == 1) {
            PaymentSlipVO paymentSlipVO = paymentSlipVOS.get(0);
            if (!StringUtils.hasText((String)paymentSlipVO.getPayPurpose())) {
                throw TwException.error("", "\u4ed8\u6b3e\u7533\u8bf7\u5355:" + paymentSlipVO.getPaymentApplyNo() + "\u7684\u7f51\u94f6\u7528\u9014\u672a\u586b\u5199,\u8bf7\u9000\u56de\u81f3\u5e94\u4ed8\u4f1a\u8ba1\u73af\u8282");
            }
            if (!StringUtils.hasText((String)paymentSlipVO.getCurrCode()) || !PurchasePaymentEnum.CurrCodeEnum.CNY.getCode().equals(paymentSlipVO.getCurrCode())) {
                throw TwException.error("", "\u4ed8\u6b3e\u7533\u8bf7\u5355:" + paymentSlipVO.getPaymentApplyNo() + "\u6682\u4e0d\u652f\u6301\u5916\u5e01\u652f\u4ed8\u573a\u666f");
            }
            PayPayload payload = new PayPayload();
            payload.setBank(this.bank);
            payload.setPlatform(this.platform);
            payload.setSecretKey(this.secretKey);
            payload.setBatchFlag(Integer.valueOf(1));
            payload.setTrxseq("1");
            payload.setBthnbr(bthnbr);
            payload.setTtlamt(paymentSlipVO.getPaymentAmt());
            payload.setTtlcnt(Integer.valueOf(paymentSlipVOS.size()));
            payload.setTtlnum(Integer.valueOf(1));
            payload.setCuramt(paymentSlipVO.getPaymentAmt());
            payload.setCurcnt(Integer.valueOf(1));
            this.savePayMentDetail(paymentSlipVO, bookAccountVOMap, payload);
            PaymentSlipPayload paymentSlipPayload = paymentSlipPayloadList.get(0);
            paymentSlipPayload.setBankFlag(Integer.valueOf(PurchasePaymentEnum.PayBankFlag.BANKFALG1.getCode()));
            paymentSlipPayload.setBankTime(LocalDateTime.now());
            paymentSlipPayload.setPayMode(PurchasePaymentEnum.PayModeEnum.PAYCURRENCY.getCode());
            paymentSlipPayload.setPayStatus(PurchasePaymentEnum.PayStatusEnum.PAYIN.getCode());
            paymentSlipPayload.setPayTime(LocalDateTime.now());
            this.update(paymentSlipPayload);
            TDocHistPayload tDocHistPayload = new TDocHistPayload();
            tDocHistPayload.setDocId(paymentSlipVO.getId());
            tDocHistPayload.setDocNo(paymentSlipVO.getPaymentApplyNo());
            tDocHistPayload.setHistTime(LocalDateTime.now());
            tDocHistPayload.setOwnerId(userId);
            tDocHistPayload.setCreateUserId(userId);
            tDocHistPayload.setDocType(PurchasePaymentEnum.PayDocType.CONTANT.getCode());
            tDocHistPayload.setHistType(PurchasePaymentEnum.PayHistType.HISTTYPE4.getDesc());
            tDocHistPayload.setHistDtl(PurchasePaymentEnum.PayHistDtl.DTL4.getDesc());
            if (PurchasePaymentEnum.PayStatusEnum.FAIL.getCode().equals(paymentSlipVO.getPayStatus())) {
                tDocHistPayload.setHistType(PurchasePaymentEnum.PayHistType.HISTTYPE3.getDesc());
                tDocHistPayload.setHistDtl(PurchasePaymentEnum.PayHistDtl.DTL3.getDesc());
            }
            this.tDocHistService.insert(tDocHistPayload);
            log.info("\u4ed8\u6b3e\u7533\u8bf7\u5355\u6279\u6b21\u53f7\u4e3a:" + bthnbr + "\u8c03\u7528\u94f6\u4f01\u76f4\u8054\u5f00\u59cb");
            log.info("\u4ed8\u6b3e\u7533\u8bf7\u5355\u6279\u6b21\u53f7\u4e3a:" + bthnbr + "\u8bf7\u6c42\u6570\u636e\u4e3a:" + JSONUtil.toJsonStr((Object)payload));
            ApiResult pay = this.payService.pay(payload);
            log.info("\u4ed8\u6b3e\u7533\u8bf7\u5355\u6279\u6b21\u53f7\u4e3a:" + bthnbr + "\u8fd4\u56de\u6570\u636e\u4e3a:" + JSONUtil.toJsonStr((Object)pay));
            log.info("\u4ed8\u6b3e\u7533\u8bf7\u5355\u6279\u6b21\u53f7\u4e3a:" + bthnbr + "\u8c03\u7528\u94f6\u4f01\u76f4\u8054\u7ed3\u675f");
            if (pay.getCode() != 200) {
                log.error(pay.getErrorMsg());
                log.error(pay.getMsg());
                throw TwException.error("", "\u4ed8\u6b3e\u7533\u8bf7\u5355\u6279\u6b21\u53f7\u4e3a:" + bthnbr + "\u8c03\u7528\u94f6\u4f01\u76f4\u8054\u5931\u8d25,\u5f02\u5e38\u4e3a:" + pay.getMsg());
            }
            try {
                BkPayDetailRecordPayload bkPayDetailRecordPayload = new BkPayDetailRecordPayload();
                bkPayDetailRecordPayload.setBatchFlag(payload.getBatchFlag());
                bkPayDetailRecordPayload.setBkPayDetailId(((BkPayDetailVO)pay.getData()).getId());
                bkPayDetailRecordPayload.setBthnbr(payload.getBthnbr());
                bkPayDetailRecordPayload.setYurref(payload.getYurref());
                bkPayDetailRecordPayload.setTrxseq(payload.getTrxseq());
                bkPayDetailRecordPayload.setPayStatus(Integer.valueOf(PurchasePaymentEnum.PayStatusDetailEnum.SEND.getCode()));
                bkPayDetailRecordPayload.setOrderType(payload.getOrderType());
                bkPayDetailRecordPayload.setTrsamt(payload.getTrsamt());
                this.bkPayDetailRecordService.insert(bkPayDetailRecordPayload);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                log.error("\u4ed8\u6b3e\u7533\u8bf7\u5355\u6279\u6b21\u53f7\u4e3a:" + bthnbr + "\u7684\u4ed8\u6b3e\u8bb0\u5f55\u5355\u751f\u6210\u4ed8\u6b3e\u53d1\u9001\u8bb0\u5f55\u5931\u8d25");
            }
        } else {
            PayListPayload payListPayload = new PayListPayload();
            ArrayList<PayPayload> payloadList = new ArrayList<PayPayload>();
            payListPayload.setBank(this.bank);
            payListPayload.setPlatform(this.platform);
            payListPayload.setSecretKey(this.secretKey);
            BigDecimal totalPayMentAmt = paymentSlipVOS.stream().map(p -> p.getPaymentAmt()).reduce(BigDecimal.ZERO, BigDecimal::add);
            for (int i = 0; i < paymentSlipVOS.size(); ++i) {
                PaymentSlipVO paymentSlipVO = paymentSlipVOS.get(i);
                if (!StringUtils.hasText((String)paymentSlipVO.getPayPurpose())) {
                    throw TwException.error("", "\u4ed8\u6b3e\u7533\u8bf7\u5355:" + paymentSlipVO.getPaymentApplyNo() + "\u7684\u7f51\u94f6\u7528\u9014\u672a\u586b\u5199,\u8bf7\u9000\u56de\u81f3\u5e94\u4ed8\u4f1a\u8ba1\u73af\u8282");
                }
                if (!StringUtils.hasText((String)paymentSlipVO.getCurrCode()) || !PurchasePaymentEnum.CurrCodeEnum.CNY.getCode().equals(paymentSlipVO.getCurrCode())) {
                    throw TwException.error("", "\u4ed8\u6b3e\u7533\u8bf7\u5355:" + paymentSlipVO.getPaymentApplyNo() + "\u6682\u4e0d\u652f\u6301\u5916\u5e01\u652f\u4ed8\u573a\u666f");
                }
                PayPayload payload = new PayPayload();
                payload.setBatchFlag(Integer.valueOf(2));
                payload.setBthnbr(bthnbr);
                payload.setTrxseq(String.valueOf(i + 1));
                payload.setCuramt(paymentSlipVO.getPaymentAmt());
                payload.setCurcnt(Integer.valueOf(i + 1));
                payload.setTtlamt(totalPayMentAmt);
                payload.setTtlcnt(Integer.valueOf(paymentSlipVOS.size() + 1));
                payload.setTtlnum(Integer.valueOf(paymentSlipVOS.size() + 1));
                this.savePayMentDetail(paymentSlipVO, bookAccountVOMap, payload);
                payloadList.add(payload);
                TDocHistPayload tDocHistPayload = new TDocHistPayload();
                tDocHistPayload.setDocId(paymentSlipVO.getId());
                tDocHistPayload.setDocNo(paymentSlipVO.getPaymentApplyNo());
                tDocHistPayload.setHistTime(LocalDateTime.now());
                tDocHistPayload.setOwnerId(userId);
                tDocHistPayload.setCreateUserId(userId);
                tDocHistPayload.setDocType(PurchasePaymentEnum.PayDocType.CONTANT.getCode());
                tDocHistPayload.setHistType(PurchasePaymentEnum.PayHistType.HISTTYPE4.getDesc());
                tDocHistPayload.setHistDtl(PurchasePaymentEnum.PayHistDtl.DTL4.getDesc());
                if (PurchasePaymentEnum.PayStatusEnum.FAIL.getCode().equals(paymentSlipVO.getPayStatus())) {
                    tDocHistPayload.setHistType(PurchasePaymentEnum.PayHistType.HISTTYPE3.getDesc());
                    tDocHistPayload.setHistDtl(PurchasePaymentEnum.PayHistDtl.DTL3.getDesc());
                }
                this.tDocHistService.insert(tDocHistPayload);
            }
            paymentSlipPayloadList.stream().forEach(p -> {
                p.setBankFlag(Integer.valueOf(PurchasePaymentEnum.PayBankFlag.BANKFALG1.getCode()));
                p.setBankTime(LocalDateTime.now());
                p.setPayMode(PurchasePaymentEnum.PayModeEnum.PAYCURRENCY.getCode());
                p.setPayStatus(PurchasePaymentEnum.PayStatusEnum.PAYIN.getCode());
                p.setPayTime(LocalDateTime.now());
                this.update((PaymentSlipPayload)p);
            });
            payListPayload.setPayPayloadList(payloadList);
            log.info("\u4ed8\u6b3e\u7533\u8bf7\u5355\u6279\u6b21\u53f7\u4e3a:" + bthnbr + "\u8c03\u7528\u94f6\u4f01\u76f4\u8054\u5f00\u59cb");
            log.info("\u4ed8\u6b3e\u7533\u8bf7\u5355\u6279\u6b21\u53f7\u4e3a:" + bthnbr + "\u8bf7\u6c42\u6570\u636e\u4e3a:" + JSONUtil.toJsonStr((Object)payListPayload));
            ApiResult listApiResult = this.payService.payList(payListPayload);
            log.info("\u4ed8\u6b3e\u7533\u8bf7\u5355\u6279\u6b21\u53f7\u4e3a:" + bthnbr + "\u8fd4\u56de\u6570\u636e\u4e3a:" + JSONUtil.toJsonStr((Object)listApiResult));
            log.info("\u4ed8\u6b3e\u7533\u8bf7\u5355\u6279\u6b21\u53f7\u4e3a:" + bthnbr + "\u8c03\u7528\u94f6\u4f01\u76f4\u8054\u7ed3\u675f");
            if (listApiResult.getCode() != 200) {
                log.error(listApiResult.getErrorMsg());
                log.error(listApiResult.getMsg());
                throw TwException.error("", "\u4ed8\u6b3e\u7533\u8bf7\u5355\u6279\u6b21\u53f7\u4e3a:" + bthnbr + "\u8c03\u7528\u94f6\u4f01\u76f4\u8054\u5931\u8d25,\u5f02\u5e38\u4e3a:" + listApiResult.getMsg());
            }
            List listApiResultData = (List)listApiResult.getData();
            listApiResultData.stream().forEach(p -> {
                try {
                    BkPayDetailRecordPayload bkPayDetailRecordPayload = new BkPayDetailRecordPayload();
                    bkPayDetailRecordPayload.setBatchFlag(p.getBatchFlag());
                    bkPayDetailRecordPayload.setBkPayDetailId(p.getId());
                    bkPayDetailRecordPayload.setBthnbr(p.getBthnbr());
                    bkPayDetailRecordPayload.setYurref(p.getYurref());
                    bkPayDetailRecordPayload.setTrxseq(p.getTrxseq());
                    bkPayDetailRecordPayload.setPayStatus(Integer.valueOf(PurchasePaymentEnum.PayStatusDetailEnum.SEND.getCode()));
                    bkPayDetailRecordPayload.setOrderType(p.getOrderType());
                    bkPayDetailRecordPayload.setTrsamt(p.getTrsamt());
                    this.bkPayDetailRecordService.insert(bkPayDetailRecordPayload);
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                    log.error("\u4ed8\u6b3e\u8bb0\u5f55\u5355:" + p.getDocId() + "\u63d2\u5165\u4ed8\u6b3e\u53d1\u9001\u8bb0\u5f55\u5931\u8d25");
                    return;
                }
            });
        }
    }

    public void savePayMentDetail(PaymentSlipVO paymentSlipVO, Map<Long, List<BookAccountVO>> bookAccountVOMap, PayPayload payload) {
        Long userId = GlobalUtil.getLoginUserId();
        payload.setDocId(paymentSlipVO.getId().toString());
        payload.setDocNo(paymentSlipVO.getPaymentApplyNo());
        payload.setDocType(PurchasePaymentEnum.BankDocType.PAY.getCode());
        String paymentApplyNo = paymentSlipVO.getPaymentApplyNo();
        payload.setYurref(paymentSlipVO.getId().toString() + "PR" + paymentApplyNo.substring(paymentApplyNo.length() - 4));
        if (!StringUtils.hasText((String)paymentSlipVO.getReceivingAccount()) || !bookAccountVOMap.containsKey(Long.valueOf(paymentSlipVO.getReceivingAccount()))) {
            throw TwException.error("", "\u4ed8\u6b3e\u7533\u8bf7\u5355\u4e3a:" + paymentSlipVO.getPaymentApplyNo() + "\u7684\u6536\u6b3e\u8d26\u53f7\u4e0d\u6b63\u786e");
        }
        if (!StringUtils.hasText((String)paymentSlipVO.getPaymentAccount()) || !bookAccountVOMap.containsKey(Long.valueOf(paymentSlipVO.getPaymentAccount()))) {
            throw TwException.error("", "\u4ed8\u6b3e\u7533\u8bf7\u5355\u4e3a:" + paymentSlipVO.getPaymentApplyNo() + "\u7684\u4ed8\u6b3e\u8d26\u53f7\u4e0d\u6b63\u786e");
        }
        Long receivingAccount = Long.valueOf(paymentSlipVO.getReceivingAccount());
        BookAccountVO receivingAccountVO = bookAccountVOMap.get(receivingAccount).get(0);
        Long paymentAccount = Long.valueOf(paymentSlipVO.getPaymentAccount());
        BookAccountVO paymentAccountVO = bookAccountVOMap.get(paymentAccount).get(0);
        payload.setAccnam(receivingAccountVO.getAccountName());
        payload.setAccnamBankName(paymentSlipVO.getReceivingBank());
        payload.setAccnbr(receivingAccountVO.getAccountNo());
        payload.setCrtbnk(receivingAccountVO.getDepositBankOutlet());
        payload.setCrtadr(receivingAccountVO.getDepositCity());
        payload.setPayaccnam(paymentAccountVO.getAccountName());
        payload.setPayaccnbr(paymentAccountVO.getAccountNo());
        payload.setTrsamt(paymentSlipVO.getPaymentAmt());
        payload.setNusage(paymentSlipVO.getPayPurpose());
        payload.setUsrId(userId.toString());
        payload.setUsrName(this.cacheUtil.getUserName(userId));
        payload.setCcynbr(Integer.valueOf(10));
        payload.setTrstyp("100001");
        payload.setStlchn(PurchasePaymentEnum.PayStlchnEnum.ORDINARY.getCode());
        payload.setBnkflg(PurchasePaymentEnum.PaySystemEnum.YES.getCode());
        if (StringUtils.hasText((String)paymentSlipVO.getReceivingBank()) && paymentSlipVO.getReceivingBank().indexOf("\u62db\u5546") == -1) {
            payload.setBnkflg(PurchasePaymentEnum.PaySystemEnum.NO.getCode());
        } else {
            payload.setCrtadr("");
            payload.setCrtbnk("");
        }
        payload.setOrderType(PurchasePaymentEnum.OrderTypeEnum.CONTANT.getCode());
    }

    @Transactional(rollbackFor={Exception.class})
    public void createPaySerialNum(List<PaymentSlipPayload> payloadList) {
        String generateSeqNum = this.generateSeqNum("PAY_SERIAL_NUM", new String[0]);
        if (!CollectionUtils.isEmpty(payloadList)) {
            payloadList.stream().forEach(p -> {
                p.setPaySerialNum(generateSeqNum);
                this.update((PaymentSlipPayload)p);
            });
        }
    }

    public List<String> queryPaySerialNum() {
        return this.paymentSlipDAO.queryPaySerialNum();
    }

    @Transactional(rollbackFor={Exception.class})
    public void updatePayPurpose(Long id, String payPurpose, String paymentApplyNo) {
        Long userId = GlobalUtil.getLoginUserId();
        TDocHistPayload tDocHistPayload = new TDocHistPayload();
        tDocHistPayload.setDocId(id);
        tDocHistPayload.setDocNo(paymentApplyNo);
        tDocHistPayload.setHistTime(LocalDateTime.now());
        tDocHistPayload.setOwnerId(userId);
        tDocHistPayload.setCreateUserId(userId);
        tDocHistPayload.setDocType(PurchasePaymentEnum.PayDocType.CONTANT.getCode());
        tDocHistPayload.setHistType(PurchasePaymentEnum.PayHistType.HISTTYPE5.getDesc());
        tDocHistPayload.setHistDtl(PurchasePaymentEnum.PayHistDtl.DTL5.getDesc());
        this.tDocHistService.insert(tDocHistPayload);
        this.paymentSlipDAO.updatePayPurpose(id, payPurpose);
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateReceiveAccount(Long id, String receivingBank, String receivingAccount, String paymentApplyNo) {
        Long userId = GlobalUtil.getLoginUserId();
        TDocHistPayload tDocHistPayload = new TDocHistPayload();
        tDocHistPayload.setDocId(id);
        tDocHistPayload.setDocNo(paymentApplyNo);
        tDocHistPayload.setHistTime(LocalDateTime.now());
        tDocHistPayload.setOwnerId(userId);
        tDocHistPayload.setCreateUserId(userId);
        tDocHistPayload.setDocType(PurchasePaymentEnum.PayDocType.CONTANT.getCode());
        tDocHistPayload.setHistType(PurchasePaymentEnum.PayHistType.HISTTYPE2.getDesc());
        tDocHistPayload.setHistDtl(PurchasePaymentEnum.PayHistDtl.DTL2.getDesc());
        this.tDocHistService.insert(tDocHistPayload);
        this.paymentSlipDAO.updateReceiveAccount(id, receivingBank, receivingAccount);
    }

    @Transactional(rollbackFor={Exception.class})
    public void passOrReject(List<PaymentSlipPayload> paymentSlipPayloadList) {
        if (!CollectionUtils.isEmpty(paymentSlipPayloadList)) {
            List<Long> idList = paymentSlipPayloadList.stream().filter(p -> PurchasePaymentEnum.PaymentSlipStatus.PAID.getCode().equals(p.getState())).map(s -> s.getId()).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(idList)) {
                this.dealPaymentData(idList);
            }
            paymentSlipPayloadList.stream().forEach(p -> {
                if (PurchasePaymentEnum.PaymentSlipStatus.PAID.getCode().equals(p.getState())) {
                    p.setState(PurchasePaymentEnum.PaymentSlipStatus.PAID.getCode());
                    p.setPayMode(PurchasePaymentEnum.PayModeEnum.PAYMANUAL.getCode());
                    p.setPayStatus(PurchasePaymentEnum.PayStatusEnum.SUCCESS.getCode());
                    p.setPayTime(LocalDateTime.now());
                }
                this.update((PaymentSlipPayload)p);
            });
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void paymentCommit(List<PaymentSlipPayload> paymentSlipPayloadList) {
        if (!CollectionUtils.isEmpty(paymentSlipPayloadList)) {
            paymentSlipPayloadList.stream().forEach(p -> this.update((PaymentSlipPayload)p));
        }
    }

    public BookAccountVO queryReceiveAccountInfo(Long id) {
        return this.bookAccountService.queryByKey(id);
    }

    public Boolean isOtherStatusByPaymentApplyId(Long paymentApplyId) {
        return this.paymentSlipDAO.isOtherStatusByPaymentApplyId(paymentApplyId);
    }

    public void translate(PaymentSlipVO paymentSlipVO, Map<Long, String> resultMap, Map<Long, List<BookAccountVO>> accountMap) {
        if (paymentSlipVO.getReceivingCompanyBookId() != null) {
            paymentSlipVO.setReceivingCompanyBookIdDesc(resultMap.get(paymentSlipVO.getReceivingCompanyBookId()));
        }
        if (paymentSlipVO.getPayCompanyBookId() != null) {
            paymentSlipVO.setPayCompanyBookIdDesc(resultMap.get(paymentSlipVO.getPayCompanyBookId()));
        }
        if (paymentSlipVO.getPaymentAccount() != null && accountMap.containsKey(Long.valueOf(paymentSlipVO.getPaymentAccount()))) {
            paymentSlipVO.setPaymentAccountDesc(accountMap.get(Long.valueOf(paymentSlipVO.getPaymentAccount())).get(0).getAccountNo());
        }
        if (paymentSlipVO.getReceivingAccount() != null && accountMap.containsKey(Long.valueOf(paymentSlipVO.getReceivingAccount()))) {
            paymentSlipVO.setReceivingAccountDesc(accountMap.get(Long.valueOf(paymentSlipVO.getReceivingAccount())).get(0).getAccountNo());
        }
    }

    public void closePaymentContractAndUpdatePaymentApply(Long paymentApplyId, BigDecimal currPayment) {
        PurchaseContractManagerVO purchaseContractManagerVO;
        List purchasePaymentVOS;
        BigDecimal currentPaymentApplyAmt = currPayment;
        PurchasePaymentService purchasePaymentService = (PurchasePaymentService)SpringUtil.getBean(PurchasePaymentService.class);
        PurchasePaymentVO purchasePaymentVO = purchasePaymentService.queryByKey(paymentApplyId);
        String docNo = purchasePaymentVO.getDocNo();
        Boolean closeFlag = true;
        if (PurchasePaymentEnum.PaymentType.ADVANCE_PAY.getCode().equals(purchasePaymentVO.getPaymentApplicationType())) {
            closeFlag = false;
        }
        if (!CollectionUtils.isEmpty((Collection)(purchasePaymentVOS = purchasePaymentService.queryByDocNo(docNo, Arrays.asList(PurchasePaymentEnum.PaymentStatus.PARTIAL_PAY.getCode(), PurchasePaymentEnum.PaymentStatus.PAID.getCode(), PurchasePaymentEnum.PaymentStatus.WRITTEN_OFF.getCode()))))) {
            List<Long> paymentApplyIdList;
            List<PaymentSlipVO> paymentSlipVOS;
            List advancePayPurchasePaymentVOS = purchasePaymentVOS.stream().filter(p -> PurchasePaymentEnum.PaymentType.ADVANCE_PAY.getCode().equals(p.getPaymentApplicationType()) && PurchasePaymentEnum.PaymentStatus.PAID.getCode().equals(p.getState())).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(advancePayPurchasePaymentVOS)) {
                closeFlag = false;
            }
            if (!CollectionUtils.isEmpty(paymentSlipVOS = this.paymentSlipDAO.queryByPaymentApplyIdListAndState(paymentApplyIdList = purchasePaymentVOS.stream().map(p -> p.getId()).collect(Collectors.toList()), PurchasePaymentEnum.PaymentSlipStatus.PAID.getCode()))) {
                BigDecimal totalPaymentAmt = paymentSlipVOS.stream().map(p -> p.getPaymentAmt()).reduce(BigDecimal.ZERO, BigDecimal::add);
                currPayment = currPayment.add(totalPaymentAmt);
            }
            BigDecimal totalPamentApplyAmt = paymentSlipVOS.stream().filter(p -> p.getPaymentApplyId().equals(paymentApplyId)).map(s -> s.getPaymentAmt()).reduce(BigDecimal.ZERO, BigDecimal::add);
            currentPaymentApplyAmt = totalPamentApplyAmt.add(currentPaymentApplyAmt);
        }
        PurchasePaymentPayload purchasePaymentPayload = new PurchasePaymentPayload();
        purchasePaymentPayload.setId(purchasePaymentVO.getId());
        if (currentPaymentApplyAmt.compareTo(purchasePaymentVO.getCurrPaymentAmt()) < 0) {
            purchasePaymentPayload.setState(PurchasePaymentEnum.PaymentStatus.PARTIAL_PAY.getCode());
            purchasePaymentService.updateByKeyDynamic(purchasePaymentPayload);
        } else {
            purchasePaymentPayload.setState(PurchasePaymentEnum.PaymentStatus.PAID.getCode());
            purchasePaymentService.updateByKeyDynamic(purchasePaymentPayload);
            if (PurchasePaymentEnum.PaymentDocType.AGREEMENT.getCode().equals(purchasePaymentVO.getDocType()) && PurchasePaymentEnum.AcceptanceMethod.WITHDRAW.getCode().equals(purchasePaymentVO.getPaymentApplicationType())) {
                this.resWithdrawApplyService.updateWithdrawStatusByPaymentApplyId(purchasePaymentVO.getId(), PurchasePaymentEnum.WithdrawStatus.PAID.getCode());
            }
        }
        if (closeFlag.booleanValue() && PurchasePaymentEnum.PaymentDocType.CONTRACT.getCode().equals(purchasePaymentVO.getDocType()) && (purchaseContractManagerVO = this.purchaseContractManagerService.queryByNo(purchasePaymentVO.getDocNo())).getAmt() != null && purchaseContractManagerVO.getAmt().compareTo(currPayment) == 0) {
            PurchaseContractManagerPayload payload = new PurchaseContractManagerPayload();
            payload.setId(purchaseContractManagerVO.getId());
            payload.setContractStatus(PurchaseContractStatusEnum.CLOSE.getCode());
            this.purchaseContractManagerService.update(payload);
        }
    }

    public void closePaymentContract(String contractNo) {
        PurchasePaymentService purchasePaymentService = (PurchasePaymentService)SpringUtil.getBean(PurchasePaymentService.class);
        List purchasePaymentVOS = purchasePaymentService.queryByDocNo(contractNo, Arrays.asList(PurchasePaymentEnum.PaymentStatus.PARTIAL_PAY.getCode(), PurchasePaymentEnum.PaymentStatus.PAID.getCode(), PurchasePaymentEnum.PaymentStatus.WRITTEN_OFF.getCode()));
        if (!CollectionUtils.isEmpty((Collection)purchasePaymentVOS)) {
            List advancePayPurchasePaymentVOS = purchasePaymentVOS.stream().filter(p -> PurchasePaymentEnum.PaymentType.ADVANCE_PAY.getCode().equals(p.getPaymentApplicationType()) && PurchasePaymentEnum.PaymentStatus.PAID.getCode().equals(p.getState())).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(advancePayPurchasePaymentVOS)) {
                return;
            }
            List<Long> paymentApplyIdList = purchasePaymentVOS.stream().map(PurchasePaymentVO::getId).collect(Collectors.toList());
            List<PaymentSlipVO> paymentSlipVOS = this.paymentSlipDAO.queryByPaymentApplyIdListAndState(paymentApplyIdList, PurchasePaymentEnum.PaymentSlipStatus.PAID.getCode());
            if (!CollectionUtils.isEmpty(paymentSlipVOS)) {
                BigDecimal totalPaymentAmt = paymentSlipVOS.stream().map(PaymentSlipVO::getPaymentAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
                PurchaseContractManagerVO purchaseContractManagerVO = this.purchaseContractManagerService.queryByNo(contractNo);
                if (purchaseContractManagerVO.getAmt() != null && purchaseContractManagerVO.getAmt().compareTo(totalPaymentAmt) == 0) {
                    PurchaseContractManagerPayload payload = new PurchaseContractManagerPayload();
                    payload.setId(purchaseContractManagerVO.getId());
                    payload.setContractStatus(PurchaseContractStatusEnum.CLOSE.getCode());
                    this.purchaseContractManagerService.update(payload);
                }
            }
        }
    }

    public Map<Long, BigDecimal> findNoPayAmtByPaymentApplyIdIn(Set<Long> paymentApplyIdSet) {
        List<Tuple> noPayAmtByPaymentApplyIdIn = this.paymentSlipDAO.findNoPayAmtByPaymentApplyIdIn(paymentApplyIdSet);
        return noPayAmtByPaymentApplyIdIn.stream().collect(Collectors.toMap(tuple -> (Long)tuple.get(0, Long.class), tuple -> Objects.requireNonNullElse((BigDecimal)tuple.get(1, BigDecimal.class), BigDecimal.ZERO)));
    }

    public PaymentSlipServiceImpl(PaymentSlipRepo paymentSlipRepo, PaymentSlipDAO paymentSlipDAO, BusinessPartnerService businessPartnerService, PurchaseAgreementService purchaseAgreementService, BookAccountService bookAccountService, BkPayDetailRecordService bkPayDetailRecordService, TDocHistService tDocHistService, CacheUtil cacheUtil, ResWithdrawApplyService resWithdrawApplyService, PrdMessageConfigService messageConfigService) {
        this.paymentSlipRepo = paymentSlipRepo;
        this.paymentSlipDAO = paymentSlipDAO;
        this.businessPartnerService = businessPartnerService;
        this.purchaseAgreementService = purchaseAgreementService;
        this.bookAccountService = bookAccountService;
        this.bkPayDetailRecordService = bkPayDetailRecordService;
        this.tDocHistService = tDocHistService;
        this.cacheUtil = cacheUtil;
        this.resWithdrawApplyService = resWithdrawApplyService;
        this.messageConfigService = messageConfigService;
    }
}

