/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.system.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.system.payload.PrdSystemFunctionPayload;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemFunctionQuery;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemFunctionService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemFunctionVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.system.convert.PrdSystemFunctionConvert;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemFunctionDAO;
import com.elitesland.tw.tw5.server.prd.system.entity.PrdSystemFunctionDO;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PrdSystemFunctionServiceImpl
implements PrdSystemFunctionService {
    private static final Logger log = LoggerFactory.getLogger(PrdSystemFunctionServiceImpl.class);
    private final PrdSystemFunctionDAO dao;
    private final CacheUtil cacheUtil;

    @Transactional
    public PrdSystemFunctionVO insert(PrdSystemFunctionPayload payload) {
        PrdSystemFunctionQuery query = new PrdSystemFunctionQuery();
        query.setFunctionCode(payload.getFunctionCode());
        int count = this.dao.queryListDynamic(query).size();
        if (count > 0) {
            throw TwException.error("", "\u7f16\u53f7\u4e0d\u53ef\u91cd\u590d");
        }
        PrdSystemFunctionDO ado = PrdSystemFunctionConvert.INSTANCE.toDo(payload);
        this.dao.save(ado);
        this.cacheUtil.loadSystemFunctionCache();
        return PrdSystemFunctionConvert.INSTANCE.toVo(ado);
    }

    @Transactional
    public Long update(PrdSystemFunctionPayload payload) {
        PrdSystemFunctionQuery query = new PrdSystemFunctionQuery();
        query.setFunctionCode(payload.getFunctionCode());
        query.setId(payload.getId());
        int count = this.dao.queryListDynamic(query).size();
        if (count > 0) {
            throw TwException.error("", "\u7f16\u53f7\u4e0d\u53ef\u91cd\u590d");
        }
        this.dao.updateByKeyDynamic(payload);
        this.cacheUtil.loadSystemFunctionCache();
        return 0L;
    }

    public PrdSystemFunctionVO queryByKey(Long key) {
        return this.dao.queryByKey(key);
    }

    public List<PrdSystemFunctionVO> queryList(PrdSystemFunctionQuery query) {
        return this.dao.queryListDynamic(query);
    }

    public PrdSystemFunctionVO findByCode(String code) {
        return this.dao.queryByCode(code);
    }

    public PagingVO<PrdSystemFunctionVO> paging(PrdSystemFunctionQuery query) {
        return this.dao.queryPaging(query);
    }

    @Transactional
    public boolean delete(List<Long> keys) {
        this.dao.delete(keys);
        this.cacheUtil.loadSystemFunctionCache();
        return true;
    }

    private void getFunctionDatas(PrdSystemFunctionVO fvo, List<Long> keyIds) {
        if (!keyIds.contains(fvo.getId())) {
            keyIds.add(fvo.getId());
        }
        if (fvo.getChildren() != null && fvo.getChildren().size() > 0) {
            fvo.getChildren().forEach(fvoChildren -> this.getFunctionDatas((PrdSystemFunctionVO)fvoChildren, keyIds));
        }
    }

    public PrdSystemFunctionServiceImpl(PrdSystemFunctionDAO dao, CacheUtil cacheUtil) {
        this.dao = dao;
        this.cacheUtil = cacheUtil;
    }
}

