package com.elitesland.tw.tw5.server.common.funConfig.dao;

import com.elitesland.tw.tw5.api.common.funConfig.payload.BusinessDocTypeUploadRecordPayload;
import com.elitesland.tw.tw5.api.common.funConfig.query.BusinessDocTypeUploadRecordQuery;
import com.elitesland.tw.tw5.api.common.funConfig.vo.BusinessDocTypeUploadRecordVO;
import com.elitesland.tw.tw5.server.common.funConfig.entity.BusinessDocTypeUploadRecordDO;
import com.elitesland.tw.tw5.server.common.funConfig.entity.QBusinessDocTypeUploadRecordDO;
import com.elitesland.tw.tw5.server.common.funConfig.repo.BusinessDocTypeUploadRecordRepo;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 通用文档-文档上传标记
 *
 * @author duwh
 * @date 2023-12-22
 */
@Repository
@RequiredArgsConstructor
public class BusinessDocTypeUploadRecordDAO {

    private final JPAQueryFactory jpaQueryFactory;
    private final BusinessDocTypeUploadRecordRepo repo;
    private final QBusinessDocTypeUploadRecordDO qdo = QBusinessDocTypeUploadRecordDO.businessDocTypeUploadRecordDO;

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<BusinessDocTypeUploadRecordVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(BusinessDocTypeUploadRecordVO.class,
                qdo.id,
                //qdo.remark,
                //qdo.createUserId,
                //qdo.creator,
                //qdo.createTime,
                //qdo.modifyUserId,
                //qdo.updater,
                //qdo.modifyTime,
                // 单据类型
                qdo.docType,
                // 单据主键
                qdo.docId,
                // 文档类型配置主键 prd_business_doc_type_config.id
                qdo.configId
        )).from(qdo);
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<BusinessDocTypeUploadRecordVO> getJpaQueryWhere(BusinessDocTypeUploadRecordQuery query) {
        JPAQuery<BusinessDocTypeUploadRecordVO> jpaQuery = getJpaQuerySelect();
            // 条件封装
            jpaQuery.where(where(query));
            // 常用基础查询条件拼装
            SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
            // 动态排序
            jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
            return jpaQuery;
    }

    /**
     * 统计
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    public long count(BusinessDocTypeUploadRecordQuery query) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory
        .select(qdo.count())
        .from(qdo);
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        long total = jpaQuery.fetchOne();
        return total;
    }

    /**
     * 查询条件封装
     *
     * @param query 条件
     * @return {@link Predicate}
     */
    private Predicate where(BusinessDocTypeUploadRecordQuery query){
        List<Predicate> list = new ArrayList<>();
        /** 记录唯一ID 精确 */
        if (!ObjectUtils.isEmpty(query.getId())) {
            list.add(qdo.id.eq(query.getId()));
        }
        /** 单据类型 精确 */
        if (!ObjectUtils.isEmpty(query.getDocType())) {
            list.add(qdo.docType.eq(query.getDocType()));
        }
        /** 单据主键 精确 */
        if (!ObjectUtils.isEmpty(query.getDocId())) {
            list.add(qdo.docId.eq(query.getDocId()));
        }
        /** 文档类型配置主键 prd_business_doc_type_config.id 精确 */
        if (!ObjectUtils.isEmpty(query.getConfigId())) {
            list.add(qdo.configId.eq(query.getConfigId()));
        }
        return ExpressionUtils.allOf(list);
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public BusinessDocTypeUploadRecordVO queryByKey(Long id) {
        JPAQuery<BusinessDocTypeUploadRecordVO> jpaQuery = getJpaQuerySelect();
            jpaQuery.where(qdo.id.eq(id));
            jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 动态查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<BusinessDocTypeUploadRecordVO> queryListDynamic(BusinessDocTypeUploadRecordQuery query) {
        JPAQuery<BusinessDocTypeUploadRecordVO> jpaQuery = getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<BusinessDocTypeUploadRecordVO> queryPaging(BusinessDocTypeUploadRecordQuery query) {
        long total = count(query);
        if (total == 0) {
             return PagingVO.empty();
        }
        JPAQuery<BusinessDocTypeUploadRecordVO> jpaQuery = getJpaQueryWhere(query);
        List<BusinessDocTypeUploadRecordVO> result = jpaQuery
                .offset(query.getPageRequest().getOffset())
                .limit(query.getPageRequest().getPageSize())
                .fetch();
        return PagingVO.<BusinessDocTypeUploadRecordVO>builder().records(result).total(total).build();
    }

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public BusinessDocTypeUploadRecordDO save(BusinessDocTypeUploadRecordDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<BusinessDocTypeUploadRecordDO> saveAll(List<BusinessDocTypeUploadRecordDO> dos) {
        return repo.saveAll(dos);
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    @Transactional
    public long updateByKeyDynamic(BusinessDocTypeUploadRecordPayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
        .where(qdo.id.eq(payload.getId()));
        // 记录唯一ID
        if (payload.getId() != null) {
            update.set(qdo.id, payload.getId());
        }
        // 单据类型
        if (payload.getDocType() != null) {
            update.set(qdo.docType, payload.getDocType());
        }
        // 单据主键
        if (payload.getDocId() != null) {
            update.set(qdo.docId, payload.getDocId());
        }
        // 文档类型配置主键 prd_business_doc_type_config.id
        if (payload.getConfigId() != null) {
            update.set(qdo.configId, payload.getConfigId());
        }
        // 处理要设置成空的字段
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
            // 记录唯一ID
            if (nullFields.contains("id")) {
                update.setNull(qdo.id);
            }
            // 单据类型
            if (nullFields.contains("docType")) {
                update.setNull(qdo.docType);
            }
            // 单据主键
            if (nullFields.contains("docId")) {
                update.setNull(qdo.docId);
            }
            // 文档类型配置主键 prd_business_doc_type_config.id
            if (nullFields.contains("configId")) {
                update.setNull(qdo.configId);
            }
        }
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        // 执行修改
        return update.execute();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主集合
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
            .set(qdo.deleteFlag, 1)
            .where(qdo.id.in(keys));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }

}

