package com.elitesland.tw.tw5.server.common.funConfig.support;

import com.elitesland.tw.tw5.server.common.constants.BusinessDocTypeRefEnum;
import lombok.extern.slf4j.Slf4j;

import java.util.HashMap;

/**
 * 文档类型检查权限工厂
 *
 * @author duwh
 * @date 2023/12/11
 */
@Slf4j
public class BusinessDocTypeCheckAuthorityFactory {

    /**
     * 容器
     */
    public static final HashMap<Object, BusinessDocTypeCheckAuthorityService> SERVICE_MAP = new HashMap<>();


    /**
     * 注册到容器中
     *
     * @param docTypeRefEnum 文档类型引用枚举
     * @param service        服务
     */
    public void register(BusinessDocTypeRefEnum docTypeRefEnum, BusinessDocTypeCheckAuthorityService service) {
        if (null == docTypeRefEnum) {
            log.error("docTypeRefEnum not exit");
            throw new RuntimeException("docTypeRefEnum not exit");
        }
        SERVICE_MAP.put(docTypeRefEnum.getCode(), service);
    }


    public static class Holder {
        private static BusinessDocTypeCheckAuthorityFactory instance = new BusinessDocTypeCheckAuthorityFactory();
    }

    public static BusinessDocTypeCheckAuthorityFactory getInstance() {
        return Holder.instance;
    }


}
