package com.elitesland.tw.tw5.server.common.permission.strategy.execute;

import cn.hutool.core.text.CharSequenceUtil;
import cn.zhxu.bs.FieldOps;
import cn.zhxu.bs.util.MapBuilder;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgOrganizationService;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgOrganizationRefVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemPermissionRuleVO;
import com.elitesland.tw.tw5.server.common.permission.strategy.BusinessObjectTypeStrategyService;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * @Author Quruiqizz
 * @Date 2023/11/9 13:42
 **/
@Service(value = "BUSINESS_OBJECT_TYPE_ORG_PRINCIPAL")
public class BusinessObjectTypeOrgPrincipal implements BusinessObjectTypeStrategyService {

    @Lazy
    @Autowired
    private PrdOrgOrganizationService orgOrganizationService;

    @Lazy
    @Autowired
    private CacheUtil cacheUtil;

    /**
     * 组织负责人
     *
     * @param rule
     * @param mapBuilder
     * @param ruleGroupExprList
     * @param loginUserId
     * @param defaultOrgId
     * @param childOrgIdSet
     * @param map
     * @return
     */
    @Override
    public boolean execute(PrdSystemPermissionRuleVO rule, MapBuilder mapBuilder, List<String> ruleGroupExprList, Long loginUserId, Long defaultOrgId, Set<Long> childOrgIdSet, Map<String, Object> map) {
        mapBuilder.group(rule.getRuleCode());

        if (!ObjectUtils.isEmpty(rule.getDeep()) && rule.getDeep().equals(1)) {
            List<Long> orgIds = cacheUtil.getAllChildOrgByUserId(loginUserId);
            if (!CollectionUtils.isEmpty(orgIds)) {
                mapBuilder.field(CharSequenceUtil.toCamelCase(rule.getRuleScope()), orgIds).op(FieldOps.InList);
                return true;
            }
            return false;
        }

        // 默认组织

        mapBuilder.field(CharSequenceUtil.toCamelCase(rule.getRuleScope()))
                .sql("exists (select poo.manage_id from prd_org_organization poo where poo.id = $1 and poo.manage_id = ? and poo.delete_flag = 0)", loginUserId);
        return true;
    }

}
