package com.elitesland.tw.tw5.server.common.permission.strategy.execute;

import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemPermissionRuleVO;
import com.elitesland.tw.tw5.server.common.permission.strategy.RoleStrategyService;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Set;

/**
 * @Author Quruiqizz
 * @Date 2023/11/10 10:45
 **/
@Service(value = "ROLE_BUSINESS_ROLE")
public class RoleBusinessRole implements RoleStrategyService {

    /**
     * 业务角色情况下
     *
     * @param rule
     * @param systemRoleCodes
     * @param systemOrgRoleIds
     * @param systemOrgRoleCodes
     * @return
     */
    @Override
    public boolean execute(PrdSystemPermissionRuleVO rule, List<String> systemRoleCodes, Set<Long> systemOrgRoleIds, Set<String> systemOrgRoleCodes) {
        return systemRoleCodes.contains(rule.getRuleScope());
    }

}
