package com.elitesland.tw.tw5.server.demo.service;

import com.elitesland.tw.tw5.api.demo.query.DemoCompanyBankQuery;
import com.elitesland.tw.tw5.api.demo.service.DemoCompanyService;
import com.elitesland.tw.tw5.api.demo.vo.DemoCompanyBankVO;
import com.elitesland.tw.tw5.server.demo.dao.DemoCompanyDAO;
import com.elitescloud.cloudt.common.base.PagingVO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * 标准样例service
 * @author wangding
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class DemoCompanyServiceImpl implements DemoCompanyService {

    private final DemoCompanyDAO dao;

    @Override
    public PagingVO<DemoCompanyBankVO> paging(DemoCompanyBankQuery query) {

        return dao.queryPaging(query);
    }

    @Override
    public DemoCompanyBankVO queryByKey(Long key) {
        return dao.queryByKey(key);
    }




}
