package com.elitesland.tw.tw5.server.openapi.controller;

import com.elitesland.tw.tw5.api.prd.org.query.PrdOrgEmployeeQuery;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgDimensionService;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgEmployeeService;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgOrganizationService;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author zoey
 * @Description:易稻壳数据同步接口
 * @date 2023/3/24 - 10:38
 */
@Api("易稻壳数据同步接口")
@RestController
@RequiredArgsConstructor
@RequestMapping("/openapi/yeedoc")
@Slf4j
public class YeedocSyncController {

    private final PrdOrgDimensionService dimensionService;
    private final PrdOrgOrganizationService organizationService;
    private final PrdOrgEmployeeService employeeService;

    /**
     * 查询组织维度
     *
     * @return result
     */
    @ApiOperation("查询组织维度")
    @GetMapping("/org/dimension/list")
    public TwOutputUtil queryOrgdimensions() {
        return TwOutputUtil.ok(dimensionService.queryList());
    }


    /**
     * 查询组织列表
     *
     * @return result
     */
    @ApiOperation("查询组织列表")
    @GetMapping("/org/org/list")
    public TwOutputUtil queryOrgList() {
        return TwOutputUtil.ok(organizationService.queryList());
    }


    /**
     * 查询员工列表
     *
     * @return result
     */
    @ApiOperation("查询员工列表")
    @UdcNameClass
    @GetMapping("/org/employee/list")
    public TwOutputUtil queryOrgEmployeeList() {
        PrdOrgEmployeeQuery query = new PrdOrgEmployeeQuery();
        return TwOutputUtil.ok(employeeService.queryList(query));
    }


    /**
     * 查询员工组织关系列表
     *
     * @return result
     */
    @ApiOperation("查询员工组织关系列表")
    @GetMapping("/org/employeeRef/list")
    public TwOutputUtil queryOrgEmployeeRefList() {
        return TwOutputUtil.ok(organizationService.queryOrgRefList());
    }

    /**
     * 查询组织角色列表
     *
     * @return result
     */
    @ApiOperation("查询组织角色列表")
    @GetMapping("/org/orgRole/list")
    public TwOutputUtil queryorgRoleList() {
        return TwOutputUtil.ok(organizationService.queryRoleList());
    }





    /**
     * 返回文档库 权限
     *
     * @param email  电子邮件
     * @param itemId 项目id
     * @return {@link TwOutputUtil}
     */
    @ApiOperation("根据用户邮箱获取易稻壳权限--标准版")
    @GetMapping("/callback/item/permissions")
    public TwOutputUtil permissions(String email, String itemId) {
        log.info("email:{},itemId:{}", email, itemId);
        String result = "OWN";
        return TwOutputUtil.ok(result);
    }


}
