package com.elitesland.tw.tw5.server.prd.ab.entity;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.time.LocalDate;

/**
 * @author carl.wang
 * @Description:联系人表
 */
@Entity
@Table(name = "prd_ab_contacts", indexes = {
        @Index(name = "book_index", columnList = "book_id"),
})
@org.hibernate.annotations.Table(appliesTo = "prd_ab_contacts", comment = "联系人表")
@Data
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class PrdAbContactsDO extends BaseModel {

    @Comment("地址簿id")
    @Column(name = "book_id", nullable = false)
    private Long bookId;

    @Comment("tw4.0联系人表ID")
    @Column(name = "contacts_id_v4")
    private Long contactsIdV4;

    @Comment("联系人编号")
    @Column()
    private String contactsNo;

    @Comment("联系人类型")
    @Column(name = "contacts_type")
    private String contactsType;

    @Comment("联系人姓名")
    @Column(name = "contacts_name")
    private String contactsName;

    @Comment("联系人状态")
    @Column()
    private String contactsStatus;

    @Comment("联系人手机")
    @Column(name = "contacts_phone")
    private String contactsPhone;

    @Comment("联系人电话")
    @Column(name = "contacts_telephone")
    private String contactsTelephone;

    @Comment("邮箱")
    @Column(name = "contacts_email")
    private String contactsEmail;

    @Comment("联系地址")
    @Column(name = "contacts_address")
    private String contactsAddress;

    @Comment("社交账户类型")
    @Column(name = "social_account_type")
    private String socialAccountType;

    @Comment("社交账户")
    @Column(name = "social_account")
    private String socialAccount;

    @Comment("部门")
    @Column(name = "contacts_department")
    private String contactsDepartment;

    @Comment("岗位")
    @Column(name = "contacts_position")
    private String contactsPosition;

    @Comment("性别")
    @Column()
    private String sex;

    @Comment("生日")
    @Column()
    private LocalDate birthday;

    @Comment("是否是关键决策人")
    @Column()
    private Boolean isKeyPerson;
}
