package com.elitesland.tw.tw5.server.prd.ab.service;

import com.elitesland.tw.tw5.api.prd.ab.payload.PrdAbInvoicePayload;
import com.elitesland.tw.tw5.api.prd.ab.service.PrdAbInvoiceService;
import com.elitesland.tw.tw5.api.prd.ab.vo.PrdAbInvoiceVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemLogService;
import com.elitesland.tw.tw5.server.common.HttpUtil;
import com.elitesland.tw.tw5.server.common.StringUtil;
import com.elitesland.tw.tw5.server.common.service.TransferUtilServiceImpl;
import com.elitesland.tw.tw5.server.prd.ab.convert.PrdAbInvoiceConvert;
import com.elitesland.tw.tw5.server.prd.ab.dao.PrdAbInvoiceDAO;
import com.elitesland.tw.tw5.server.prd.ab.entity.PrdAbInvoiceDO;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.FunctionSelectionEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.PrdSystemLogEnum;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Author carl.wang
 * @Description 开票信息管理
 * @Date 20220527
 **/
@Service
@RequiredArgsConstructor
@Slf4j
public class PrdAbInvoiceServiceImpl implements PrdAbInvoiceService {
    private final CacheUtil cacheUtil;
    private final PrdAbInvoiceDAO dao;
    private final PrdSystemLogService logService;
    private final TransferUtilServiceImpl transferUtilService;
    private final HttpUtil httpUtil;

    @Value("${tw4.invoice.operation}")
    private String invoice_operation;

    @Value("${tw4.invoice.del}")
    private String invoice_del;

    @Transactional
    @Override
    public PrdAbInvoiceVO save(PrdAbInvoicePayload payload) {
        //同步到4.0
//        Map<String, Object> map = transferUtilService.beanToMap(payload);
//        String result = httpUtil.sendSyncPost(invoice_operation, map);
//        String invoiceId = httpUtil.geResultData(result);
//        long invoiceIdV4 = 0;
//        if (StringUtils.hasText(invoiceId)) {
//            if (StringUtil.isInteger(invoiceId)) {
//                invoiceIdV4 = Long.valueOf(invoiceId);
//            }
//        }

        PrdAbInvoiceDO contactsDO = PrdAbInvoiceConvert.INSTANCE.toDo(payload);
//        contactsDO.setInvoiceIdV4(invoiceIdV4);
        contactsDO = dao.save(contactsDO);
        saveBaseLog(payload.getBookId(), payload.getObjectType(), PrdSystemLogEnum.CREATE.getDesc());
        return PrdAbInvoiceConvert.INSTANCE.toVo(contactsDO);
    }

    /**
     * 保存基础日志
     *
     * @param bookId     地址簿id
     * @param objectType 主档类型
     * @param logType    记录内容
     */
    void saveBaseLog(Long bookId, String objectType, String logType) {
        Long customerId = dao.queryIdByBookId(bookId);
        logService.saveNewLog(customerId, objectType, logType + "开票数据");

    }

    @Transactional
    @Override
    public boolean delete(Long bookId, String objectType, List<Long> keys) {
        //同步到4.0
//        List<Long> ids = dao.queryTW4IdsByIds(keys);
//        Map<String, Object> map = new HashMap<>();
//        map.put("ids", org.apache.commons.lang3.StringUtils.join(dao.queryTW4IdsByIds(keys), ","));
//        String result = httpUtil.sendSyncGet(invoice_del, map);
//        httpUtil.geResultData(result);

        dao.delete(keys);
        saveBaseLog(bookId, objectType, PrdSystemLogEnum.DELETE.getDesc());
        return true;
    }

    @Transactional
    @Override
    public boolean update(PrdAbInvoicePayload payload) {
        //同步到4.0
//        Long invoiceIdV4 = dao.queryTW4IdById(payload.getId());
//        Map<String, Object> map = transferUtilService.beanToMap(payload);
//        map.put("id", invoiceIdV4);
//        String result = httpUtil.sendSyncPost(invoice_operation, map);
//        httpUtil.geResultData(result);
        PrdAbInvoiceDO contactsDO = PrdAbInvoiceConvert.INSTANCE.toDo(payload);
//        contactsDO.setInvoiceIdV4(invoiceIdV4);
        dao.save(contactsDO);
        saveBaseLog(payload.getBookId(), payload.getObjectType(), PrdSystemLogEnum.UPDATE.getDesc());
        return true;
    }

    @Override
    public List<PrdAbInvoiceVO> queryList(Long bookId) {
        if (bookId == null){
            return null;
        }
        List<PrdAbInvoiceVO> contactsVOS = dao.queryList(bookId);
        contactsVOS.forEach(contactsVO -> transferSystemSelection(contactsVO));
        return contactsVOS;
    }

    /**
     * 全局翻译
     *
     * @param vo
     */
    void transferSystemSelection(PrdAbInvoiceVO vo) {
        vo.setTaxReteName(cacheUtil.transferSystemSelection(FunctionSelectionEnum.AbTAX_RATE.getCode(), vo.getTaxRete()));
        vo.setInvoiceTypeName(cacheUtil.transferSystemSelection(FunctionSelectionEnum.AbINV_TYPE.getCode(), vo.getInvoiceType()));
        vo.setCurrencyName(cacheUtil.transferSystemSelection(FunctionSelectionEnum.SystemCurrCode.getCode(), vo.getCurrency()));
    }
}
