package com.elitesland.tw.tw5.server.prd.acc.controller;


import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.acc.payload.AccReimSourceRecordPayload;
import com.elitesland.tw.tw5.api.prd.acc.query.AccReimSourceRecordQuery;
import com.elitesland.tw.tw5.api.prd.acc.service.AccReimSourceRecordService;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccReimSourceRecordVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 报销金额来源记录管理
 *
 * @author sunxw
 * @date 2023-12-04
 */
@Api(tags = "报销金额来源记录管理")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/acc/accReimSourceRecord")
@Slf4j
public class AccReimSourceRecordController {

    private final AccReimSourceRecordService accReimSourceRecordService;

    /**
     * 报销金额来源记录管理-新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("报销金额来源记录管理-新增")
    public TwOutputUtil<AccReimSourceRecordVO> insert(@RequestBody AccReimSourceRecordPayload payload) {
        return TwOutputUtil.ok(accReimSourceRecordService.insert(payload));
    }

    /**
     * 报销金额来源记录管理-更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("报销金额来源记录管理-更新")
    public TwOutputUtil<AccReimSourceRecordVO> update(@RequestBody AccReimSourceRecordPayload payload) {
        return TwOutputUtil.ok(accReimSourceRecordService.update(payload));
    }

    /**
     * 报销金额来源记录管理-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping("update")
    @ApiOperation("报销金额来源记录管理-更新,支持置空 置空的字段需需要借助 protected List<String> nullFields;")
    public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody AccReimSourceRecordPayload payload) {
        return TwOutputUtil.ok(accReimSourceRecordService.updateByKeyDynamic(payload));
    }

    /**
     * 报销金额来源记录管理-主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    // @UdcNameClass
    @ApiOperation("报销金额来源记录管理-主键查询")
    public TwOutputUtil<AccReimSourceRecordVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(accReimSourceRecordService.queryByKey(key));
    }

    /**
     * 报销金额来源记录管理-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    // @UdcNameClass
    @ApiOperation("报销金额来源记录管理-分页")
    public TwOutputUtil<PagingVO<AccReimSourceRecordVO>> paging(AccReimSourceRecordQuery query) {
        return TwOutputUtil.ok(accReimSourceRecordService.queryPaging(query));
    }

    /**
     * 报销金额来源记录管理-查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    // @UdcNameClass
    @ApiOperation("报销金额来源记录管理-查询列表")
    public TwOutputUtil<List<AccReimSourceRecordVO>> queryList(AccReimSourceRecordQuery query) {
        return TwOutputUtil.ok(accReimSourceRecordService.queryListDynamic(query));
    }

    /**
     * 报销金额来源记录管理-删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("报销金额来源记录管理-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
        accReimSourceRecordService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}

