package com.elitesland.tw.tw5.server.prd.acc.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * @author sunxw
 * @description 报销科目配置
 * @Date 2023/12/15
 */
@Entity
@Table(name = "acc_reim_bus_item_config", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "acc_reim_bus_item_config", comment = "报销科目配置")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class AccReimBusItemConfigDO extends BaseModel implements Serializable {

    @Comment("报销单据类型")
    @Column(name = "reim_doc_type")
    private String reimDocType;

    @Comment("事由类型")
    @Column(name = "reason_type")
    private String reasonType;

    @Comment("扩展字段1")
    @Column()
    private String extString1;

    @Comment("扩展字段2")
    @Column()
    private String extString2;

    @Comment("扩展字段3")
    @Column()
    private String extString3;

    public void copy(AccReimBusItemConfigDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }

}
