package com.elitesland.tw.tw5.server.prd.acc.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import javax.validation.constraints.*;

/**
 * 报销配置连号规则配置
 *
 * @author zoey
 * @date 2024-04-16
 */
@Entity
@Table(name = "acc_reim_setting_continuous", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "acc_reim_setting_continuous", comment = "报销配置连号规则配置")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class AccReimSettingContinuousDO extends BaseModel implements Serializable  {
    /** 发票类型 */
    @Comment("发票类型")
    @Column()
    private String invoiceType;
    /** 校验日期区间 */
    @Comment("校验日期区间")
    @Column()
    private Integer checkDays;
    /** 号码间隔合理区间 */
    @Comment("号码间隔合理区间")
    @Column()
    private Integer checkStep;
    /** 校验范围 */
    @Comment("校验范围")
    @Column()
    private String checkRange;

    public void copy(AccReimSettingContinuousDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
