package com.elitesland.tw.tw5.server.prd.adm.controller;

import com.elitesland.tw.tw5.api.prd.adm.service.AdmReasonService;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 事由管理-行政
 *
 * @author carl
 * @date 2023-10-12
 */
@Api(tags = "事由管理-行政")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/adm/admReason")
@Slf4j
public class AdmReasonController {

    private final AdmReasonService admReasonService;

    /**
     * 事由管理-获取事由号数据
     *
     * @param reasonType 事由类型
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/queryReasonInfos")
    @ApiOperation("事由管理-获取事由号数据 ")
    public TwOutputUtil queryReasonInfos(String reasonType) {
        return TwOutputUtil.ok(admReasonService.queryReasonInfos(reasonType));
    }

}

