package com.elitesland.tw.tw5.server.prd.crm.controller;

import com.elitesland.tw.tw5.api.prd.crm.payload.CrmOppoConversionRatePayload;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOppoConversionRateService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOppoConversionRateVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOppoDataSourceFieldsVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;


import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.List;


/**
 * 商机成单率配置
 *
 * @author likunpeng
 * @date 2023-11-03
 */
@Api(tags = "商机成单率配置")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm/crmOppoConversionRate")
@Slf4j
public class CrmOppoConversionRateController {

    private final CrmOppoConversionRateService crmOppoConversionRateService;


    /**
     * 商机成单率配置-新增或修改
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("商机成单率配置-新增或修改")
    public TwOutputUtil<CrmOppoConversionRateVO> insertOrUpdate(@RequestBody CrmOppoConversionRatePayload payload){
         return TwOutputUtil.ok(crmOppoConversionRateService.insertOrUpdate(payload));
    }

    /**
     * 商机成单率配置-查看
     * @return {@link TwOutputUtil}
     */
    @GetMapping
    @ApiOperation("商机成单率配置-查看")
    @UdcNameClass
    public TwOutputUtil<CrmOppoConversionRateVO> queryConfig() {
        return TwOutputUtil.ok(crmOppoConversionRateService.queryConfig());
    }


    /**
     * 商机成单率配置-数据源字段列表
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/queryDataSourceFields")
    @ApiOperation("商机成单率配置-数据源字段列表")
    public TwOutputUtil<List<CrmOppoDataSourceFieldsVO>> queryDataSourceFields() {
        return TwOutputUtil.ok(crmOppoConversionRateService.queryDataSourceFields());
    }



}

