package com.elitesland.tw.tw5.server.prd.crm.dao;


import com.elitesland.tw.tw5.api.prd.crm.vo.CrmPeopleEducateVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.crm.entity.QCrmPeopleEducateDO;
import com.elitesland.tw.tw5.server.prd.crm.repo.CrmPeopleEducateRepo;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;

import java.util.ArrayList;
import java.util.List;

/**
 * 人脉-工作经历
 *
 * @author carl
 * @date 2022/12/07
 */
@Repository
@RequiredArgsConstructor
public class CrmPeopleEducateDAO {

    private final JPAQueryFactory jpaQueryFactory;
    private final CrmPeopleEducateRepo repo;
    private final QCrmPeopleEducateDO qdo = QCrmPeopleEducateDO.crmPeopleEducateDO;


    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<CrmPeopleEducateVO> getJpaQuerySelect() {
        JPAQuery<CrmPeopleEducateVO> jpaQuery = jpaQueryFactory.select(Projections.bean(CrmPeopleEducateVO.class,
                qdo.id,
                qdo.peopleId,
                qdo.school,
                qdo.major,
                qdo.startDate,
                qdo.endDate,
                qdo.education
        )).from(qdo);
        return jpaQuery;
    }

    /**
     * @param peopleId 人脉主键
     * @return
     * @Description
     **/
    public List<CrmPeopleEducateVO> queryList(Long peopleId) {
        JPAQuery<CrmPeopleEducateVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.peopleId.eq(peopleId));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        List<OrderItem> orders = new ArrayList<>();
        orders.add(OrderItem.desc("startDate"));
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, orders));
        return jpaQuery.fetch();
    }

    /**
     * @param key 主键
     * @return
     * @Description 主键查询
     **/
    public CrmPeopleEducateVO queryByKey(Long key) {
        JPAQuery<CrmPeopleEducateVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.id.eq(key));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主键
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.deleteFlag, 1)
                .where(qdo.id.in(keys));
        return update.execute();
    }
}
