package com.elitesland.tw.tw5.server.prd.humanresources.basebu.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdBaseRegionChangePayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdBaseRegionChangeQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdBaseRegionChangeService;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdBaseRegionChangeVO;
import io.seata.spring.annotation.GlobalTransactional;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;


/**
 * @author : WWW
 * @date : 2023-11-1
 * @desc : base地与社保地变更申请
 */

@RestController
@RequestMapping("/api/prdBaseRegionChange")
@RequiredArgsConstructor
@Api(value = "base地与社保地变更申请", tags = {"base地与社保地变更申请"})
public class PrdBaseRegionChangeController {

    private final PrdBaseRegionChangeService prdBaseRegionChangeService;


    @GetMapping("get/{id}")
    @ApiOperation("详情-base地与社保地变更申请")
    public TwOutputUtil<PrdBaseRegionChangeVO> get(@PathVariable Long id) {

        PrdBaseRegionChangeVO res = prdBaseRegionChangeService.get(id);
        return TwOutputUtil.ok(res);

    }


    @PostMapping("save")
    @GlobalTransactional
    @ApiOperation("新增-base地与社保地变更申请")
    public TwOutputUtil<Long> save(@RequestBody PrdBaseRegionChangePayload prdBaseRegionChangePayload) {

        PrdBaseRegionChangeVO res = prdBaseRegionChangeService.save(prdBaseRegionChangePayload);
        return TwOutputUtil.ok(res.getId());

    }


    @PostMapping("update")
    @ApiOperation("修改-base地与社保地变更申请")
    public TwOutputUtil<Long> update(@RequestBody PrdBaseRegionChangePayload prdBaseRegionChangePayload) {

        PrdBaseRegionChangeVO res = prdBaseRegionChangeService.update(prdBaseRegionChangePayload);
        return TwOutputUtil.ok(res.getId());

    }


    @PostMapping("updateByCondition")
    @ApiOperation("条件修改-base地与社保地变更申请")
    public TwOutputUtil<Long> updateByCondition(@RequestBody PrdBaseRegionChangePayload prdBaseRegionChangePayload) {

        Long res = prdBaseRegionChangeService.updateByCondition(prdBaseRegionChangePayload);
        return TwOutputUtil.ok(res);

    }

    @PostMapping("updateByBatch")
    @ApiOperation("批量修改-base地与社保地变更申请")
    public TwOutputUtil<Boolean> updateByBatch(@RequestBody List<PrdBaseRegionChangePayload> prdBaseRegionChangePayload) {

        Boolean res = prdBaseRegionChangeService.updateByBatch(prdBaseRegionChangePayload);
        return TwOutputUtil.ok(res);

    }

    @DeleteMapping("del")
    @ApiOperation("删除-base地与社保地变更申请")
    public TwOutputUtil<Long> del(Long[] ids) {

        Long res = prdBaseRegionChangeService.del(Arrays.asList(ids));
        return TwOutputUtil.ok(res);

    }


    @GetMapping("/page")
    @UdcNameClass
    @ApiOperation("分页查询-base地与社保地变更申请")
    public TwOutputUtil<PagingVO<PrdBaseRegionChangeVO>> page(PrdBaseRegionChangeQuery prdBaseRegionChangeQuery) {

        PagingVO<PrdBaseRegionChangeVO> res = prdBaseRegionChangeService.page(prdBaseRegionChangeQuery);
        return TwOutputUtil.ok(res);

    }


}

