package com.elitesland.tw.tw5.server.prd.humanresources.examination.callback;

import com.elitescloud.boot.exception.BusinessException;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdBaseBuChangePayload;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdPerformanceExamPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdPerformanceExamResultPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdPerformanceExamGradeQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdPerformanceExamResDtlQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.service.*;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.*;
import com.elitesland.workflow.WorkflowCallBack;
import com.elitesland.workflow.WorkflowConstant;
import com.elitesland.workflow.WorkflowResult;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import com.elitesland.workflow.payload.TaskAssigneePayload;
import com.elitesland.workflow.payload.TaskCompletedPayload;
import com.elitesland.workflow.payload.TaskCreatedPayload;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;


@Slf4j
@RestController
@RequestMapping(WorkflowConstant.WORKFLOW + "PERFORMANCE_EXAM" + WorkflowConstant.CALLBACK)
@Transactional
@RequiredArgsConstructor
public class PrdPerformanceExamCallback implements WorkflowCallBack {


    public final PrdPerformanceExamResultService prdPerformanceExamResultService;

    public final PrdPerformanceExamResDtlService prdPerformanceExamResDtlService;

    public final PrdPerformanceExamGradeService prdPerformanceExamGradeService;


    /**
     * 动态指定任务负责人
     *
     * @return 任务负责人ID列表
     */
    @Override
    @PostMapping(WorkflowConstant.TASK_ASSIGNEE_PATH)
    public WorkflowResult<ArrayList<String>> taskAssignee(@RequestBody TaskAssigneePayload payload) {
        log.info("动态指定任务负责人参数: {}", payload);
        return WorkflowResult.success(null);
    }

    /**
     * 任务创建回调
     */
    @Override
    @PostMapping(WorkflowConstant.TASK_CREATED_PATH)
    public WorkflowResult<Void> taskCreated(@RequestBody TaskCreatedPayload payload) {
        log.info("任务创建后回调参数: {}", payload);
        return WorkflowResult.success(null);
    }

    /**
     * 任务完成回调(只有正常推下一个节点,才算任务完成,其他从当前任务撤回/驳回都能不算当前任务完成,不会触发下面回调)
     */
    @Override
    @PostMapping(WorkflowConstant.TASK_COMPLETED_PATH)
    public WorkflowResult<Void> taskCompleted(@RequestBody TaskCompletedPayload payload) {
        log.info("任务完成后回调参数: {}", payload);
        return WorkflowResult.success(null);
    }

    /**
     * 流程状态变化回调
     */
    @Override
    @PostMapping(WorkflowConstant.PROCESS_STATUS_CHANGE_PATH)
    public WorkflowResult<Void> processStatusChange(@RequestBody ProcessStatusChangePayload payload) {


        log.info("流程状态变化回调参数:{}", payload);
        String businessKey = payload.getBusinessKey();
        if (StringUtils.isBlank(businessKey)) {
            throw new BusinessException("获取的businessKey为空");
        }
        ProcInstStatus procInstStatus = payload.getProcInstStatus();
        //根据业务key查询当前业务对象
        Long id = Long.valueOf(businessKey);
        PrdPerformanceExamResultVO prdPerformanceExamResultVO = prdPerformanceExamResultService.get(id);

        PrdPerformanceExamResultPayload prdPerformanceExamResultPayload = new PrdPerformanceExamResultPayload();
        prdPerformanceExamResultPayload.setId(id);
        if (prdPerformanceExamResultVO != null) {
            switch (procInstStatus) {
                case NOTSUBMIT://创建人提交节点
                    //一般情况将单据状态变成"激活",流程状态改为未提交
                    prdPerformanceExamResultPayload.setProcInstStatus(ProcInstStatus.NOTSUBMIT);
                    break;
                case INTERRUPT://中断（删除工作流，初始化单据，管理员操作）

                case INVALID://仅删除流程
                    prdPerformanceExamResultPayload.setNullFields(Arrays.asList("procInstStatus", "procInstId", "submitTime"));
                    //删除当前版本草稿状态的changeLog
//                    changeService.deleteCurrentVersionLog(ChangeTypeEnum.PERSONAL_INFO.getCode(), employeeId.toString());
                    break;
                case REJECTED://审批人拒绝，回到第一个节点
                    //将单据状态变为新建状态
                    prdPerformanceExamResultPayload.setProcInstStatus(ProcInstStatus.REJECTED);
                    break;
                case APPROVED:
                    // 更新绩效结果状态已完成
                    prdPerformanceExamResultPayload.setState(ProcInstStatus.APPROVED.name());
                    prdPerformanceExamResultPayload.setProcInstStatus(ProcInstStatus.APPROVED);
                    prdPerformanceExamResultPayload.setApprovedTime(LocalDateTime.now());

                    // 结果最终得分计算 最终得分/等级：94.39*60%+76*15%+85*8%+85*5%+85*5%+85*7%=89.28（B）

                    // 根据评分明细算总评分
                    PrdPerformanceExamResDtlQuery dtlQuery = new PrdPerformanceExamResDtlQuery();
                    dtlQuery.setResultId(id);
                    List<PrdPerformanceExamResDtlVO> list = prdPerformanceExamResDtlService.getList(dtlQuery);
                    BigDecimal sumScore = BigDecimal.ZERO;
                    for (PrdPerformanceExamResDtlVO dtlVO : list) {
                        if (null == dtlVO.getScoreRes()) {
                            dtlVO.setScoreRes(BigDecimal.ZERO);
                        }
                        if (null == dtlVO.getWeightRatio()) {
                            dtlVO.setScoreRes(BigDecimal.ZERO);
                        }
                        BigDecimal cScore = dtlVO.getWeightRatio().multiply(dtlVO.getScoreRes());
                        sumScore = sumScore.add(cScore);
                    }
                    // 主表评分结果
                    prdPerformanceExamResultPayload.setScoreRes(sumScore);
                    // 主表等级结果
                    PrdPerformanceExamGradeQuery gradeQuery = new PrdPerformanceExamGradeQuery();
                    gradeQuery.setExamId(prdPerformanceExamResultVO.getExamId());
                    List<PrdPerformanceExamGradeVO> gradeVOList = prdPerformanceExamGradeService.getList(gradeQuery);
                    for (PrdPerformanceExamGradeVO gradeVO : gradeVOList) {
                        if ((sumScore.compareTo(gradeVO.getScoreRatioStart()) == 1 || sumScore.compareTo(gradeVO.getScoreRatioStart()) == 0)
                                && (sumScore.compareTo(gradeVO.getScoreRatioEnd()) == -1 || sumScore.compareTo(gradeVO.getScoreRatioEnd()) == 0)) {
                            prdPerformanceExamResultPayload.setGradeRes(gradeVO.getName());
                        }
                    }
                    break;
                case APPROVING:
                    prdPerformanceExamResultPayload.setProcInstStatus(ProcInstStatus.APPROVING);
            }
            prdPerformanceExamResultService.updateByCondition(prdPerformanceExamResultPayload);
        }
        return WorkflowResult.success(null);
    }


}
