package com.elitesland.tw.tw5.server.prd.humanresources.examination.dao;

import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdPerformanceExamPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdPerformanceExamQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdPerformanceExamVO;
import com.elitesland.tw.tw5.server.prd.humanresources.examination.entity.PrdPerformanceExamDO;
import com.elitesland.tw.tw5.server.prd.humanresources.examination.entity.QPrdPerformanceExamDO;
import com.querydsl.jpa.impl.JPAUpdateClause;
import org.springframework.stereotype.Component;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.querydsl.core.types.Predicate;
import org.apache.commons.lang3.StringUtils;
import com.elitescloud.cloudt.common.base.PagingVO;
import java.util.List;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import java.util.List;
import com.querydsl.core.types.ExpressionUtils;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;


 /**
 * @author : WWW
 * @date : 2023-11-14
 * @desc : 绩效考核RepoProc
 */
 
@Component
public class PrdPerformanceExamDao extends BaseRepoProc<PrdPerformanceExamDO>{
    
    private static final QPrdPerformanceExamDO qPrdPerformanceExamDO = QPrdPerformanceExamDO.prdPerformanceExamDO;
    
    
    protected PrdPerformanceExamDao() {
    
        super(qPrdPerformanceExamDO);
        
    }
    
    
    public PagingVO<PrdPerformanceExamVO> page(PrdPerformanceExamQuery prdPerformanceExamQuery) {
        
        JPAQuery<PrdPerformanceExamVO> query = 
            select(PrdPerformanceExamVO.class)
                .where(bulidPredicate(prdPerformanceExamQuery));
        prdPerformanceExamQuery.setPaging(query);
        prdPerformanceExamQuery.fillOrders(query, qPrdPerformanceExamDO);
        return PagingVO.<PrdPerformanceExamVO>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();
                
    }
    
    
    public Long del(List<Long> ids) {
        
        Long res = jpaQueryFactory.update(qPrdPerformanceExamDO)
                .set(qPrdPerformanceExamDO.deleteFlag, 1)
                .where(qPrdPerformanceExamDO.id.in(ids))
                .execute();
        
        return res;
        
    }
    
    
    public PrdPerformanceExamVO get(Long id) {
    
        PrdPerformanceExamVO prdPerformanceExamVO = select(PrdPerformanceExamVO.class)
                .where(qPrdPerformanceExamDO.id.eq(id))
                .fetchOne();
        
        return prdPerformanceExamVO;
        
    }
    
    
    public List<PrdPerformanceExamVO> getList(PrdPerformanceExamQuery prdPerformanceExamQuery) {
        
        List<PrdPerformanceExamVO> res = 
            select(PrdPerformanceExamVO.class)
                .where(bulidPredicate(prdPerformanceExamQuery))
                .fetch();
        
        return res;
        
    }
    
    
    private <T> JPAQuery<T> select(Class<T> cls) {
    
        return 
                jpaQueryFactory.select(Projections.bean(cls,
                    qPrdPerformanceExamDO.name,
                    qPrdPerformanceExamDO.cycle,
                    qPrdPerformanceExamDO.startPeriod,
                    qPrdPerformanceExamDO.endPeriod,
                    qPrdPerformanceExamDO.state,
                    qPrdPerformanceExamDO.examDesc,
                    qPrdPerformanceExamDO.scoreMin,
                    qPrdPerformanceExamDO.scoreMax,
                    qPrdPerformanceExamDO.resAuditorType,
                    qPrdPerformanceExamDO.resAuditor,
                    qPrdPerformanceExamDO.tempId,
                    qPrdPerformanceExamDO.id,
                    qPrdPerformanceExamDO.createTime,
                    qPrdPerformanceExamDO.remark
                
                )).from(qPrdPerformanceExamDO);
            
    }
    
    
    private Predicate bulidPredicate(PrdPerformanceExamQuery prdPerformanceExamQuery) {
    
        Predicate predicate = PredicateBuilder.builder()
            .andLike(StringUtils.isNotBlank(prdPerformanceExamQuery.getName()), qPrdPerformanceExamDO.name, prdPerformanceExamQuery.getName())
            .andEq(StringUtils.isNotBlank(prdPerformanceExamQuery.getCycle()), qPrdPerformanceExamDO.cycle, prdPerformanceExamQuery.getCycle())
            .andEq(null != prdPerformanceExamQuery.getStartPeriod(), qPrdPerformanceExamDO.startPeriod, prdPerformanceExamQuery.getStartPeriod())
            .andEq(null != prdPerformanceExamQuery.getEndPeriod(), qPrdPerformanceExamDO.endPeriod, prdPerformanceExamQuery.getEndPeriod())
            .andEq(StringUtils.isNotBlank(prdPerformanceExamQuery.getState()), qPrdPerformanceExamDO.state, prdPerformanceExamQuery.getState())
            .andEq(StringUtils.isNotBlank(prdPerformanceExamQuery.getExamDesc()), qPrdPerformanceExamDO.examDesc, prdPerformanceExamQuery.getExamDesc())
            .andEq(null != prdPerformanceExamQuery.getScoreMin(), qPrdPerformanceExamDO.scoreMin, prdPerformanceExamQuery.getScoreMin())
            .andEq(null != prdPerformanceExamQuery.getScoreMax(), qPrdPerformanceExamDO.scoreMax, prdPerformanceExamQuery.getScoreMax())
            .andEq(StringUtils.isNotBlank(prdPerformanceExamQuery.getResAuditorType()), qPrdPerformanceExamDO.resAuditorType, prdPerformanceExamQuery.getResAuditorType())
            .andEq(StringUtils.isNotBlank(prdPerformanceExamQuery.getResAuditor()), qPrdPerformanceExamDO.resAuditor, prdPerformanceExamQuery.getResAuditor())
            .andEq(null != prdPerformanceExamQuery.getTempId(), qPrdPerformanceExamDO.tempId, prdPerformanceExamQuery.getTempId())
            .build();
            
        return predicate;
        
    }
    
    
    private List<Predicate> bulidPredicates(PrdPerformanceExamQuery prdPerformanceExamQuery) {
        
        List<Predicate> predicates = new ArrayList<>();
        // 考核名称
        if (StringUtils.isNotEmpty(prdPerformanceExamQuery.getName())) {
            predicates.add(qPrdPerformanceExamDO.name.eq(prdPerformanceExamQuery.getName()));
        }
        // 考核周期
        if (StringUtils.isNotEmpty(prdPerformanceExamQuery.getCycle())) {
            predicates.add(qPrdPerformanceExamDO.cycle.eq(prdPerformanceExamQuery.getCycle()));
        }
        // 开始期间
        if (null != prdPerformanceExamQuery.getStartPeriod()) {
            predicates.add(qPrdPerformanceExamDO.startPeriod.eq(prdPerformanceExamQuery.getStartPeriod()));
        }
        // 结束期间
        if (null != prdPerformanceExamQuery.getEndPeriod()) {
            predicates.add(qPrdPerformanceExamDO.endPeriod.eq(prdPerformanceExamQuery.getEndPeriod()));
        }
        // 状态
        if (StringUtils.isNotEmpty(prdPerformanceExamQuery.getState())) {
            predicates.add(qPrdPerformanceExamDO.state.eq(prdPerformanceExamQuery.getState()));
        }
        // 考核说明
        if (StringUtils.isNotEmpty(prdPerformanceExamQuery.getExamDesc())) {
            predicates.add(qPrdPerformanceExamDO.examDesc.eq(prdPerformanceExamQuery.getExamDesc()));
        }
        // 分数下限
        if (null != prdPerformanceExamQuery.getScoreMin()) {
            predicates.add(qPrdPerformanceExamDO.scoreMin.eq(prdPerformanceExamQuery.getScoreMin()));
        }
        // 分数上限
        if (null != prdPerformanceExamQuery.getScoreMax()) {
            predicates.add(qPrdPerformanceExamDO.scoreMax.eq(prdPerformanceExamQuery.getScoreMax()));
        }
        // 考试结果审批人类型
        if (StringUtils.isNotEmpty(prdPerformanceExamQuery.getResAuditorType())) {
            predicates.add(qPrdPerformanceExamDO.resAuditorType.eq(prdPerformanceExamQuery.getResAuditorType()));
        }
        // 考试结果审批人
        if (StringUtils.isNotEmpty(prdPerformanceExamQuery.getResAuditor())) {
            predicates.add(qPrdPerformanceExamDO.resAuditor.eq(prdPerformanceExamQuery.getResAuditor()));
        }
        // 模板id
        if (null != prdPerformanceExamQuery.getTempId()) {
            predicates.add(qPrdPerformanceExamDO.tempId.eq(prdPerformanceExamQuery.getTempId()));
        }
        
//      Predicate predicate = ExpressionUtils.allOf(predicates);
        
        return predicates;
    }
    
    
    public Long count(PrdPerformanceExamQuery prdPerformanceExamQuery) {
    
        long res = select(PrdPerformanceExamVO.class)
                .where(bulidPredicate(prdPerformanceExamQuery))
                .fetchCount();
        
        return res;
        
        
    }


    @Transactional
    public Long update(PrdPerformanceExamPayload prdPerformanceExamPayload) {
        JPAUpdateClause update = jpaQueryFactory.update(qPrdPerformanceExamDO);
        
        // 考核名称
        if (StringUtils.isNotEmpty(prdPerformanceExamPayload.getName())) {
            update.set(qPrdPerformanceExamDO.name,prdPerformanceExamPayload.getName());
        }
        // 考核周期
        if (StringUtils.isNotEmpty(prdPerformanceExamPayload.getCycle())) {
            update.set(qPrdPerformanceExamDO.cycle,prdPerformanceExamPayload.getCycle());
        }
        // 开始期间
        if (null != prdPerformanceExamPayload.getStartPeriod()) {
            update.set(qPrdPerformanceExamDO.startPeriod,prdPerformanceExamPayload.getStartPeriod());
        }
        // 结束期间
        if (null != prdPerformanceExamPayload.getEndPeriod()) {
            update.set(qPrdPerformanceExamDO.endPeriod,prdPerformanceExamPayload.getEndPeriod());
        }
        // 状态
        if (StringUtils.isNotEmpty(prdPerformanceExamPayload.getState())) {
            update.set(qPrdPerformanceExamDO.state,prdPerformanceExamPayload.getState());
        }
        // 考核说明
        if (StringUtils.isNotEmpty(prdPerformanceExamPayload.getExamDesc())) {
            update.set(qPrdPerformanceExamDO.examDesc,prdPerformanceExamPayload.getExamDesc());
        }
        // 分数下限
        if (null != prdPerformanceExamPayload.getScoreMin()) {
            update.set(qPrdPerformanceExamDO.scoreMin,prdPerformanceExamPayload.getScoreMin());
        }
        // 分数上限
        if (null != prdPerformanceExamPayload.getScoreMax()) {
            update.set(qPrdPerformanceExamDO.scoreMax,prdPerformanceExamPayload.getScoreMax());
        }
        // 考试结果审批人类型
        if (StringUtils.isNotEmpty(prdPerformanceExamPayload.getResAuditorType())) {
            update.set(qPrdPerformanceExamDO.resAuditorType,prdPerformanceExamPayload.getResAuditorType());
        }
        // 考试结果审批人
        if (StringUtils.isNotEmpty(prdPerformanceExamPayload.getResAuditor())) {
            update.set(qPrdPerformanceExamDO.resAuditor,prdPerformanceExamPayload.getResAuditor());
        }
        // 模板id
        if (null != prdPerformanceExamPayload.getTempId()) {
            update.set(qPrdPerformanceExamDO.tempId,prdPerformanceExamPayload.getTempId());
        }
        long res = update.where(qPrdPerformanceExamDO.id.eq(prdPerformanceExamPayload.getId()))
                .execute();
        return res;
    
    }
    
}

