package com.elitesland.tw.tw5.server.prd.humanresources.examination.entity;

import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import lombok.Data;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.LocalDate;
import org.hibernate.annotations.Where;
import com.elitescloud.boot.model.entity.BaseModel;


 /**
 * @author : WWW
 * @date : 2023-11-14
 * @desc : 考核结果等级
 */
 
@Entity
@Table(name="prd_performance_exam_grade")
@org.hibernate.annotations.Table(appliesTo = "prd_performance_exam_grade", comment = "考核结果等级")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0")
public class PrdPerformanceExamGradeDO extends BaseModel {


    /**
     * 绩效id
     */
    @Column(name = "exam_id", columnDefinition = "bigint(20) comment '绩效id'")
    private Long examId;
    
    /**
     * 等级名称
     */
    @Column(name = "name", columnDefinition = "varchar(255) comment '等级名称'")
    private String name;
    
    /**
     * 得分占比开始
     */
    @Column(name = "score_ratio_start", columnDefinition = "decimal(20,2) comment '得分占比开始'")
    private BigDecimal scoreRatioStart;
    
    /**
     * 得分占比结束
     */
    @Column(name = "score_ratio_end", columnDefinition = "decimal(20,2) comment '得分占比结束'")
    private BigDecimal scoreRatioEnd;
    

}

