package com.elitesland.tw.tw5.server.prd.humanresources.personnel.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitesland.workflow.enums.ProcInstStatus;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

@Entity
@Table(name = "offer_entry_apply", indexes = {
        @Index(name = "person_index", columnList = "person_id"),
})
@org.hibernate.annotations.Table(appliesTo = "offer_entry_apply", comment = "offer入职申请表")
@Data
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class OfferEntryApplyDO extends BaseModel {

    @Comment("用户账号")
    private String userName;

    @Comment("用户姓氏")
    private String lastName;

    @Comment("用户真实姓名")
    private String personName;

    @Comment("用户电话")
    @Column(length = 20)
    private String mobile;

    @Comment("用户邮箱")
    @Column(length = 30)
    private String email;

    @Comment("账户状态")
    private Boolean enabled;

    @Comment("自然人ID")
    @Column(name = "person_id", nullable = false)
    private Long personId;

    @Comment("系统用户ID")
    private Long userId;

    @Comment("公司ID")
    private Long companyId;

    @Comment("员工编号")
    private String employeeNo;

    @Comment("员工名称")
    @Column(length = 20)
    private String employeeName;

    @Comment("资源状态")
    @Column(length = 20)
    private String resourceStatus;

    @Comment("人事状态 0：有效，1：无效")
    @Column(length = 3)
    private String hrStatus;

    @Comment("入职日期")
    private LocalDate enrollDate;

    @Comment("安全级别")
    private Integer accessLevel;

    @Comment("岗位")
    private String jobs;

    @Comment("排序")
    private Integer sortIndex;

    @Comment("外文名")
    private String foreignName;

    @Comment("证件类型")
    private String idType;

    @Comment("证件号码")
    private String idNo;

    @Comment("证件开始日")
    private LocalDate idValidFrom;

    @Comment("证件到期日")
    private LocalDate idValidTo;

    @Comment("证件url")
    private String idValidCodes;

    @Comment("头像url")
    private String headCodes;

    @Comment("生日")
    private LocalDate birthday;

    @Comment("性别")
    @Column(length = 5)
    private String sex;

    @Comment("国籍")
    @Column(length = 20)
    private String nationality;

    @Comment("籍贯")
    private String birthplace;

    @Comment("民族")
    private String nation;

    @Comment("婚姻状况")
    private Integer marital;

    @Comment("通讯地址")
    private String addr;

    @Comment("紧急联系人")
    private String urgency_name;

    @Comment("紧急联系人手机号")
    private String urgency_mobile;

    @Comment("紧急联系人关系")
    private String urgency_ref;

    @Comment("上级编号")
    @Column(length = 20)
    private String parentNo;

    @Comment("专业级别")
    private String extString1;

    @Comment("管理级别")
    @Column(length = 20)
    private String extString2;

    @Comment("专业序列")
    @Column(length = 20)
    private String extString3;

    @Comment("职位序列")
    @Column(length = 20)
    private String extString4;

    @Comment("主服务地址")
    private String extString5;

    @Comment("内部类型：内部资源，外部资源")
    @Column(length = 20)
    private String extString6;

    @Comment("话费额度")
    @Column(length = 20)
    private String extString7;

    @Comment("电脑额度")
    @Column(length = 20)
    private String extString8;

    @Comment("资源类型2 正式员工，实行生等")
    @Column(length = 20)
    private String extString9;

    @Comment("出差补助")
    @Column(length = 20)
    private String extString11;
    @Comment("项目现场补助")
    @Column(length = 20)
    private String extString12;

    @Comment("转正日期")
    private LocalDate extDate2;

    @Comment("合同签订日期")
    private LocalDate extDate3;

    @Comment("合同到期日")
    private LocalDate extDate4;

    @Comment("实习入职日期")
    private LocalDate extDate5;

    @Comment("试用期开始")
    private LocalDate extDate6;

    @Comment("试用期结束")
    private LocalDate extDate7;

    @Comment("组织ID")
    private Long orgId;

    @Comment("上级员工ID")
    private Long parentId;

    @Comment("修改类型")
    private String subType;

    @Comment("从业年限")
    private String professionalYears;

    @Comment("流程实例ID")
    @Column(length = 30)
    private String procInstId;

    @Comment("流程名称")
    private String procInstName;

    @Comment("流程审批状态")
    @Column
    @Enumerated(EnumType.STRING)
    private ProcInstStatus procInstStatus;

    @Comment("提交时间")
    private LocalDateTime submitTime;

    @Comment("审批时间")
    private LocalDateTime approvedTime;

    @Comment("合作方式")
    private String cooperationMode;

    @Comment("资源经理")
    private Long resManagerId;

    @Comment("参加商务培训")
    private String busiTrainFlag;

    @Comment("offer是否发放")
    private String deliverOffer;

    @Comment("offer未发放原因")
    private String noneOfferReason;

    @Comment("加班人员")
    private String inLieuFlag;

    @Comment("是否总裁审批")
    private String ceoApprFlag;

    @Comment("是否内推")
    private Boolean isJobInternalRecomm;

    @Comment("推荐人")
    private Long jobInternalRecommId;

    @Comment("工种分类一")
    private String jobClass1;

    @Comment("工种分类二")
    private String jobClass2;

    @Comment("长期/短期")
    private String periodFlag;

    @Comment("复合能力")
    private String capasetLevelId;

    @Comment("发薪方式")
    private String salaryMethod;

    @Comment("发薪周期")
    private String salaryPeriod;

    @Comment("自我评价")
    private String selfEvaluation;

    @Comment("个人简历url")
    private String resumeCodes;

    @Comment("自我介绍视频url")
    private String selfIntroVideoCodes;

    @Comment("标签")
    private String selfTagging;

    @Comment("专业技能&专业领域")
    private String professionalSkills;

    @Comment("结算方式")
    private String settleMethod;

    @Comment("服务方式")
    private String serviceType;

    @Comment("服务时间开始")
    private LocalDate serviceClockFrom;

    @Comment("服务时间结束")
    private LocalDate serviceClockTo;

    @Comment("当量系数")
    private BigDecimal eqvaRatio;

    @Comment("入职类型")
    private String entryType;

    @Comment("公司id")
    private Long bookId;

    @Comment("实习开始日期")
    private LocalDate internshipStartDate;

    @Comment("平台邮箱")
    private String platformEmail;
}
