package com.elitesland.tw.tw5.server.prd.humanresources.personnel.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.time.LocalDate;

@Entity
@Table(name = "person_work_experience", indexes = {
        @Index(name = "person_index", columnList = "person_id"),
})
@org.hibernate.annotations.Table(appliesTo = "person_work_experience", comment = "人员-工作经历表")
@Data
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class PersonWorkExperienceDO extends BaseModel {

    @Comment("自然人ID")
    @Column(name = "person_id", nullable = false)
    private Long personId;

    @Comment("开始时间")
    @Column(name = "date_from")
    private LocalDate dateFrom;

    @Comment("结束时间")
    @Column(name = "date_to")
    private LocalDate dateTo;

    @Comment("公司名称")
    @Column(name = "company_name")
    private String companyName;

    @Comment("部门名称")
    @Column(name = "dept_name")
    private String deptName;

    @Comment("职位")
    @Column(name = "jobtitle")
    private String jobtitle;

    @Comment("职责描述")
    @Column(name = "duty_desc", length = 1000)
    private String dutyDesc;

    @Comment("行业")
    @Column(name = "industry")
    private String industry;

    @Comment("来源类型")
    @Column(name = "source_type")
    private String sourceType;
}
