package com.elitesland.tw.tw5.server.prd.humanresources.resource.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.ExternalResApplyPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.ExternalResApplyQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.service.ExternalResApplyService;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.ExternalResApplyVO;
import com.elitesland.tw.tw5.api.prd.org.payload.PrdOrgPersonPayload;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgOrganizationVO;
import com.elitesland.tw.tw5.api.prd.system.payload.PrdMessageConfigPayload;
import com.elitesland.tw.tw5.api.prd.system.service.PrdMessageConfigService;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemRoleService;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemSelectionService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemSelectionVO;
import com.elitesland.tw.tw5.server.common.workFlow.ProcDefKey;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.WorkflowUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.WorkFlowStatusEnum;
import com.elitesland.tw.tw5.server.prd.humanresources.resource.convert.ExternalResApplyConvert;
import com.elitesland.tw.tw5.server.prd.humanresources.resource.dao.ExternalResApplyDAO;
import com.elitesland.tw.tw5.server.prd.humanresources.resource.entity.ExternalResApplyDO;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgEmployeeDAO;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgPersonDAO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgEmployeeDO;
import com.elitesland.tw.tw5.server.prd.system.constant.MessageNoticeTypeEnum;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.StartProcessPayload;
import io.jsonwebtoken.lang.Collections;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Service
@RequiredArgsConstructor
@Slf4j
public class ExternalResApplyServiceImpl extends BaseServiceImpl implements ExternalResApplyService {

    private final ExternalResApplyDAO externalResApplyDAO;

    private final WorkflowUtil workflowUtil;

    private final PrdSystemRoleService prdSystemRoleService;

    private final PrdOrgPersonDAO personDAO;

    private final CacheUtil cacheUtil;

    private final PrdOrgEmployeeDAO employeeDAO;

    private final PrdSystemSelectionService prdSystemSelectionService;

    private final PrdMessageConfigService messageConfigService;

    private final PrdSystemRoleService roleService;

    @Override
    @Transactional
    public void apply(ExternalResApplyPayload payload) {

        if (ObjectUtils.isEmpty(payload.getResType2())) {
            throw new BusinessException("请选择外部资源类型");
        }

        if (payload.getId() == null) {
            ProcessInfo processInfo = new ProcessInfo();
            String status = WorkFlowStatusEnum.APPROVED_WORK.getCode();

            HashMap<String, Object> variables = new HashMap<>();
            //是否开通邮箱
            variables.put("emailFlag", payload.getEmailFlag());
            //是否开通E-learning账号
            variables.put("elpFlag", payload.getElpFlag());
            //直属领导审批
            variables.put("Activity_0wlielw", payload.getParentId());
            //资源总监审批
            List<Long> resDirectors = prdSystemRoleService.queryUserIdByRoleCode(RoleEnum.PLAT_RESOURCE_DIRECTOR.getCode());
            variables.put("Activity_1nivyah", resDirectors);
            //BaseBu负责人审批
            Long orgId = payload.getOrgId();
            PrdOrgOrganizationVO orgOrganizationVO = cacheUtil.getOrg(orgId);
            Long manageId = orgOrganizationVO.getManageId();
            variables.put("Activity_0qbiiu8", manageId);
            //平台账号管理员审批
            List<Long> itAdministratorId = prdSystemRoleService.queryUserIdByRoleCode(RoleEnum.PLATFORM_IT_ADMINISTRATOR.getCode());
            variables.put("Activity_1nppj6a", itAdministratorId);

            //保存申请信息
            Long personId = payload.getPersonId();
            PrdOrgEmployeeDO prdOrgEmployeeDO = personDAO.findEmployeeByPersonId(personId);
            Long employeeId = prdOrgEmployeeDO.getId();
            payload.setEmployeeId(employeeId);
            ExternalResApplyDO applyDO = externalResApplyDAO.save(ExternalResApplyConvert.INSTANCE.payloadToDo(payload));

            Long applyId = applyDO.getId();
            //发起流程审批
            processInfo = workflowUtil.startProcess(StartProcessPayload.of(
                    ProcDefKey.EXTERNAL_RES_APPLY.name(),
                    "A46.外部资源引入流程-" + payload.getPersonName(),
                    applyId + "",
                    variables)
            );

            //修改资源状态
            employeeDAO.updateResStatus(employeeId, "2");
            personDAO.updateApprStatus(personId, "APPROVING");
            PrdOrgPersonPayload prdOrgPersonPayload = new PrdOrgPersonPayload();
            prdOrgPersonPayload.setId(personId);
            prdOrgPersonPayload.setProcInstStatus(processInfo.getProcInstStatus());
            prdOrgPersonPayload.setProcInstStatus(ProcInstStatus.APPROVING);
            personDAO.updateProcessDate(prdOrgPersonPayload);
//            PrdOrgEmployeePayload prdOrgEmployeePayload = new PrdOrgEmployeePayload();
//            prdOrgEmployeePayload.setId(employeeId);
//            prdOrgEmployeePayload.setProcInstId(processInfo.getProcInstId());
//            prdOrgEmployeePayload.setProcInstStatus(processInfo.getProcInstStatus());
//            employeeDAO.updateProcessDate(prdOrgEmployeePayload);

            //流程启动成功后，回写业务表数据
            payload.setId(applyDO.getId());
            payload.setProcInstId(processInfo.getProcInstId());
            payload.setProcInstStatus(processInfo.getProcInstStatus());
            payload.setProcInstStatus(ProcInstStatus.APPROVING);
            externalResApplyDAO.updateProcData(payload);

            // 发通知给人事 平台人力资源总监 平台薪酬绩效主管
            String userName = applyDO.getPersonName();
            String title = "外部资源引入-" + userName;
            String content = "外部资源引入-" + userName + "，请相关负责人及时查看";
            sendMessage(applyId, title, content);
        } else {
            ExternalResApplyDO externalResApplyDO = externalResApplyDAO.findById(payload.getId());
            ExternalResApplyDO saveDO = ExternalResApplyConvert.INSTANCE.payloadToDo(payload);
            saveDO.setEmployeeId(externalResApplyDO.getEmployeeId());
            saveDO.setEmployeeNo(externalResApplyDO.getEmployeeNo());
            externalResApplyDAO.save(saveDO);
        }

    }

    @Override
    public ExternalResApplyVO queryByProcId(String procId) {
        ExternalResApplyDO applyDO = externalResApplyDAO.findByProcId(procId);
        if (applyDO != null) {
            ExternalResApplyVO externalResApplyVO = ExternalResApplyConvert.INSTANCE.doToVo(applyDO);
            externalResApplyVO.setCreateUserName(cacheUtil.getUserName(externalResApplyVO.getCreateUserId()));
            return externalResApplyVO;
        }
        return null;
    }

    @Override
    public PagingVO<ExternalResApplyVO> ExternalResApplyPage(ExternalResApplyQuery query) {
        PrdSystemSelectionVO view = cacheUtil.getSystemSelection("org:employee:jobType");
        Map<String, String> result = new HashMap<>();
        List<PrdSystemSelectionVO> selectionVOS = view.getChildren();
        for (PrdSystemSelectionVO selectionVO : selectionVOS) {
            List<PrdSystemSelectionVO> children = selectionVO.getChildren();
            if (!Collections.isEmpty(children)) {
                for (PrdSystemSelectionVO child : children) {
                    result.put(child.getSelectionValue(), child.getSelectionName());
                }
            }
        }

        PagingVO<ExternalResApplyVO> page = externalResApplyDAO.queryPaging(query);
        if (page != null) {
            List<ExternalResApplyVO> records = page.getRecords();
            if (records != null) {
                for (ExternalResApplyVO externalResApplyVO : records) {
                    externalResApplyVO.setJobClass2Desc(result.get(externalResApplyVO.getJobClass2()));
                }
            }
        }
        return page;
    }

    // 发通知给人事 平台人力资源总监  平台薪酬绩效主管
    public void sendMessage(Long objectId, String messageTitle, String content) {
        PrdMessageConfigPayload ado = new PrdMessageConfigPayload();
        ado.setObjectId(objectId);
        ado.setMessageTitle(messageTitle);
        ado.setMessageType(2);
        ado.setContentBigType("businessMessage");
        ado.setContentType(MessageNoticeTypeEnum.personnelMessage.getCode());
        ado.setMessageTag("important");
        ado.setIsEnable(0);
        ado.setNoticeScope("appoint_people");
        ado.setNoticeWay("instation");
        ado.setReleaseSource("profileMessage");
        ado.setReleaseStatus(3);
        ado.setMessageContent(content);
        List<Long> list = new ArrayList();
        list.addAll(roleService.queryUserIdByRoleCode(RoleEnum.PLAT_HRD.getCode()));
        list.addAll(roleService.queryUserIdByRoleCode(RoleEnum.PLAT_SALARY_MANAGER.getCode()));

        if (!CollectionUtils.isEmpty(list)) {
            String noticeSource = list.stream().map(p -> p.toString()).collect(Collectors.joining(","));
            ado.setNoticeSource(noticeSource);
            //保存信息
            messageConfigService.insert(ado);
        }

    }
}
