package com.elitesland.tw.tw5.server.prd.my.controller;


import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.my.payload.TPermissionApplyPayload;
import com.elitesland.tw.tw5.api.prd.my.query.TPermissionApplyQuery;
import com.elitesland.tw.tw5.api.prd.my.service.TPermissionApplyService;
import com.elitesland.tw.tw5.api.prd.my.vo.TPermissionApplyVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import io.seata.spring.annotation.GlobalTransactional;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 权限申请
 *
 * @author lemon
 * @date 2023-09-11
 */
@Api(tags = "权限申请")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm/tPermissionApply")
@Slf4j
public class TPermissionApplyController {

private final TPermissionApplyService tPermissionApplyService;

    /**
     * 权限申请-新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("权限申请-新增")
    @GlobalTransactional
    public TwOutputUtil<TPermissionApplyVO> insert(@RequestBody TPermissionApplyPayload payload){
         return TwOutputUtil.ok(tPermissionApplyService.insert(payload));
    }

    /**
     * 权限申请-更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("权限申请-更新")
    public TwOutputUtil<TPermissionApplyVO> update(@RequestBody TPermissionApplyPayload payload){
        return TwOutputUtil.ok(tPermissionApplyService.update(payload));
    }

    /**
     * 权限申请-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping("update")
    @ApiOperation("权限申请-更新,支持置空 置空的字段需需要借助 protected List<String> nullFields;")
    public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody TPermissionApplyPayload payload){
        return TwOutputUtil.ok(tPermissionApplyService.updateByKeyDynamic(payload));
    }

    /**
     * 权限申请-主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    @UdcNameClass
    @ApiOperation("权限申请-主键查询")
    public TwOutputUtil<TPermissionApplyVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(tPermissionApplyService.queryByKey(key));
    }

    /**
     * 权限申请-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    // @UdcNameClass
    @ApiOperation("权限申请-分页")
    public TwOutputUtil<PagingVO<TPermissionApplyVO>> paging(TPermissionApplyQuery query) {
        return TwOutputUtil.ok(tPermissionApplyService.queryPaging(query));
    }

    /**
     * 权限申请-查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    // @UdcNameClass
    @ApiOperation("权限申请-查询列表")
    public TwOutputUtil<List<TPermissionApplyVO>> queryList(TPermissionApplyQuery query) {
        return TwOutputUtil.ok(tPermissionApplyService.queryListDynamic(query));
    }

    /**
     * 权限申请-删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("权限申请-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
         tPermissionApplyService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}

