package com.elitesland.tw.tw5.server.prd.my.controller;

import com.elitesland.tw.tw5.api.prd.my.payload.TimesheetBiweeklyDetailPayload;
import com.elitesland.tw.tw5.api.prd.my.query.TimesheetBiweeklyDetailQuery;
import com.elitesland.tw.tw5.api.prd.my.service.TimesheetBiweeklyDetailService;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;

/**
* 双周计划明细
*
* @author duwh
* @date 2022-12-21
*/
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/my/timesheetBiweeklyDetail")
@Slf4j
public class TimesheetBiweeklyDetailController {

    private final TimesheetBiweeklyDetailService timesheetBiweeklyDetailService;

    /**
    * 新增
    *
    * @param payload 有效载荷
    * @return {@link TwOutputUtil}
    */
    @PostMapping
    public TwOutputUtil insert(@RequestBody TimesheetBiweeklyDetailPayload payload){
        return TwOutputUtil.ok(timesheetBiweeklyDetailService.insert(payload));
    }

    /**
    * 更新
    *
    * @param payload 有效载荷
    * @return {@link TwOutputUtil}
    */
    @PutMapping
    public TwOutputUtil update(@RequestBody TimesheetBiweeklyDetailPayload payload){
        return TwOutputUtil.ok(timesheetBiweeklyDetailService.update(payload));
    }

    /**
    * 主键查询
    *
    * @param key 关键
    * @return {@link TwOutputUtil}
    */
    @GetMapping("/{key}")
    // @UdcNameClass
    public TwOutputUtil queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(timesheetBiweeklyDetailService.queryByKey(key));
    }

    /**
    * 分页
    *
    * @param query 查询
    * @return {@link TwOutputUtil}
    */
    @GetMapping("/paging")
    // @UdcNameClass
    public TwOutputUtil paging(TimesheetBiweeklyDetailQuery query) {
        return TwOutputUtil.ok(timesheetBiweeklyDetailService.paging(query));
    }

    /**
    * 查询列表
    *
    * @param query 查询
    * @return {@link TwOutputUtil}
    */
    @GetMapping("/list")
    // @UdcNameClass
    public TwOutputUtil queryList(TimesheetBiweeklyDetailQuery query) {
        return TwOutputUtil.ok(timesheetBiweeklyDetailService.queryList(query));
    }

    /**
    * 删除
    *
    * @param keys 主键id
    * @return result
    */
    @DeleteMapping("/deleteSoft")
    public TwOutputUtil deleteSoft(Long[] keys) {
        timesheetBiweeklyDetailService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}
