package com.elitesland.tw.tw5.server.prd.my.entity;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.io.Serializable;
import java.time.LocalDate;

@Entity
@Table(name = "prd_user_remind", indexes = {@Index(name = "user_index", columnList = "user_id")})
@org.hibernate.annotations.Table(appliesTo = "prd_user_remind", comment = "用户提醒表")
@Data
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class PrdUserRemindDO extends BaseModel implements Serializable {
    private static final long serialVersionUID = 1L;

    @Comment("用户ID")
    @Column(name = "user_id", nullable = false)
    private Long userId;

    @Comment("提醒类型")
    @Column(nullable = false)
    private String remindType;

    @Comment("不再提醒日期")
    @Column()
    private LocalDate noRemindDate;

}
