package com.elitesland.tw.tw5.server.prd.my.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.io.Serializable;
import java.time.LocalDate;

/**
 * 假期取消申请
 *
 * @author carl
 * @date 2024-06-18
 */
@Entity
@Table(name = "t_user_vacation_cancel", indexes = {
        @Index(name = "user_id_index", columnList = "user_id"),
        @Index(name = "apply_id_index", columnList = "apply_id")
})
@org.hibernate.annotations.Table(appliesTo = "t_user_vacation_cancel", comment = "假期取消申请")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class TUserVacationCancelDO extends BaseModel implements Serializable {
    /**
     * 用户id
     */
    @Comment("用户id")
    @Column(name = "user_id")
    private Long userId;
    /**
     * 直属领导id
     */
    @Comment("直属领导id")
    @Column()
    private Long pUserId;
    /**
     * 部门id
     */
    @Comment("部门id")
    @Column()
    private Long orgId;
    /**
     * 请假id
     */
    @Comment("请假id")
    @Column(name = "apply_id")
    private Long applyId;
    /**
     * 公司id
     */
    @Comment("公司id")
    @Column()
    private Long companyId;
    /**
     * 请假单号
     */
    @Comment("请假单号")
    @Column()
    private String applyNo;
    /**
     * 操作类型
     */
    @Comment("操作类型")
    @Column()
    private String operType;
    /**
     * 阶段活动名称
     */
    @Comment("阶段活动名称")
    @Column()
    private String cancelDesc;
    /**
     * 操作日期
     */
    @Comment("操作日期")
    @Column()
    private LocalDate cancelDate;
    /**
     * 审批状态
     */
    @Comment("审批状态")
    @Column()
    private String procInstStatus;
    /**
     * 流程id
     */
    @Comment("流程id")
    @Column()
    private String procInstId;

    public void copy(TUserVacationCancelDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
