package com.elitesland.tw.tw5.server.prd.my.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 工时补贴标准配置表
 *
 * @author duwh
 * @date 2024-07-13
 */
@Entity
@Table(name = "t_timesheet_subsidy_setting", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "t_timesheet_subsidy_setting", comment = "工时补贴标准配置表")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class TimesheetSubsidySettingDO extends BaseModel implements Serializable  {
    /** 事由类型 PROJ_CONTRACT合同项目 PROJ_OPPO售前商机项目  PROJ_BU部门BU项目 */
    @Comment("事由类型 PROJ_CONTRACT合同项目 PROJ_OPPO售前商机项目  PROJ_BU部门BU项目")
    @Column()
    private String reasonType;
    /** 可选 事由id */
    @Comment("可选 事由id")
    @Column()
    private Long reasonId;
    /** 可选 事由名称 */
    @Comment("可选 事由名称")
    @Column()
    private String reasonName;
    /** 是否工作日 WORK工作日 HOLIDAY节假日 */
    @Comment("是否工作日 WORK工作日 HOLIDAY节假日")
    @Column()
    private String workDateType;
    /** 周末现场是否考虑补助 Y考虑 N不考虑 */
    @Comment("周末现场是否考虑补助 Y考虑 N不考虑")
    @Column()
    private String holidaySubsidyType;
    /** 可选补助类型 */
    @Comment("可选补助类型 显示名称")
    @Column()
    private String subsidySelectTypeName;
    @Comment("可选补助类型 编码")
    @Column()
    private String subsidySelectTypeCode;
    /** 可选补助类型 是否默认值 Y赋值默认值 其他不管 */
    @Comment("可选补助类型 是否默认值 Y赋值默认值 其他不管")
    @Column()
    private String subsidySelectDefaultFlag;
    /** 可填写工时 数值格式 多个英文逗号隔开 */
    @Comment("可填写工时 数值格式 多个英文逗号隔开")
    @Column()
    private String workHourSelect;
    /** 拓展 可填写工时对应udc */
    @Comment("拓展 可填写工时对应udc")
    @Column()
    private String workHourSelectUdcKey;
    /** 工时计算调整 实际参与计算补助的值 */
    @Comment("工时计算调整 实际参与计算补助的值")
    @Column()
    private BigDecimal workHourCal;
    /** 补贴标准 NO没有补助 TRAVEL出差补贴 ON_SITE现场补贴 */
    @Comment("补贴标准 NO没有补助 TRAVEL出差补贴 ON_SITE现场补贴")
    @Column()
    private String subsidyStdType;
    /** 项目补助规则-周末可填写补助  工作日 无视  节假日根据项目中的规则判断 */
    @Comment("项目补助规则-周末可填写补助 工作日 无视  节假日根据项目中的规则判断  Y周末现场有补助")
    @Column()
    private String projectSubsidyRole;
    /** 拓展1 */
    @Comment("拓展1")
    @Column()
    private String ext1;
    /** 拓展2 */
    @Comment("拓展2")
    @Column()
    private String ext2;
    /** 拓展3 */
    @Comment("拓展3")
    @Column()
    private String ext3;
    /** 拓展4 */
    @Comment("拓展4")
    @Column()
    private String ext4;
    /** 拓展5 */
    @Comment("拓展5")
    @Column()
    private String ext5;

    public void copy(TimesheetSubsidySettingDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
