package com.elitesland.tw.tw5.server.prd.partner.common.service;


import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitesland.tw.tw5.api.prd.partner.common.payload.AddressBookPayload;
import com.elitesland.tw.tw5.api.prd.partner.common.query.AddressBookQuery;
import com.elitesland.tw.tw5.api.prd.partner.common.service.AddressBookService;
import com.elitesland.tw.tw5.api.prd.partner.common.vo.AddressBookVO;
import com.elitesland.tw.tw5.server.prd.partner.common.convert.AddressBookConvert;
import com.elitesland.tw.tw5.server.prd.partner.common.dao.AddressBookDAO;
import com.elitesland.tw.tw5.server.prd.partner.common.entity.AddressBookDO;
import com.elitesland.tw.tw5.server.prd.partner.common.repo.AddressBookRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.util.List;
import java.util.Optional;

/**
 * 业务伙伴-地址薄
 *
 * @author wangluyu
 * @date 2023-05-16
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class AddressBookServiceImpl extends BaseServiceImpl implements AddressBookService {

    private final AddressBookRepo addressBookRepo;
    private final AddressBookDAO addressBookDAO;

    @Override
    public PagingVO<AddressBookVO> queryPaging(AddressBookQuery query){
        return addressBookDAO.queryPaging(query);
    }

    @Override
    public List<AddressBookVO> queryListDynamic(AddressBookQuery query){
        return addressBookDAO.queryListDynamic(query);
    }

    @Override
    public AddressBookVO queryByKey(Long key) {
        AddressBookDO entity = addressBookRepo.findById(key).orElseGet(AddressBookDO::new);
        Assert.notNull(entity.getId(), "不存在");
        AddressBookVO vo = AddressBookConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public AddressBookVO insert(AddressBookPayload payload) {
        AddressBookDO entityDo = AddressBookConvert.INSTANCE.toDo(payload);
        return AddressBookConvert.INSTANCE.toVo(addressBookRepo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public AddressBookVO update(AddressBookPayload payload) {
        AddressBookDO entity = addressBookRepo.findById(payload.getId()).orElseGet(AddressBookDO::new);
        Assert.notNull(entity.getId(), "不存在");
        AddressBookDO entityDo = AddressBookConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return AddressBookConvert.INSTANCE.toVo(addressBookRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            addressBookDAO.deleteSoft(keys);
        }
    }

}
