package com.elitesland.tw.tw5.server.prd.partner.strategy.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.partner.strategy.payload.BusinessStrategyModelPayload;
import com.elitesland.tw.tw5.api.prd.partner.strategy.query.BusinessStrategyModelQuery;
import com.elitesland.tw.tw5.api.prd.partner.strategy.vo.BusinessStrategyModelVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.partner.strategy.entity.BusinessStrategyModelDO;
import com.elitesland.tw.tw5.server.prd.partner.strategy.entity.QBusinessStrategyDO;
import com.elitesland.tw.tw5.server.prd.partner.strategy.entity.QBusinessStrategyIndexSettingDO;
import com.elitesland.tw.tw5.server.prd.partner.strategy.entity.QBusinessStrategyModelDO;
import com.elitesland.tw.tw5.server.prd.partner.strategy.repo.BusinessStrategyModelRepo;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 分级策略模型配置
 *
 * @author wangly
 * @date 2023-06-19
 */
@Repository
@RequiredArgsConstructor
public class BusinessStrategyModelDAO {

    private final JPAQueryFactory jpaQueryFactory;
    private final BusinessStrategyModelRepo repo;
    private final QBusinessStrategyModelDO qdo = QBusinessStrategyModelDO.businessStrategyModelDO;
    private final QBusinessStrategyIndexSettingDO qBusinessStrategyIndexSettingDO = QBusinessStrategyIndexSettingDO.businessStrategyIndexSettingDO;
    private final QBusinessStrategyDO qBusinessStrategyDO = QBusinessStrategyDO.businessStrategyDO;
    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<BusinessStrategyModelVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(BusinessStrategyModelVO.class,
                qdo.id,
                qdo.remark,
                qdo.createUserId,
                qdo.creator,
                //qdo.createTime,
                //qdo.modifyUserId,
                //qdo.updater,
                //qdo.modifyTime,
                // 模型编号
                qdo.modelNo,
                // 模型名称
                qdo.modelName,
                // 模型类型 udc[CRM:BUSINESS_STRATEGY_MODEL:TYPE]
                qdo.modelType,
                // 是否标准模版 udc[CRM:BUSINESS_STRATEGY_MODEL:FLAG]
                qdo.standaryFlag,
                // 开始时间
                qdo.startTime,
                // 结束时间
                qdo.endTime,
                // 数据来源 udc[CRM:BUSINESS_STRATEGY_MODEL:SOURCE]
                qdo.source,
                //时间范围 udc[CRM:BUSINESS_STRATEGY_MODEL:DATE]
                qdo.dateRange,
                //R权重
                qdo.RWeight,
                //F权重
                qdo.FWeight,
                //M权重
                qdo.MWeight,
                // 排序号
                qdo.sortNo,
                // 拓展字段1
                qdo.ext1,
                // 拓展字段2
                qdo.ext2,
                // 拓展字段3
                qdo.ext3,
                // 拓展字段4
                qdo.ext4,
                // 拓展字段5
                qdo.ext5
        )).from(qdo);
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<BusinessStrategyModelVO> getJpaQueryWhere(BusinessStrategyModelQuery query) {
        JPAQuery<BusinessStrategyModelVO> jpaQuery = getJpaQuerySelect();
            // 条件封装
            jpaQuery.where(where(query));
            // 常用基础查询条件拼装
            SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
            // 动态排序
            jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
            return jpaQuery;
    }

    /**
     * 统计
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    public long count(BusinessStrategyModelQuery query) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory
        .select(qdo.count())
        .from(qdo);
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        long total = jpaQuery.fetchOne();
        return total;
    }

    /**
     * 查询条件封装
     *
     * @param query 条件
     * @return {@link Predicate}
     */
    private Predicate where(BusinessStrategyModelQuery query){
        List<Predicate> list = new ArrayList<>();
        /** 记录唯一ID 精确 */
        if (!ObjectUtils.isEmpty(query.getId())) {
            list.add(qdo.id.eq(query.getId()));
        }
        /** 模型编号 精确 */
        if (!ObjectUtils.isEmpty(query.getModelNo())) {
            list.add(qdo.modelNo.eq(query.getModelNo()));
        }
        /** 模型名称 精确 */
        if (!ObjectUtils.isEmpty(query.getModelName())) {
            list.add(qdo.modelName.like(SqlUtil.toSqlLikeString(query.getModelName())));
        }
        /** 模型类型 udc[CRM:BUSINESS_STRATEGY_MODEL:TYPE] 精确 */
        if (!ObjectUtils.isEmpty(query.getModelType())) {
            list.add(qdo.modelType.eq(query.getModelType()));
        }
        /** 是否标准模版 udc[CRM:BUSINESS_STRATEGY_MODEL:FLAG] 精确 */
        if (!ObjectUtils.isEmpty(query.getStandaryFlag())) {
            list.add(qdo.standaryFlag.eq(query.getStandaryFlag()));
        }
        /** 开始时间 精确 */
        if (!ObjectUtils.isEmpty(query.getStartTime())) {
            list.add(qdo.startTime.eq(query.getStartTime()));
        }
        /** 结束时间 精确 */
        if (!ObjectUtils.isEmpty(query.getEndTime())) {
            list.add(qdo.endTime.eq(query.getEndTime()));
        }
        /** 数据来源 udc[CRM:BUSINESS_STRATEGY_MODEL:SOURCE] 精确 */
        if (!ObjectUtils.isEmpty(query.getSource())) {
            list.add(qdo.source.eq(query.getSource()));
        }
        /** 排序号 精确 */
        if (!ObjectUtils.isEmpty(query.getSortNo())) {
            list.add(qdo.sortNo.eq(query.getSortNo()));
        }
        /** 拓展字段1 精确 */
        if (!ObjectUtils.isEmpty(query.getExt1())) {
            list.add(qdo.ext1.eq(query.getExt1()));
        }
        /** 拓展字段2 精确 */
        if (!ObjectUtils.isEmpty(query.getExt2())) {
            list.add(qdo.ext2.eq(query.getExt2()));
        }
        /** 拓展字段3 精确 */
        if (!ObjectUtils.isEmpty(query.getExt3())) {
            list.add(qdo.ext3.eq(query.getExt3()));
        }
        /** 拓展字段4 精确 */
        if (!ObjectUtils.isEmpty(query.getExt4())) {
            list.add(qdo.ext4.eq(query.getExt4()));
        }
        /** 拓展字段5 精确 */
        if (!ObjectUtils.isEmpty(query.getExt5())) {
            list.add(qdo.ext5.eq(query.getExt5()));
        }
        return ExpressionUtils.allOf(list);
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public BusinessStrategyModelVO queryByKey(Long id) {
        JPAQuery<BusinessStrategyModelVO> jpaQuery = getJpaQuerySelect();
            jpaQuery.where(qdo.id.eq(id));
            jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 动态查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<BusinessStrategyModelVO> queryListDynamic(BusinessStrategyModelQuery query) {
        JPAQuery<BusinessStrategyModelVO> jpaQuery = getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<BusinessStrategyModelVO> queryPaging(BusinessStrategyModelQuery query) {
        long total = count(query);
        if (total == 0) {
             return PagingVO.empty();
        }
        JPAQuery<BusinessStrategyModelVO> jpaQuery = getJpaQueryWhere(query);
        List<BusinessStrategyModelVO> result = jpaQuery
                .offset(query.getPageRequest().getOffset())
                .limit(query.getPageRequest().getPageSize())
                .fetch();
        return PagingVO.<BusinessStrategyModelVO>builder().records(result).total(total).build();
    }

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public BusinessStrategyModelDO save(BusinessStrategyModelDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<BusinessStrategyModelDO> saveAll(List<BusinessStrategyModelDO> dos) {
        return repo.saveAll(dos);
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    @Transactional
    public long updateByKeyDynamic(BusinessStrategyModelPayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
        .where(qdo.id.eq(payload.getId()));
        // 记录唯一ID
        if (payload.getId() != null) {
            update.set(qdo.id, payload.getId());
        }
        // 模型编号
        if (payload.getModelNo() != null) {
            update.set(qdo.modelNo, payload.getModelNo());
        }
        // 模型名称
        if (payload.getModelName() != null) {
            update.set(qdo.modelName, payload.getModelName());
        }
        // 模型类型 udc[CRM:BUSINESS_STRATEGY_MODEL:TYPE]
        if (payload.getModelType() != null) {
            update.set(qdo.modelType, payload.getModelType());
        }
        // 是否标准模版 udc[CRM:BUSINESS_STRATEGY_MODEL:FLAG]
        if (payload.getStandaryFlag() != null) {
            update.set(qdo.standaryFlag, payload.getStandaryFlag());
        }
        // 开始时间
        if (payload.getStartTime() != null) {
            update.set(qdo.startTime, payload.getStartTime());
        }
        // 结束时间
        if (payload.getEndTime() != null) {
            update.set(qdo.endTime, payload.getEndTime());
        }
        // 数据来源 udc[CRM:BUSINESS_STRATEGY_MODEL:SOURCE]
        if (payload.getSource() != null) {
            update.set(qdo.source, payload.getSource());
        }
        // 排序号
        if (payload.getSortNo() != null) {
            update.set(qdo.sortNo, payload.getSortNo());
        }
        // 拓展字段1
        if (payload.getExt1() != null) {
            update.set(qdo.ext1, payload.getExt1());
        }
        // 拓展字段2
        if (payload.getExt2() != null) {
            update.set(qdo.ext2, payload.getExt2());
        }
        // 拓展字段3
        if (payload.getExt3() != null) {
            update.set(qdo.ext3, payload.getExt3());
        }
        // 拓展字段4
        if (payload.getExt4() != null) {
            update.set(qdo.ext4, payload.getExt4());
        }
        // 拓展字段5
        if (payload.getExt5() != null) {
            update.set(qdo.ext5, payload.getExt5());
        }
        // 处理要设置成空的字段
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
            // 记录唯一ID
            if (nullFields.contains("id")) {
                update.setNull(qdo.id);
            }
            // 模型编号
            if (nullFields.contains("modelNo")) {
                update.setNull(qdo.modelNo);
            }
            // 模型名称
            if (nullFields.contains("modelName")) {
                update.setNull(qdo.modelName);
            }
            // 模型类型 udc[CRM:BUSINESS_STRATEGY_MODEL:TYPE]
            if (nullFields.contains("modelType")) {
                update.setNull(qdo.modelType);
            }
            // 是否标准模版 udc[CRM:BUSINESS_STRATEGY_MODEL:FLAG]
            if (nullFields.contains("standaryFlag")) {
                update.setNull(qdo.standaryFlag);
            }
            // 开始时间
            if (nullFields.contains("startTime")) {
                update.setNull(qdo.startTime);
            }
            // 结束时间
            if (nullFields.contains("endTime")) {
                update.setNull(qdo.endTime);
            }
            // 数据来源 udc[CRM:BUSINESS_STRATEGY_MODEL:SOURCE]
            if (nullFields.contains("source")) {
                update.setNull(qdo.source);
            }
            // 排序号
            if (nullFields.contains("sortNo")) {
                update.setNull(qdo.sortNo);
            }
            // 拓展字段1
            if (nullFields.contains("ext1")) {
                update.setNull(qdo.ext1);
            }
            // 拓展字段2
            if (nullFields.contains("ext2")) {
                update.setNull(qdo.ext2);
            }
            // 拓展字段3
            if (nullFields.contains("ext3")) {
                update.setNull(qdo.ext3);
            }
            // 拓展字段4
            if (nullFields.contains("ext4")) {
                update.setNull(qdo.ext4);
            }
            // 拓展字段5
            if (nullFields.contains("ext5")) {
                update.setNull(qdo.ext5);
            }
        }
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        // 执行修改
        return update.execute();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主集合
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
            .set(qdo.deleteFlag, 1)
            .where(qdo.id.in(keys));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }

    /**
     * 通过模型id查询对应的策略数量
     *
     * @param modelIdList 模型id business_strategy_model.id
     * @param strategyStatus 策略状态
     */
    public Long queryStrategyByModelIdsAndStrategyStatus(List<Long> modelIdList,String strategyStatus){
       return jpaQueryFactory.select(qBusinessStrategyDO.count()).from(qBusinessStrategyDO).
                leftJoin(qBusinessStrategyIndexSettingDO).
                on(qBusinessStrategyDO.id.eq(qBusinessStrategyIndexSettingDO.strategyId)).
                where(qBusinessStrategyDO.deleteFlag.eq(0)).
                where(qBusinessStrategyIndexSettingDO.deleteFlag.eq(0)).
                where(qBusinessStrategyDO.strategyStatus.eq(strategyStatus)).
                where(qBusinessStrategyIndexSettingDO.modelId.in(modelIdList)).fetchOne();
    }
}

