package com.elitesland.tw.tw5.server.prd.pms.common.functionEnum;

import lombok.Getter;

/**
 * 项目结项检查事由（自动检查,对应系统选择项）
 */
public enum ProjectCloseReasonEnum {

    REASON6("6", "工时审批"),
    REASON4("4", "任务关闭"),
    REASON7("7", "出差申请"),
    REASON8("8", "费用报销"),
    REASON10("10", "收款开票"),
    REASON11("11", "预付款审批"),
    REASON16("16", "收款计划"),
    REASON19("19", "客户承担费用"),
    REASON20("20", "项目未支付款项"),
    ;

    @Getter
    private final String code;

    /**
     * 描述
     */
    @Getter
    private final String desc;

    ProjectCloseReasonEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

}
