package com.elitesland.tw.tw5.server.prd.pms.service;

import cn.zhxu.bs.BeanSearcher;
import cn.zhxu.bs.FieldOps;
import cn.zhxu.bs.util.MapBuilder;
import cn.zhxu.bs.util.MapUtils;
import com.alibaba.fastjson.JSON;
import com.el.coordinator.core.common.utils.BeanCopyUtil;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import com.elitesland.tw.tw5.api.common.change.payload.ComChangePayload;
import com.elitesland.tw.tw5.api.common.change.service.ComChangeService;
import com.elitesland.tw.tw5.api.common.change.vo.ComChangeVO;
import com.elitesland.tw.tw5.api.prd.budget.query.BudgetQuery;
import com.elitesland.tw.tw5.api.prd.cal.payload.CalAccountPayload;
import com.elitesland.tw.tw5.api.prd.cal.payload.CalWideSettlePayload;
import com.elitesland.tw.tw5.api.prd.cal.service.CalAccountService;
import com.elitesland.tw.tw5.api.prd.cal.service.CalWideSettleService;
import com.elitesland.tw.tw5.api.prd.cal.vo.CalAccountVO;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmCustomerOperationService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmCustomerOperationVO;
import com.elitesland.tw.tw5.api.prd.my.query.TimesheetQuery;
import com.elitesland.tw.tw5.api.prd.my.service.TimesheetService;
import com.elitesland.tw.tw5.api.prd.my.vo.TimesheetVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgOrganizationVO;
import com.elitesland.tw.tw5.api.prd.partner.common.service.BusinessPartnerService;
import com.elitesland.tw.tw5.api.prd.partner.common.vo.BusinessPartnerVO;
import com.elitesland.tw.tw5.api.prd.personplan.payload.PersonPlanDtlPayload;
import com.elitesland.tw.tw5.api.prd.personplan.payload.PersonPlanPayload;
import com.elitesland.tw.tw5.api.prd.personplan.service.PersonPlanDtlService;
import com.elitesland.tw.tw5.api.prd.personplan.service.PersonPlanService;
import com.elitesland.tw.tw5.api.prd.personplan.vo.DayJsonVO;
import com.elitesland.tw.tw5.api.prd.personplan.vo.PersonPlanDtlVO;
import com.elitesland.tw.tw5.api.prd.personplan.vo.PersonPlanVO;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsProjectPayload;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsProjectReportPlanPayload;
import com.elitesland.tw.tw5.api.prd.pms.query.*;
import com.elitesland.tw.tw5.api.prd.pms.service.*;
import com.elitesland.tw.tw5.api.prd.pms.vo.*;
import com.elitesland.tw.tw5.api.prd.purchase.service.PurchaseContractManagerService;
import com.elitesland.tw.tw5.api.prd.salecon.query.ConReceivablePlanQuery;
import com.elitesland.tw.tw5.api.prd.salecon.service.ConReceivablePlanService;
import com.elitesland.tw.tw5.api.prd.salecon.service.SaleConExecConditionService;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConReceivablePlanVO;
import com.elitesland.tw.tw5.api.prd.salecon.vo.SaleConContractVO;
import com.elitesland.tw.tw5.api.prd.salecon.vo.SaleConExecConditionVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemRoleService;
import com.elitesland.tw.tw5.api.prd.task.query.TaskPackageQuery;
import com.elitesland.tw.tw5.server.common.ExcelUtil;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.change.changeEnum.ChangeTypeEnum;
import com.elitesland.tw.tw5.server.common.permission.PermissionBeanSearcherFactory;
import com.elitesland.tw.tw5.server.common.permission.enums.PermissionDomainEnum;
import com.elitesland.tw.tw5.server.common.service.TransactionUtilService;
import com.elitesland.tw.tw5.server.common.util.DateUtil;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.budget.dao.BudgetDAO;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.FileUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.WorkflowUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.*;
import com.elitesland.tw.tw5.server.prd.personplan.constants.PersonPlanTypeEnum;
import com.elitesland.tw.tw5.server.prd.personplan.constants.PersonPlanUomEnum;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.PmsProcDefKey;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.ProjectRiskLevelEnum;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.ProjectStatusEnum;
import com.elitesland.tw.tw5.server.prd.pms.convert.PmsProjectConvert;
import com.elitesland.tw.tw5.server.prd.pms.convert.PmsProjectReportPlanConvert;
import com.elitesland.tw.tw5.server.prd.pms.dao.PmsProjectDAO;
import com.elitesland.tw.tw5.server.prd.pms.dao.PmsProjectMembersDAO;
import com.elitesland.tw.tw5.server.prd.pms.entity.PmsProjectDO;
import com.elitesland.tw.tw5.server.prd.pms.entity.PmsProjectMembersDO;
import com.elitesland.tw.tw5.server.prd.pms.repo.PmsProjectRepo;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemRoleDAO;
import com.elitesland.tw.tw5.server.prd.task.dao.TaskPackageDAO;
import com.elitesland.tw.tw5.server.udc.UdcUtil;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import com.elitesland.workflow.payload.StartProcessPayload;
import com.google.common.collect.Lists;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import javax.servlet.http.HttpServletResponse;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAdjuster;
import java.time.temporal.TemporalAdjusters;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;


/**
 * 项目
 *
 * @author carl
 * @date 2023-08-07
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class PmsProjectServiceImpl extends BaseServiceImpl implements PmsProjectService {

    private final PmsProjectRepo pmsProjectRepo;
    private final PmsProjectDAO pmsProjectDAO;
    private final FileUtil fileUtil;
    private final PmsProjectBriefService pmsProjectBriefService;
    private final PmsProjectReportPlanService pmsProjectReportPlanService;
    private final TransactionUtilService transactionUtilService;
    private final ComChangeService changeService;
    private final WorkflowUtil workflowUtil;
    private final PrdSystemRoleService roleService;
    private final UdcUtil udcUtil;
    private final ConReceivablePlanService conReceivablePlanService;
    private final CrmCustomerOperationService customerOperationService;
    private final PmsProjectTemplateService pmsProjectTemplateService;
    private final CacheUtil cacheUtil;
    private final PmsProjectMembersDAO pmsProjectMembersDAO;
    private final CalAccountService calAccountService;
    private final CalWideSettleService calWideSettleService;
    private final ExcelUtil excelUtil;
    private final PrdSystemRoleDAO systemRoleDAO;
    private final PmsProjectActivityService projectActivityService;
    private final PmsProjectMembersService projectMembersService;
    private final PmsResourcePlanService resourcePlanService;
    private final BudgetDAO budgetDAO;
    private final TaskPackageDAO taskPackageDAO;
    private final BusinessPartnerService businessPartnerService;
    private BeanSearcher beanSearcher;
    @Autowired
    @Lazy
    private PersonPlanService personPlanService;
    @Autowired
    @Lazy
    private PersonPlanDtlService personPlanDtlService;
    @Autowired
    @Lazy
    private TimesheetService timesheetService;

    @Autowired
    @Lazy
    private SaleConExecConditionService saleConExecConditionService;
    @Value("${tw5.project.briefDate:15}")
    private Integer briefDate = 15;

    @Autowired
    @Lazy
    private PurchaseContractManagerService purchaseContractManagerService;

    @Autowired
    public void setBeanSearcher(PermissionBeanSearcherFactory permissionBeanSearcherFactory) {
        this.beanSearcher = permissionBeanSearcherFactory.getBeanSearcherService(PermissionDomainEnum.PMS_PROJECT);
    }

    private MapBuilder pageWhereBuilder(PmsProjectQuery query) {
        MapBuilder builder = MapUtils.builder();
        /** 项目名称/编号 关键字查询 */
        if (!ObjectUtils.isEmpty(query.getProjectSearchKey())) {
            String likeStr = "%" + query.getProjectSearchKey() + "%";
            builder.field(PmsProjectVO::getProjName, PmsProjectVO::getProjNo).sql("$1 like ? or $2 like ?", likeStr, likeStr);
        }
        /** 工作类型 */
        if (!ObjectUtils.isEmpty(query.getWorkType())) {
            builder.field(PmsProjectVO::getWorkType, query.getWorkType()).op(FieldOps.Equal);
        }
        /**是否筛选的全是外部项目*/
        if (query.getIsExternalProject()) {
            //i. “工作类型”筛选，若勾选了“仅外部项目”，需过滤掉 platType = 'ficitious'的项目，即平台合同类型=“虚拟合同”的数据不应展示
            query.setPlatType(SaleConEnum.FICTITIOUS.getCode());
            builder.field(PmsProjectVO::getPlatType, query.getPlatType()).op(FieldOps.NotEqual);
            //  list.add(qdoSaleCon.platType.ne(SaleConEnum.FICTITIOUS.getCode()));
        }
        /** 项目状态 精确 */
        if (!ObjectUtils.isEmpty(query.getProjStatus())) {
            if (ObjectUtils.isEmpty(query.getProjStatusType()) || "1".equals(query.getProjStatusType())) {
                builder.field(PmsProjectVO::getProjStatus, query.getProjStatus()).op(FieldOps.Equal);
            } else {
                builder.field(PmsProjectVO::getProjStatus, query.getProjStatus()).op(FieldOps.NotEqual);
            }
        }
        /** 交付BU_ID */
        if (!ObjectUtils.isEmpty(query.getDeliBuId())) {
            builder.field(PmsProjectVO::getDeliBuId, query.getDeliBuId()).op(FieldOps.Equal);
        }
        /** 交付负责人id */
        if (!ObjectUtils.isEmpty(query.getDeliUserId())) {
            builder.field(PmsProjectVO::getDeliUserId, query.getDeliUserId()).op(FieldOps.Equal);
        }
        /** 销售负责人ID */
        if (!ObjectUtils.isEmpty(query.getSaleManUserId())) {
            builder.field(PmsProjectVO::getSaleManUserId, query.getSaleManUserId()).op(FieldOps.Equal);
        }
        /** 风险等级  */
        if (!ObjectUtils.isEmpty(query.getRiskLevel())) {
            builder.field(PmsProjectVO::getRiskLevel, query.getRiskLevel()).op(FieldOps.Equal);
        }
        /** 项目经理资源id 精确 */
        if (!ObjectUtils.isEmpty(query.getPmResId())) {
            builder.field(PmsProjectVO::getPmResId, query.getPmResId()).op(FieldOps.Equal);
        }
        /** pmo资源负责人id 精确 */
        if (!ObjectUtils.isEmpty(query.getPmoResId())) {
            builder.field(PmsProjectVO::getPmoResId, query.getPmoResId()).op(FieldOps.Equal);
        }
        /** 合同编号/名称 */
        if (!ObjectUtils.isEmpty(query.getContractSearchKey())) {
            String likeStr = "%" + query.getContractSearchKey() + "%";
            builder.field(PmsProjectVO::getContractName, PmsProjectVO::getContractNo).sql("$1 like ? or $2 like ?", likeStr, likeStr);
        }
        /** 成本级别 精确 */
        if (!ObjectUtils.isEmpty(query.getCostLevel())) {
            builder.field(PmsProjectVO::getCostLevel, query.getCostLevel()).op(FieldOps.Equal);
        }
        /** 项目经理资源id 精确 */
        if (!ObjectUtils.isEmpty(query.getPmResId())) {
            builder.field(PmsProjectVO::getPmResId, query.getPmResId()).op(FieldOps.Equal);
        }
        /** 关联项目编号 模糊 */
        if (!ObjectUtils.isEmpty(query.getRelatedProjNo())) {
            builder.field(PmsProjectVO::getRelatedProjNo, query.getRelatedProjNo()).op(FieldOps.Contain);
        }
        /** 产品编号 模糊 */
        if (!ObjectUtils.isEmpty(query.getProductNo())) {
            builder.field(PmsProjectVO::getProductNo, query.getProductNo()).op(FieldOps.Contain);
        }
        /** 是否上传文档（通用文档）标记 精确 */
        if (!ObjectUtils.isEmpty(query.getFileUploadFlag()) && !ObjectUtils.isEmpty(query.getConfigId())) {
            Long configId = query.getConfigId();
            if (Boolean.TRUE.equals(query.getFileUploadFlag())) {
                builder.field(PmsProjectVO::getId).sql("" +
                        " $1 in (SELECT r.doc_id FROM prd_business_doc_type_upload_record r " +
                        "WHERE r.doc_type='PMS_PROJECT' " +
                        "AND r.config_id=? " +
                        "AND r.delete_flag=0)", configId);
            } else if (Boolean.FALSE.equals(query.getFileUploadFlag())) {
                builder.field(PmsProjectVO::getId).sql("" +
                        " $1 not in (SELECT r.doc_id FROM prd_business_doc_type_upload_record r " +
                        "WHERE r.doc_type='PMS_PROJECT' " +
                        "AND r.config_id=? " +
                        "AND r.delete_flag=0)", configId);
            }
        }
        /** 产品编号标记 精确 */
        if (!ObjectUtils.isEmpty(query.getProductNoExit())) {
            if ("1".equals(query.getProductNoExit())) {
                builder.field(PmsProjectVO::getProductNo, query.getProductNo()).op(FieldOps.NotEmpty);
            } else {
                builder.field(PmsProjectVO::getProductNo, query.getProductNo()).op(FieldOps.Empty);
            }
        }
        if (!ObjectUtils.isEmpty(query.getPlanStartDateBetween())) {
            builder.field(PmsProjectVO::getPlanStartDate, query.getPlanStartDateBetween().get(0), query.getPlanStartDateBetween().get(1)).op(FieldOps.Between);
            //jpaQuery.where(qdo.workDate.between(query.getWorkDateBetween().get(0), query.getWorkDateBetween().get(1)));
        }
        if (!ObjectUtils.isEmpty(query.getPlanEndDateBetween())) {
            builder.field(PmsProjectVO::getPlanEndDate, query.getPlanEndDateBetween().get(0), query.getPlanEndDateBetween().get(1)).op(FieldOps.Between);
            //jpaQuery.where(qdo.workDate.between(query.getWorkDateBetween().get(0), query.getWorkDateBetween().get(1)));
        }
//        if (!ObjectUtils.isEmpty(query.getCreateTimeStart())) {
//            builder.field(PmsProjectVO::getCreateTime, query.getCreateTimeStart()).op(FieldOps.GreaterEqual);
//        }
//        if (!ObjectUtils.isEmpty(query.getCreateTimeEnd())) {
//            builder.field(PmsProjectVO::getCreateTime, query.getCreateTimeEnd()).op(FieldOps.LessEqual);
//        }

        // 分组使用占位符，需要在实体类注解中指定参数
        builder.put("groupBy", "pp.id");
        // 常用基础查询条件拼装,动态排序,分页,功能代码
        SqlUtil.handleBS(builder, query);

        return builder;
    }

    @Override
    public PagingVO<PmsProjectVO> queryPaging(PmsProjectQuery query) {


        // 构建查询参数
        MapBuilder mapBuilder = this.pageWhereBuilder(query);
        Number totalNum = beanSearcher.searchCount(PmsProjectVO.class, mapBuilder.build());
        long total = (long) totalNum;
        if (total == 0) {
            return PagingVO.empty();
        }
        List<PmsProjectVO> pmsProjectVOs = beanSearcher.searchList(PmsProjectVO.class, mapBuilder.build());
        List<Long> contractIds = new ArrayList<>();
        List<Long> ids = new ArrayList<>();
        pmsProjectVOs.forEach(vo -> {
            if (vo.getCustId() != null) {
                vo.setCustName(cacheUtil.getCompanyNameByBookId(vo.getCustId()));
            }
            if (vo.getContractId() != null) {
                contractIds.add(vo.getContractId());
            }
            if (vo.getEqvaReleasedQty() != null && vo.getEqvaReleasedQty().compareTo(BigDecimal.ZERO) > 0) {
                ids.add(vo.getId());
                //赋值剩余可拨付当量
                vo.setRemainReleasedEqva(vo.getEqvaBudgetCnt().subtract(vo.getEqvaReleasedQty()));
            }
        });
        //翻译数据
        tranContractData(pmsProjectVOs, contractIds);

        return PagingVO.<PmsProjectVO>builder().records(pmsProjectVOs).total(total).build();
//        PagingVO<PmsProjectVO> pmsProjectVOPagingVO = pmsProjectDAO.queryPaging(query);
//        if (pmsProjectVOPagingVO.getTotal() > 0) {
//            List<PmsProjectVO> pmsProjectVOs = pmsProjectVOPagingVO.getRecords();
//            List<Long> contractIds = new ArrayList<>();
//            List<Long> ids = new ArrayList<>();
//            pmsProjectVOs.forEach(vo -> {
//                if (vo.getContractId() != null) {
//                    contractIds.add(vo.getContractId());
//                }
//                if (vo.getEqvaReleasedQty() != null && vo.getEqvaReleasedQty().compareTo(BigDecimal.ZERO) > 0) {
//                    ids.add(vo.getId());
//                    //赋值剩余可拨付当量
//                    vo.setRemainReleasedEqva(vo.getEqvaBudgetCnt().subtract(vo.getEqvaReleasedQty()));
//                }
//            });
//            if (contractIds.size() > 0) {
//                //收款计划
//                ConReceivablePlanQuery queryReceivablePlan = new ConReceivablePlanQuery();
//                queryReceivablePlan.setSaleConIds(contractIds);
//                List<ConReceivablePlanVO> recvPlanViews = conReceivablePlanService.queryListDynamic(queryReceivablePlan);
//                if (!ObjectUtils.isEmpty(recvPlanViews)) {
//                    //翻译项目map
//                    Map<Long, PmsProjectVO> mapContractProjects = pmsProjectVOs.stream().collect(Collectors.toMap(PmsProjectVO::getContractId, Function.identity()));
//                    mapContractProjects.forEach((contractId, pmsProjectVO) -> {
//                        // 计算实际收款金额
//                        BigDecimal actualReceivedAmt = recvPlanViews.stream().filter(recvPlanView -> recvPlanView.getSaleConId().equals(contractId))
//                                .map(ConReceivablePlanVO::getActualRecvAmt)
//                                .filter(Objects::nonNull)
//                                .reduce(BigDecimal.ZERO, BigDecimal::add);
//
//                        //计算已开票金额
//                        BigDecimal invoicedAmt = recvPlanViews.stream().filter(recvPlanView -> recvPlanView.getSaleConId().equals(contractId))
//                                .map(ConReceivablePlanVO::getAlreadyInvAmt)
//                                .filter(Objects::nonNull)
//                                .reduce(BigDecimal::add)
//                                .orElse(BigDecimal.ZERO);
//
//                        //计算未收款金额
//                        BigDecimal notReceivedAmt = (pmsProjectVO.getSumAmt() == null ? BigDecimal.ZERO : pmsProjectVO.getSumAmt()).subtract(actualReceivedAmt);
//                        pmsProjectVO.setNotReceivedAmt(notReceivedAmt);
//                        pmsProjectVO.setInvoicedAmt(invoicedAmt);
//                        pmsProjectVO.setRecvedAmt(actualReceivedAmt);
//
//                    });
//                }
//            }
////            //获取当量相关数据
////            if (ids.size() > 0) {
////                PmsTaskQuery queryTask = new PmsTaskQuery();
////                queryTask.setReasonIds(ids);
////                queryTask.setReasonType(TaskReasonTypeEnum.PROJECT.getCode());
////                Map<Long, PmsUseTaskVO> pmsUseTaskVOMap = pmsReasonService.queryReasonTaskEqvas(queryTask);
////                if (pmsUseTaskVOMap != null) {
////                    //翻译项目map
////                    Map<Long, PmsProjectVO> projectMap = pmsProjectVOs.stream().collect(Collectors.toMap(PmsProjectVO::getId, Function.identity()));
////                    pmsUseTaskVOMap.forEach((id, pmsUseTaskVO) -> {
////                        PmsProjectVO pmsProjectVO = projectMap.get(id);
////                        // 剩余可用当量 = 已拨付的当量 - 已派发的任务包当量 - 已授权出去的当量总和+ 已授权当量中 派发出去的当量(result.getDistedEqva()中已包含)
////                        BigDecimal availabledEqva = pmsProjectVO.getEqvaReleasedQty().subtract(pmsUseTaskVO.getUseEqva()).subtract(pmsUseTaskVO.getAuthedEqva()).add(pmsUseTaskVO.getAuthedDistedEqva());
////                        pmsProjectVO.setRemainEqva(availabledEqva);
////                        pmsProjectVO.setSettledEqva(pmsUseTaskVO.getSettledEqva());
////                        pmsProjectVO.setDistEqva(pmsUseTaskVO.getUseEqva());
////                    });
////                }
////            }
//        }
        //       return pmsProjectVOPagingVO;
    }

    /**
     * 合同相关数据处理数据
     *
     * @param pmsProjectVOs
     * @param contractIds
     */
    void tranContractData(List<PmsProjectVO> pmsProjectVOs, List<Long> contractIds) {
        if (contractIds.size() > 0) {
            //收款计划
            ConReceivablePlanQuery queryReceivablePlan = new ConReceivablePlanQuery();
            queryReceivablePlan.setSaleConIds(contractIds);
            List<ConReceivablePlanVO> recvPlanViews = conReceivablePlanService.queryListDynamic(queryReceivablePlan);
            if (!ObjectUtils.isEmpty(recvPlanViews)) {
                //翻译项目map
                Map<Long, PmsProjectVO> mapContractProjects = pmsProjectVOs.stream().collect(Collectors.toMap(PmsProjectVO::getContractId, Function.identity()));
                mapContractProjects.forEach((contractId, pmsProjectVO) -> {
                    // 计算实际收款金额
                    BigDecimal actualReceivedAmt = recvPlanViews.stream().filter(recvPlanView -> recvPlanView.getSaleConId().equals(contractId))
                            .map(ConReceivablePlanVO::getActualRecvAmt)
                            .filter(Objects::nonNull)
                            .reduce(BigDecimal.ZERO, BigDecimal::add);

                    //计算已开票金额
                    BigDecimal invoicedAmt = recvPlanViews.stream().filter(recvPlanView -> recvPlanView.getSaleConId().equals(contractId))
                            .map(ConReceivablePlanVO::getAlreadyInvAmt)
                            .filter(Objects::nonNull)
                            .reduce(BigDecimal::add)
                            .orElse(BigDecimal.ZERO);

                    //计算未收款金额
                    BigDecimal notReceivedAmt = (pmsProjectVO.getSumAmt() == null ? BigDecimal.ZERO : pmsProjectVO.getSumAmt()).subtract(actualReceivedAmt);
                    pmsProjectVO.setNotReceivedAmt(notReceivedAmt);
                    pmsProjectVO.setInvoicedAmt(invoicedAmt);
                    pmsProjectVO.setRecvedAmt(actualReceivedAmt);

                    // 未开票金额
                    BigDecimal notInvAmt = recvPlanViews.stream().filter(recvPlanView -> recvPlanView.getSaleConId().equals(contractId))
                            .map(ConReceivablePlanVO::getNotInvAmt)
                            .filter(Objects::nonNull)
                            .reduce(BigDecimal::add)
                            .orElse(BigDecimal.ZERO);
                    pmsProjectVO.setNotInvAmt(notInvAmt);
                });
            }
        }
    }

    @Override
    public void downloadBatch(HttpServletResponse response, PmsProjectQuery query) {

        ClassPathResource classPathResource = new ClassPathResource("template/pmsProjectBatch.xlsx");
        try {
            InputStream inputStream = classPathResource.getInputStream();
            Workbook workbook = WorkbookFactory.create(inputStream);
            XSSFSheet batchProjectSheet = (XSSFSheet) workbook.getSheet("项目数据");
            String fileName = "项目数据-" + LocalDate.now();


            // 构建查询参数
            MapBuilder mapBuilder = this.pageWhereBuilder(query);
            List<PmsProjectVO> result = beanSearcher.searchList(PmsProjectVO.class, mapBuilder.build());
            //数据导出
            //  List<PmsProjectVO> result = pmsProjectDAO.queryListDynamic(query);
            if (!ObjectUtils.isEmpty(result)) {
                List<Long> collect = result.stream().filter(vo -> vo.getContractId() != null).map(PmsProjectVO::getContractId).distinct().collect(Collectors.toList());
                //翻译合同相关数据
                tranContractData(result, collect);

                result = udcUtil.translateList(result);
                int nextRow = 1;
                for (PmsProjectVO projectVO : result) {
                    Row row = batchProjectSheet.createRow(nextRow);
                    excelUtil.setCellValue(row, 0, projectVO.getProjNo()); // 项目编号
                    excelUtil.setCellValue(row, 1, projectVO.getProjName());// 编号
                    excelUtil.setCellValue(row, 2, projectVO.getBangwo8ProjName());// 名称
                    excelUtil.setCellValue(row, 3, projectVO.getWorkTypeDesc());// 工作类型
                    excelUtil.setCellValue(row, 4, projectVO.getProjStatusDesc());// 项目状态

                    excelUtil.setCellValue(row, 5, projectVO.getDeliBuName());// 交付bu
                    excelUtil.setCellValue(row, 6, projectVO.getRiskLevelDesc());// 风险等级
                    excelUtil.setCellValue(row, 7, projectVO.getPmResName());// 项目经理
                    excelUtil.setCellValue(row, 8, projectVO.getSaleManUserName());// 销售负责人
                    excelUtil.setCellValue(row, 9, projectVO.getPmoResName());// pmo

                    excelUtil.setCellValue(row, 10, projectVO.getContractNo());// 子合同编号
                    excelUtil.setCellValue(row, 11, projectVO.getContractName());// 合同名称
                    excelUtil.setCellValue(row, 12, projectVO.getPlatTypeDesc());// 平台合同类型
                    excelUtil.setCellValue(row, 13, projectVO.getSumAmt());// 含税合同总金额
                    excelUtil.setCellValue(row, 14, projectVO.getInvoicedAmt());// 已开票金额

                    excelUtil.setCellValue(row, 15, projectVO.getRecvedAmt());// 已收款金额
                    excelUtil.setCellValue(row, 16, projectVO.getNotReceivedAmt());// 未收款金额
                    if (projectVO.getCompPercent() != null) {
                        excelUtil.setCellValue(row, 17, projectVO.getCompPercent());// 完工百分比
                    }
                    excelUtil.setCellValue(row, 18, projectVO.getProjProcessStatusDesc());// 项目汇报进度状态
                    excelUtil.setCellValue(row, 19, projectVO.getReportTime());// 汇报时间

                    excelUtil.setCellValue(row, 20, projectVO.getPlanUpdateDate());// 资源更新日期
                    excelUtil.setCellValue(row, 21, projectVO.getRelatedProjNo());// 关联项目编号
                    excelUtil.setCellValue(row, 22, projectVO.getProductNo());// 产品编号
                    excelUtil.setCellValue(row, 23, projectVO.getPlanStartDate());// 预计开始
                    excelUtil.setCellValue(row, 24, projectVO.getPlanEndDate());// 预计结束
                    excelUtil.setCellValue(row, 25, projectVO.getCreateTime());// 创建时间
                    //  excelUtil.setCellValue(row, 24, projectVO.getContractNo());// 子账类型
                    nextRow++;
                }
            }
            ExcelUtil.writeResponse(response, fileName, workbook);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public Map queryPlanAndActual(Long key) {
        Set<Long> resIdSet = new HashSet();
        List<PmsPersonPlanAndActualVO> pmsPersonPlanAndActualVOList = new ArrayList<>();
        Map<Long, List<PersonPlanDtlVO>> personPlanDtlMap = new HashMap<>();
        Map<Long, List<TimesheetVO>> actResIdMap = new HashMap<>();
        LocalDate startDate = null;
        LocalDate endDate = null;
        List<String> columnDateList = new ArrayList();
        //先查询资源规划
        PersonPlanVO personPlanVO = personPlanService.getByObjIdAndPlanType(key, Arrays.asList(PersonPlanTypeEnum.PROJECT.getCode()));
        String uom = null;
        if (personPlanVO != null) {
            uom = personPlanVO.getUom();
            startDate = personPlanVO.getStartDate();
            endDate = personPlanVO.getEndDate();
            List<PersonPlanDtlVO> personPlanDtlVOList = personPlanVO.getPersonPlanDtlVOList();
            if (!CollectionUtils.isEmpty(personPlanDtlVOList)) {
                personPlanDtlMap = personPlanDtlVOList.stream().collect(Collectors.groupingBy(PersonPlanDtlVO::getResId));
                personPlanDtlVOList.stream().forEach(e -> {
                    PmsPersonPlanAndActualVO pmsPersonPlanAndActualVO = new PmsPersonPlanAndActualVO();
                    pmsPersonPlanAndActualVO.setResId(e.getResId());
                    pmsPersonPlanAndActualVO.setResName(e.getResName());
                    pmsPersonPlanAndActualVO.setCapasetLevelId(e.getCapasetLevelId());
                    pmsPersonPlanAndActualVO.setCapasetLevelIdDesc(e.getCapasetLevelIdDesc());
                    pmsPersonPlanAndActualVO.setDistributeRate(e.getDistributeRate());
                    pmsPersonPlanAndActualVO.setDays(e.getDays());
                    pmsPersonPlanAndActualVO.setTotalEqva(e.getTotalEqva());
                    pmsPersonPlanAndActualVOList.add(pmsPersonPlanAndActualVO);
                    resIdSet.add(e.getResId());
                });
            }
        }
        // 查询项目的工时实际投入
        TimesheetQuery timesheetQuery = new TimesheetQuery();
        timesheetQuery.setProjId(key);
        List<TimesheetVO> timesheetVOS = timesheetService.queryList(timesheetQuery);
        if (!CollectionUtils.isEmpty(timesheetVOS)) {
            List<LocalDate> workDateList = timesheetVOS.stream().map(e -> e.getWorkDate()).collect(Collectors.toList());
            LocalDate maxDate = Collections.max(workDateList);
            LocalDate minDate = Collections.min(workDateList);
            if (minDate.compareTo(startDate) < 0) {
                startDate = minDate;
            }
            if (maxDate.compareTo(endDate) > 0) {
                endDate = maxDate;
            }
            actResIdMap = timesheetVOS.stream().collect(Collectors.groupingBy(TimesheetVO::getTsUserId));
            actResIdMap.keySet().stream().forEach(e -> {
                // 先判断在资源规划中这个人存不存在 如果存在就使用原来的 不存在就新增一个对象
                if (resIdSet.contains(e)) {
                    List<PmsPersonPlanAndActualVO> collect = pmsPersonPlanAndActualVOList.stream().filter(f -> f.getResId().equals(e)).collect(Collectors.toList());
                    PmsPersonPlanAndActualVO pmsPersonPlanAndActualVO = collect.get(0);
                    PrdOrgEmployeeVO employee = cacheUtil.getEmployee(e);
                    pmsPersonPlanAndActualVO.setActDistributeRate(employee.getEqvaRatio());
                    pmsPersonPlanAndActualVO.setActResId(e);
                    pmsPersonPlanAndActualVO.setActResName(employee.getEmployeeName());
                    pmsPersonPlanAndActualVO.setActGrade(employee.getExtString1());
                } else {
                    PmsPersonPlanAndActualVO pmsPersonPlanAndActualVO = new PmsPersonPlanAndActualVO();
                    PrdOrgEmployeeVO employee = cacheUtil.getEmployee(e);
                    pmsPersonPlanAndActualVO.setActDistributeRate(employee.getEqvaRatio());
                    pmsPersonPlanAndActualVO.setActResId(e);
                    pmsPersonPlanAndActualVO.setActResName(employee.getEmployeeName());
                    pmsPersonPlanAndActualVO.setActGrade(employee.getExtString1());
                    pmsPersonPlanAndActualVOList.add(pmsPersonPlanAndActualVO);
                }
            });
        }

        //开始循环预实对照的list 然后添加每个人的json
        if (!CollectionUtils.isEmpty(pmsPersonPlanAndActualVOList)) {
            // 先获取表头的日期表格
            TemporalAdjuster adjuster = null;
            String title = "";
            if (!StringUtils.hasText(uom)) {
                uom = PersonPlanUomEnum.month.getCode();
                adjuster = TemporalAdjusters.lastDayOfMonth();
                title = "M";
            } else {
                if (PersonPlanUomEnum.week.getCode().equals(uom)) {
                    adjuster = TemporalAdjusters.next(DayOfWeek.SUNDAY);
                    title = "W";
                }
                if (PersonPlanUomEnum.month.getCode().equals(uom)) {
                    adjuster = TemporalAdjusters.lastDayOfMonth();
                    title = "M";
                }
                if (PersonPlanUomEnum.year.getCode().equals(uom)) {
                    adjuster = TemporalAdjusters.lastDayOfYear();
                    title = "Y";
                }
            }
            // 获取时间段
            List<Map<String, String>> dataRangeList = personPlanDtlService.dataRange(startDate, endDate, adjuster);
            int index = 0;
            // 循环预实对照的数据
            for (PmsPersonPlanAndActualVO pmsPersonPlanAndActualVO : pmsPersonPlanAndActualVOList) {
                Long resId = pmsPersonPlanAndActualVO.getResId();
                List<DayJsonVO> dayJsonVOS = null;
                List<TimesheetVO> timesheetVOList = null;
                // 获取资源规划的实际规划
                if (personPlanDtlMap.containsKey(resId)) {
                    List<PersonPlanDtlVO> personPlanDtlVOS = personPlanDtlMap.get(resId);
                    PersonPlanDtlVO personPlanDtlVO = personPlanDtlVOS.get(0);
                    String daysJson = personPlanDtlVO.getDaysJson();
                    dayJsonVOS = JSON.parseArray(daysJson, DayJsonVO.class);
                }
                // 获取实际投入的工时
                if (actResIdMap.containsKey(resId)) {
                    timesheetVOList = actResIdMap.get(resId);
                }
                List<PmsActAndPlanJsonVO> pmsActAndPlanJsonVOList = new ArrayList();
                // 开始循环表头列
                for (int i = 0; i < dataRangeList.size(); i++) {
                    PmsActAndPlanJsonVO pmsActAndPlanJsonVO = new PmsActAndPlanJsonVO();
                    Map<String, String> stringStringMap = dataRangeList.get(index);
                    List<String> collect = stringStringMap.keySet().stream().collect(Collectors.toList());
                    String start = collect.get(0);
                    String end = stringStringMap.get(start);
                    LocalDate startDateOne = LocalDate.parse(start, DateTimeFormatter.ofPattern("yyyy-MM-dd"));
                    LocalDate endDateOne = LocalDate.parse(end, DateTimeFormatter.ofPattern("yyyy-MM-dd"));
                    if (PersonPlanUomEnum.month.getCode().equals(uom)) {
                        LocalDate monthDate = LocalDate.parse(start, DateTimeFormatter.ofPattern("yyyy-MM-dd"));
                        DateTimeFormatter outputFormatter = DateTimeFormatter.ofPattern("yy-MM");
                        start = monthDate.format(outputFormatter);
                    }
                    if (PersonPlanUomEnum.year.getCode().equals(uom)) {
                        LocalDate yearDate = LocalDate.parse(start, DateTimeFormatter.ofPattern("yyyy-MM-dd"));
                        DateTimeFormatter outputFormatter = DateTimeFormatter.ofPattern("yyyy");
                        start = yearDate.format(outputFormatter);
                    }
                    // 表格格式
                    String column = title + (index + 1) + " " + start;
                    columnDateList.add(column);
                    pmsActAndPlanJsonVO.setColumn(column);

                    // 计算规划的天数
                    if (!CollectionUtils.isEmpty(dayJsonVOS)) {
                        // 因为规划的都是每天八小时 所以直接按日期来算天数就可以
                        BigDecimal days = BigDecimal.ZERO;
                        for (DayJsonVO dayJsonVO : dayJsonVOS) {
                            LocalDate date = LocalDate.parse(dayJsonVO.getDate(), DateTimeFormatter.ofPattern("yyyy-MM-dd"));
                            if (date.isEqual(startDateOne) || date.isEqual(endDateOne) || (date.isAfter(startDateOne) && date.isBefore(endDateOne))) {
                                days = days.add(dayJsonVO.getDay()).setScale(2, RoundingMode.HALF_UP);
                            }
                        }
                        pmsActAndPlanJsonVO.setPlanDays(days);
                    }

                    // 根据工时计算实际的天数
                    if (!CollectionUtils.isEmpty(timesheetVOList)) {
                        // 因为实际会有小时数或者半天这种 因此计算总小时数 然后除以8
                        BigDecimal hours = BigDecimal.ZERO;
                        for (TimesheetVO timesheetVO : timesheetVOList) {
                            LocalDate date = timesheetVO.getWorkDate();
                            if (date.isEqual(startDateOne) || date.isEqual(endDateOne) || (date.isAfter(startDateOne) && date.isBefore(endDateOne))) {
                                hours = hours.add(timesheetVO.getWorkHour()).setScale(2, RoundingMode.HALF_UP);
                            }
                        }
                        BigDecimal actDays = hours.divide(new BigDecimal(8), 2, RoundingMode.HALF_UP);
                        pmsActAndPlanJsonVO.setActDays(actDays);
                    }

                    pmsActAndPlanJsonVOList.add(pmsActAndPlanJsonVO);

                }
                pmsPersonPlanAndActualVO.setContentJson(JSON.toJSONString(pmsActAndPlanJsonVOList));

            }
        }
        Map map = new HashMap();
        map.put("column", columnDateList);
        map.put("pmsPersonPlanAndActualVOList", pmsPersonPlanAndActualVOList);
        return map;
    }

    @Override
    public PmsProjectPayload autoCreateProject(SaleConContractVO saleConContractVO) {
        PmsProjectPayload pmsProjectPayload = new PmsProjectPayload();
        log.info("11111111111-----------------");
        // 查询客户信息
        List<BusinessPartnerVO> businessPartnerVOS = businessPartnerService.queryByBookId(saleConContractVO.getCustId());
        if (!CollectionUtils.isEmpty(businessPartnerVOS)) {
            BusinessPartnerVO businessPartnerVO = businessPartnerVOS.get(0);
            pmsProjectPayload.setCustIdst(businessPartnerVO.getPartnerIndustry());
        }
        log.info("22222222222-----------------");
        pmsProjectPayload.setProjName(saleConContractVO.getName());
        PmsProjectTemplateQuery query = new PmsProjectTemplateQuery();
        if (saleConContractVO.getWorkType().equals(SaleConWorkTypeEnum.PURETRADE.getCode())) {
            query.setSuitProjectType(SaleConWorkTypeEnum.PURETRADE.getCode());
        } else {
            query.setSuitProjectType(SaleConWorkTypeEnum.INDEPENDENT.getCode());
        }
        query.setTemplateStatus(1);
        List<PmsProjectTemplateVO> pmsProjectTemplateVOS = pmsProjectTemplateService.queryListDynamic(query);
        if (!CollectionUtils.isEmpty(pmsProjectTemplateVOS)) {
            PmsProjectTemplateVO pmsProjectTemplateVO = pmsProjectTemplateVOS.get(0);
            Long subjectTemplateId = pmsProjectTemplateVO.getSubjectTemplateId();
            pmsProjectPayload.setProjTempId(pmsProjectTemplateVO.getId());// 项目模板
            pmsProjectPayload.setSubjectTempId(subjectTemplateId);
        }
        pmsProjectPayload.setPlanStartDate(saleConContractVO.getStartDate());
        pmsProjectPayload.setPlanEndDate(saleConContractVO.getEndDate());
        pmsProjectPayload.setContainsCustomerFlag(saleConContractVO.getCustBarExpense() == null ? 0 : Integer.parseInt(saleConContractVO.getCustBarExpense()));
        pmsProjectPayload.setProjStatus("ACTIVE");
        pmsProjectPayload.setCreateUserId(saleConContractVO.getDeliUserId());
        pmsProjectPayload.setRemark("系统自动生成项目");
        log.info("3333333333333333-----------------");
        pmsProjectPayload.setDeliBuId(saleConContractVO.getDeliBuId());
        pmsProjectPayload.setDeliUserId(saleConContractVO.getDeliUserId());
        pmsProjectPayload.setPmResId(saleConContractVO.getSaleManUserId());
        pmsProjectPayload.setSaleManUserId(saleConContractVO.getSaleManUserId());
        List<Long> userIds = roleService.queryUserIdByRoleCode(RoleEnum.PLAT_PMO_AID.getCode());
        if (!CollectionUtils.isEmpty(userIds)) {
            pmsProjectPayload.setPmoResId(userIds.get(0));
        }
        pmsProjectPayload.setTotalDays(BigDecimal.ZERO);
        pmsProjectPayload.setTotalEqva(BigDecimal.ZERO);
        pmsProjectPayload.setEqvaPrice(BigDecimal.valueOf(2000));
        pmsProjectPayload.setTotalCost(BigDecimal.ZERO);//项目预算总成本
        pmsProjectPayload.setTotalReimbursement(BigDecimal.ZERO);//预计总费用
        pmsProjectPayload.setContractId(saleConContractVO.getId());

        pmsProjectPayload.setEpibolyPermitFlag(0);//允许使用外包
        pmsProjectPayload.setDeposit(BigDecimal.ZERO);//最低保证金
        log.info("44444444444444-----------------");
        return pmsProjectPayload;
    }


    @Override
    public List<PmsProjectVO> queryListDynamic(PmsProjectQuery query) {
        if (query.getPermissionFlag()) {
            query.setLoginUserId(GlobalUtil.getLoginUserId());
        }
        if (!StringUtils.hasText(query.getProjStatus())) {
            query.setProjStatus(ProjectStatusEnum.ACTIVE.getCode());
        }
        List<PmsProjectVO> result = pmsProjectDAO.queryListDynamic(query);
        result.stream().forEach(e -> e.setCustName(cacheUtil.getCompanyNameByBookId(e.getCustId())));

        return result;
    }

    @Override
    public List<PmsProjectVO> queryListByReasonIdList(List<Long> reasonIdList) {
        PmsProjectQuery projectQuery = new PmsProjectQuery();
        projectQuery.setInIds(reasonIdList);
        List<PmsProjectVO> result = pmsProjectDAO.queryListDynamic(projectQuery);
        result.stream().forEach(e -> e.setCustName(cacheUtil.getCompanyNameByBookId(e.getCustId())));
        if (!CollectionUtils.isEmpty(result)) {
            List<Long> collect = result.stream().filter(vo -> vo.getContractId() != null).map(PmsProjectVO::getContractId).distinct().collect(Collectors.toList());
            //翻译合同相关数据
            tranContractData(result, collect);
        }
        return result;
    }

//    @Override
//    public List<PmsProjectVO> queryTaskAuthorizedProjectList(PmsProjectQuery query) {
//        return pmsProjectDAO.queryTaskAuthorizedProjectList(query);
//    }

    @Override
    public PmsProjectVO queryByKey(Long key) {
        PmsProjectVO vo = pmsProjectDAO.queryByKey(key);
        vo.setCustName(cacheUtil.getCompanyNameByBookId(vo.getCustId()));
        if (ObjectUtils.isEmpty(vo)) {
            throw TwException.error("", "根据主键查询不到项目详情");
        }
        if (vo.getWorkType().equals(SaleConWorkTypeEnum.OPERATION.getCode())) {
            PmsProjectReportPlanQuery queryPlan = new PmsProjectReportPlanQuery();
            queryPlan.setProjId(key);
            queryPlan.setOrders(List.of(OrderItem.asc("periodDate")));
            //获取汇报计划
            List<PmsProjectReportPlanVO> pmsProjectReportPlanVOS = pmsProjectReportPlanService.queryListDynamic(queryPlan);
            vo.setProjectReportPlanVOs(pmsProjectReportPlanVOS);
        }
        //活动管理：pmsProjectActivity/list?
        PmsProjectActivityQuery query = new PmsProjectActivityQuery();
        query.setProjId(key);
        long activityCount = projectActivityService.countListDynamic(query);
        vo.setHaveActivityFlag(activityCount > 0 ? 1 : 0);
        //成员管理：pmsProjectMembers/queryTreeByProjId
        PmsProjectMembersQuery membersQuery = new PmsProjectMembersQuery();
        membersQuery.setProjId(key);
        Long memberCount = projectMembersService.countTreeByProjId(membersQuery);
        vo.setHaveMemberFlag(memberCount > 0 ? 1 : 0);
        //资源规划：pmsResourcePlan/queryByObjId?objId=803599366769155145&planType=PROJ_CONTRACT
//        PmsResourcePlanQuery resourcePlanQuery = new PmsResourcePlanQuery();
//        resourcePlanQuery.setObjId(key);
//        resourcePlanQuery.setPlanType("PROJ_CONTRACT");
//        Long resourcePlanCount = resourcePlanService.countByObjId(resourcePlanQuery);
        PersonPlanVO personPlanVO = personPlanService.getByObjIdAndPlanType(key, Arrays.asList(PersonPlanTypeEnum.PROJECT.getCode()));


        vo.setHaveResoucePlanFlag(personPlanVO != null ? 1 : 0);
        //项目预算：budget/queryBySource?sourceId=803599366769155145&sourceType=PROJ_CONTRACT
        BudgetQuery budgetQuery = new BudgetQuery();
        budgetQuery.setSourceId(key);
        budgetQuery.setSourceType("PROJ_CONTRACT");
        Long budgetCount = budgetDAO.count(budgetQuery);
        vo.setHaveBudgetFlag(budgetCount > 0 ? 1 : 0);
        //任务：taskPackage/paging?current=1&reasonType=PROJ_CONTRACT&reasonId=803599366769155145&size=10
        TaskPackageQuery taskPackageQuery = new TaskPackageQuery();
        taskPackageQuery.setReasonId(key);
        taskPackageQuery.setReasonType("PROJ_CONTRACT");
        long taskPackageCount = taskPackageDAO.count(taskPackageQuery);
        vo.setHaveTaskFlag(taskPackageCount > 0 ? 1 : 0);
        transferData(vo);
        return vo;
    }

    @Override
    public PmsProjectVO queryByKeySimple(Long key) {
        return pmsProjectDAO.queryByKey(key);
    }

    @Override
    public List<PmsProjectVO> queryByKeysSimple(List<Long> keys) {
        return pmsProjectDAO.queryByKeys(keys);
    }

    @Override
    public PmsProjectVO querySimpleProjectByKey(Long key) {
        return pmsProjectDAO.queryByKey(key);
    }

    @Override
    public PmsProjectVO queryByContractId(Long contractId) {

        return pmsProjectDAO.queryByContractId(contractId);
    }

    @Override
    public List<PmsProjectVO> queryByContractIds(List<Long> contractIds) {
        return pmsProjectDAO.queryByContractIds(contractIds);
    }

    @Override
    public CrmCustomerOperationVO queryProjectCustomerOperation(Long key) {
        PmsProjectVO vo = pmsProjectDAO.queryByKey(key);
        if (ObjectUtils.isEmpty(vo)) {
            throw TwException.error("", "根据主键查询不到项目详情");
        }
        if (vo.getCustId() != null) {
            return customerOperationService.queryCustomerOperationByCustomerId(vo.getCustId());
        }

        return null;
    }

    /**
     * 翻译数据
     *
     * @param vo
     */
    void transferData(PmsProjectVO vo) {
        vo.setSowFilesData(fileUtil.getFileDatas(vo.getSowFiles()));
        vo.setBudgetFilesData(fileUtil.getFileDatas(vo.getBudgetFiles()));
        vo.setPerformanceFilesData(fileUtil.getFileDatas(vo.getPerformanceFiles()));
        vo.setProjectFilesData(fileUtil.getFileDatas(vo.getProjectFiles()));
        vo.setResearchFilesData(fileUtil.getFileDatas(vo.getResearchFiles()));
        vo.setOuName(cacheUtil.getCompanyNameByBookId(vo.getOuBookId()));
        vo.setCreator(cacheUtil.getUserName(vo.getCreateUserId()));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public PmsProjectVO insertOrUpdate(PmsProjectPayload payload) {
        //数据校验
        //   if (0 == payload.getInnerProjectFlag().intValue()) {
        checkData(payload);
        //    }
        Long projTempId = payload.getProjTempId();
        if (projTempId != null) {
            PmsProjectTemplateVO pmsProjectTemplateVO = pmsProjectTemplateService.queryByKey(projTempId);
            if (pmsProjectTemplateVO != null) {
                payload.setSubjectTempId(pmsProjectTemplateVO.getSubjectTemplateId());
            } else {
                throw TwException.error("", "关联项目模板数据不存在");
            }
        } else {
            throw TwException.error("", "关联项目模板不可为空");
        }
        if (payload.getId() == null) {
            //生成项目编码
            String code = generateSeqNum("PMS_PROJECT");
            payload.setProjNo(code);
            payload.setCreateUserId(GlobalUtil.getLoginUserId());
        }
        PmsProjectDO entityDo = PmsProjectConvert.INSTANCE.toDo(payload);
        entityDo = pmsProjectRepo.save(entityDo);
        Long id = entityDo.getId();
        // 外部项目创建时插入合同预算的资源规划
        if (payload.getId() == null) {
            if (payload.getContractId() != null) {
                SaleConExecConditionVO saleConExecConditionVO = saleConExecConditionService.queryByContractId(payload.getContractId());
                if (saleConExecConditionVO != null && saleConExecConditionVO.getId() != null) {
                    PersonPlanVO personPlanVO = personPlanService.getByObjIdAndPlanType(payload.getContractId(), Arrays.asList(PersonPlanTypeEnum.BUDGET.getCode()));
                    if (personPlanVO != null) {
                        PersonPlanPayload personPlanPayload = new PersonPlanPayload();
                        BeanUtils.copyProperties(personPlanVO, personPlanPayload);
                        personPlanPayload.setId(null);
                        personPlanPayload.setVersion("0");
                        personPlanPayload.setPlanType(PersonPlanTypeEnum.PROJECT.getCode());
                        personPlanPayload.setObjId(id);
                        List<PersonPlanDtlVO> personPlanDtlVOList = personPlanVO.getPersonPlanDtlVOList();
                        if (!CollectionUtils.isEmpty(personPlanDtlVOList)) {
                            List<PersonPlanDtlPayload> personPlanDtlPayloadList = new ArrayList<>();
                            personPlanDtlVOList.stream().forEach(personPlanDtlVO -> {
                                PersonPlanDtlPayload personPlanDtlPayload = new PersonPlanDtlPayload();
                                BeanUtils.copyProperties(personPlanDtlVO, personPlanDtlPayload);
                                personPlanDtlPayload.setId(null);
                                personPlanDtlPayload.setPlanId(null);
                                personPlanDtlPayloadList.add(personPlanDtlPayload);
                            });
                            personPlanPayload.setPersonPlanDtlPayloadList(personPlanDtlPayloadList);
                        }
                        personPlanService.save(personPlanPayload);
                    }
                }
            }
        }
        if (!ObjectUtils.isEmpty(payload.getProjectReportPlanPayloads())) {
            // 保存项目汇报计划
            payload.getProjectReportPlanPayloads().forEach(reportPlan -> {
                if (reportPlan.getPeriodDate() == null) {
                    throw TwException.error("", "汇报期间不可为空");
                }
                reportPlan.setProjId(id);
            });
            //获取汇报期间本月第一天的数据
            List<LocalDate> collect1 = payload.getProjectReportPlanPayloads().stream().map(planPayload -> planPayload.getPeriodDate().with(TemporalAdjusters.firstDayOfMonth())).distinct().collect(Collectors.toList());
            if (collect1.size() < payload.getProjectReportPlanPayloads().size()) {
                throw TwException.error("", "汇报期间不可重复");
            }
            pmsProjectReportPlanService.batchInsert(payload.getProjectReportPlanPayloads());
        }
        if (!ObjectUtils.isEmpty(payload.getDelReportPlanIds())) {
            pmsProjectReportPlanService.deleteSoft(payload.getDelReportPlanIds());
        }
        if (payload.getId() == null) {
            //创建项目账户
            createAccount(entityDo);
        }
        return PmsProjectConvert.INSTANCE.toVo(entityDo);
    }

    /**
     * 创建项目账户
     *
     * @param entityDo
     */
    void createAccount(PmsProjectDO entityDo) {
        CalAccountPayload accountPayload = new CalAccountPayload();
        accountPayload.setAuType(CalAccTypeEnum.PROJ.getCode());
        accountPayload.setAuId(entityDo.getId());
        accountPayload.setLedgerName(entityDo.getProjName());
        accountPayload.setLedgerNo(entityDo.getProjNo());
        calAccountService.insert(accountPayload);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateProjStatus(Long key, String projStatus, Long pmResId) {
        PmsProjectPayload projectPayload = new PmsProjectPayload();
        projectPayload.setId(key);
        projectPayload.setProjStatus(projStatus);
        if (!ObjectUtils.isEmpty(pmResId)) {
            projectPayload.setPmResId(pmResId);
        }
        long l = pmsProjectDAO.updateByKeyDynamic(projectPayload);
        if (projStatus.equals(ProjectStatusEnum.ACTIVE.getCode())) {
            //初始化项目成员
            PmsProjectVO pmsProjectVO = pmsProjectDAO.queryByKey(key);
            //开启事务执行修改
            transactionUtilService.executeWithRunnable(() -> {
                //自动补充历史期间项目汇报
                pmsProjectBriefService.autoSupplementBierf(key);

                Set<Long> userIds = new HashSet<>();
                if (pmsProjectVO.getDeliUserId() != null) {
                    userIds.add(pmsProjectVO.getDeliUserId());
                }
                if (pmsProjectVO.getPmoResId() != null) {
                    userIds.add(pmsProjectVO.getPmoResId());
                }
                if (pmsProjectVO.getPmResId() != null) {
                    userIds.add(pmsProjectVO.getPmResId());
                }
                if (pmsProjectVO.getSuperResId() != null) {
                    userIds.add(pmsProjectVO.getSuperResId());
                }
                List<PmsProjectMembersDO> pmsProjectMembersDOs = new ArrayList<>();
                userIds.forEach(userId -> {
                    PmsProjectMembersDO membersDO = new PmsProjectMembersDO();
                    membersDO.setProjId(key);
                    membersDO.setResId(userId);
                    membersDO.setWorkbenchFlag(1);
                    pmsProjectMembersDOs.add(membersDO);
                });
                pmsProjectMembersDAO.saveAll(pmsProjectMembersDOs);
            });
            // 创建项目立项泛用结算单
            createProjInitWideSettle(pmsProjectVO, null);
        }
        return l;
    }

    @Override
    public void initWideSettle() {
        PmsProjectQuery query = new PmsProjectQuery();
        query.setProjStatusType("1");
        query.setProjStatus(ProjectStatusEnum.ACTIVE.getCode());
        List<PmsProjectVO> pmsProjectVOS = pmsProjectDAO.queryListDynamic(query);
        pmsProjectVOS.forEach(vo -> {
            createProjInitWideSettle(vo, vo.getCreateTime().toLocalDate());
        });
    }

    /**
     * 项目立项创建泛用结算单
     *
     * @param pmsProjectVO
     */
    void createProjInitWideSettle(PmsProjectVO pmsProjectVO, LocalDate date) {
        CalWideSettlePayload settlePayload = new CalWideSettlePayload();
        settlePayload.setSettleStatus(CalSettleStatusEnum.FINISH.getCode());
        settlePayload.setSettleType(CalAccTurTypeEnum.PROJ_INIT.getCode());
        settlePayload.setSettleDate(date == null ? LocalDate.now() : date);
        settlePayload.setFromSourceType(CalAccTypeEnum.BU.getCode());
        settlePayload.setFromSourceId(pmsProjectVO.getDeliBuId());
        settlePayload.setFromSourceName(cacheUtil.getOrgName(pmsProjectVO.getDeliBuId()));
        settlePayload.setToSourceType(CalAccTypeEnum.PROJ.getCode());
        settlePayload.setToSourceId(pmsProjectVO.getId());
        settlePayload.setToSourceName(pmsProjectVO.getProjName());
        settlePayload.setApplySettleEqva(pmsProjectVO.getTotalEqva());
        settlePayload.setSettlePrice(pmsProjectVO.getEqvaPrice());
        settlePayload.setApplySettleAmt(pmsProjectVO.getTotalEqva().multiply(pmsProjectVO.getEqvaPrice()));
        settlePayload.setIsSubmit(1);
        calWideSettleService.insertOrUpdate(settlePayload);
    }

    /**
     * 项目结项创建泛用结算单
     *
     * @param projectId 项目主键
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void createProjFinishWideSettle(Long projectId) {
        PmsProjectVO pmsProjectVO = pmsProjectDAO.queryByKey(projectId);
        CalAccountVO calAccountVO = calAccountService.queryByAuTypeAndAuId(CalAccTypeEnum.PROJ.getCode(), pmsProjectVO.getId());
        BigDecimal avalQty = calAccountVO.getAvalQty() == null ? BigDecimal.ZERO : calAccountVO.getAvalQty();
        BigDecimal avalAmt = calAccountVO.getAvalAmt() == null ? BigDecimal.ZERO : calAccountVO.getAvalAmt();
        if (avalQty.compareTo(BigDecimal.ZERO) > 0 || avalAmt.compareTo(BigDecimal.ZERO) > 0) {
            //创建泛用当量结算单
            CalWideSettlePayload settlePayload = new CalWideSettlePayload();
            settlePayload.setSettleStatus(CalSettleStatusEnum.FINISH.getCode());
            settlePayload.setSettleType(CalAccTurTypeEnum.PROJ_FINISH.getCode());
            settlePayload.setSettleDate(LocalDate.now());
            settlePayload.setFromSourceType(CalAccTypeEnum.PROJ.getCode());
            settlePayload.setFromSourceId(pmsProjectVO.getId());
            settlePayload.setFromSourceName(pmsProjectVO.getProjName());
            settlePayload.setToSourceType(CalAccTypeEnum.BU.getCode());
            settlePayload.setToSourceId(pmsProjectVO.getDeliBuId());
            settlePayload.setToSourceName(cacheUtil.getOrgName(pmsProjectVO.getDeliBuId()));
            settlePayload.setApplySettleEqva(avalQty);
            settlePayload.setSettlePrice(pmsProjectVO.getEqvaPrice());
            settlePayload.setApplySettleAmt(avalAmt);
            settlePayload.setIsSubmit(1);
            //创建单据数据
            calWideSettleService.insertOrUpdate(settlePayload);
        }
//        //关闭项目账户
        //关闭账户后无法结算
//        calAccountService.closeAccount(calAccountVO.getId());
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateProjectStatus(Long projectId) {
        PmsProjectVO pmsProjectVO = pmsProjectDAO.queryByKey(projectId);
        String status = ProjectStatusEnum.ACTIVE.getCode();
        if (pmsProjectVO.getProjStatus().equals(ProjectStatusEnum.ACTIVE.getCode()) || pmsProjectVO.getProjStatus().equals(ProjectStatusEnum.PENDING.getCode())) {
            if (pmsProjectVO.getProjStatus().equals(ProjectStatusEnum.ACTIVE.getCode())) {
                status = ProjectStatusEnum.PENDING.getCode();
            }
            pmsProjectDAO.updateProjStatus(projectId, status);
        } else {
            throw TwException.error("", "不支持的状态修改");
        }

    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateProjectCloseStatus(List<Long> projectIds, String status) {
        pmsProjectDAO.updateProjStatuss(projectIds, status);
    }

    /**
     * 数据校验
     *
     * @param payload
     */
    void checkData(PmsProjectPayload payload) {
        if (payload.getContractId() == null) {
            throw TwException.error("", "创建项目主文件时,子合同不能为空");
        }
        if (payload.getEqvaPrice() == null) {
            throw TwException.error("", "当量预估单价不能为空");
        }
        PmsProjectVO pmsProjectVO = pmsProjectDAO.queryByContractId(payload.getContractId());
        if (pmsProjectVO != null) {
            if (payload.getId() == null || !payload.getId().equals(pmsProjectVO.getId())) {
                throw TwException.error("", "子合同已创建项目主文件,不可重复创建");
            }
            //项目经理
            Long pmResId = payload.getPmResId();
            Long loginUserId = GlobalUtil.getLoginUserId();
            if (!pmResId.equals(loginUserId) && !pmsProjectVO.getProjStatus().equals(ProjectStatusEnum.CREATE.getCode()) && !pmsProjectVO.getProjStatus().equals(ProjectStatusEnum.APPROVING.getCode())) {
                throw TwException.error("", "仅支持新建状态或派发中的修改");
            }
            payload.setId(pmsProjectVO.getId());
            payload.setProjStatus(pmsProjectVO.getProjStatus());
            payload.setCreateTime(pmsProjectVO.getCreateTime());
            payload.setCreateUserId(pmsProjectVO.getCreateUserId());
        } else {
            payload.setId(null);
            payload.setProjStatus(payload.getProjStatus() == null ? ProjectStatusEnum.CREATE.getCode() : payload.getProjStatus());

            SaleConContractVO saleConContractVO = pmsProjectDAO.querySaleConContractBySaleConId(payload.getContractId());
            if (saleConContractVO == null) {
                throw TwException.error("", "子合同不存在,请核验！");
            }
            //为项目赋值合同相关数据
            payload.setDeliBuId(saleConContractVO.getDeliBuId());
            payload.setDeliUserId(saleConContractVO.getDeliUserId());
            payload.setSaleManUserId(saleConContractVO.getSaleManUserId());
            payload.setSignBuId(saleConContractVO.getSignBuId());
        }
        payload.setAutoReportFlag(0);
        if (payload.getTotalEqva() == null) {
            payload.setTotalEqva(BigDecimal.ZERO);
        }
        if (payload.getTotalCost() == null) {
            payload.setTotalCost(BigDecimal.ZERO);
        }
        if (payload.getTotalReimbursement() == null) {
            payload.setTotalReimbursement(BigDecimal.ZERO);
        }
    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(PmsProjectPayload payload) {
        //数据校验
        //checkData(payload);
        PmsProjectVO pmsProjectVO = pmsProjectDAO.queryByKey(payload.getId());
        if (pmsProjectVO != null) {
            // if (pmsProjectVO.getProjStatus().equals(ProjectStatusEnum.CREATE.getCode()) || pmsProjectVO.getProjStatus().equals(ProjectStatusEnum.ACTIVE.getCode())) {
            //核验风险等级 如果由高等级改为其他等级要判断是否以超过预计上线日期并且累计收款比例大于50%
            checkDataRiskLevel(pmsProjectVO, payload);
            if (pmsProjectVO.getNoContractFlag() != null && pmsProjectVO.getNoContractFlag().equals(1)) {
                //说明从项目待更新的代办进行更新的,重新产生预算待更新代办（暂时不考虑预算代办所以直接改为0）
                payload.setNoContractFlag(0);
            }
            long result = pmsProjectDAO.updateByKeyDynamic(payload);
            return result;
//            } else {
//                throw TwException.error("", "不支持修改操作,请核验！");
//            }
        } else {
            throw TwException.error("", "操作数据不存在,请核验！");
        }

    }

    /**
     * 核验风险等级
     *
     * @param pmsProjectVO
     * @param payload
     */
    void checkDataRiskLevel(PmsProjectVO pmsProjectVO, PmsProjectPayload payload) {
        if (pmsProjectVO.getPlanOnlineDate() != null && pmsProjectVO.getPlanOnlineDate().isBefore(LocalDate.now())) {
            if (StringUtils.hasText(pmsProjectVO.getRiskLevel()) && pmsProjectVO.getRiskLevel().equals(ProjectRiskLevelEnum.RISK9.getCode())) {
                if (StringUtils.hasText(payload.getRiskLevel()) && !payload.getRiskLevel().equals(ProjectRiskLevelEnum.RISK9.getCode())) {
                    ConReceivablePlanQuery queryReceivablePlan = new ConReceivablePlanQuery();
                    queryReceivablePlan.setSaleConId(pmsProjectVO.getContractId());
                    //收款计划
                    List<ConReceivablePlanVO> recvPlanViews = conReceivablePlanService.queryListDynamic(queryReceivablePlan);
                    // 计算应收款金额
                    BigDecimal receAmt = recvPlanViews.stream()
                            .map(ConReceivablePlanVO::getReceAmt)
                            .filter(Objects::nonNull)
                            .reduce(BigDecimal::add)
                            .orElse(BigDecimal.ZERO);
                    // 计算实际收款金额
                    BigDecimal actualReceivedAmt = recvPlanViews.stream()
                            .map(ConReceivablePlanVO::getActualRecvAmt)
                            .filter(Objects::nonNull)
                            .reduce(BigDecimal::add)
                            .orElse(BigDecimal.ZERO);

                    //合同总金额
                    BigDecimal actualReceivedRate = BigDecimal.ZERO;
                    if (BigDecimal.ZERO.compareTo(receAmt) != 0) {
                        actualReceivedRate = actualReceivedAmt.divide(receAmt, 4, RoundingMode.HALF_UP).movePointRight(2);
                    }
                    if (BigDecimal.ZERO.compareTo(receAmt) != 0 && actualReceivedRate.compareTo(BigDecimal.valueOf(50)) < 0) {
                        throw TwException.error("", "风险等级不可修改");
                    }
                }
            }
        }

    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                pmsProjectDAO.deleteSoft(keys);
            });
        }
    }

    @Override
    public List<PmsProjectVO> queryProjectBriefWork(Long userId) {
        if (userId == null) {
            userId = GlobalUtil.getLoginUserId();
        }
        int dayOfMonth = LocalDate.now().getDayOfMonth();
        //每月15号提醒
        if (dayOfMonth >= briefDate) {
            List<String> workTypes = Arrays.asList(SaleConWorkTypeEnum.DELIVERY.getCode(), SaleConWorkTypeEnum.DEVELOP.getCode());
            List<Long> platPmoAidUsers = systemRoleDAO.queryUserIdByRoleCodes(Arrays.asList(RoleEnum.PLAT_PMO_AID.getCode()));
            PmsProjectQuery query = new PmsProjectQuery();
            query.setWorkTypes(workTypes);
            query.setBriefWorkFlag(true);
            query.setProjStatus(ProjectStatusEnum.ACTIVE.getCode());
            query.setProjStatusType("1");
            if (CollectionUtils.isEmpty(platPmoAidUsers) || !platPmoAidUsers.contains(userId)) {
                query.setLoginUserId(userId);
            }
            List<PmsProjectVO> pmsProjectVOS = pmsProjectDAO.projectBriefWork(query);
            if (!ObjectUtils.isEmpty(pmsProjectVOS)) {
                List<Long> delProjectIds = new ArrayList<>();
                LocalDate localDate = LocalDate.now();
                List<Long> collect = pmsProjectVOS.stream().map(PmsProjectVO::getId).collect(Collectors.toList());
                List<PmsProjectBriefVO> pmsProjectBriefVOS = pmsProjectBriefService.projectBriefWork(collect);
                if (!ObjectUtils.isEmpty(pmsProjectBriefVOS)) {
                    List<String> processStatus = Arrays.asList("CLOSED", "END");
                    pmsProjectBriefVOS.forEach(briefVO -> {
                        int i = DateUtil.differenceMonth(briefVO.getFinPeriodDate(), localDate);
                        if (i < 1) {
                            //只要不是应本月汇报的都要提示
                            delProjectIds.add(briefVO.getProjId());
                        } else {
                            // 删除项目进度状态=结项or终止 并且 累计进度百分比=100%
                            if (processStatus.contains(briefVO.getProjProcessStatus()) && BigDecimal.valueOf(100).compareTo(briefVO.getReprotCompPercent()) == 0) {
                                delProjectIds.add(briefVO.getProjId());
                            }
                        }
                    });
                }
                if (delProjectIds.size() > 0) {
                    pmsProjectVOS = pmsProjectVOS.stream().filter(vo -> !delProjectIds.contains(vo.getId())).collect(Collectors.toList());
                }
                return pmsProjectVOS;
            }
        }
        return null;
    }

    @Override
    public List<PmsProjectVO> queryProjectUpdateWork() {
        Long userId = GlobalUtil.getLoginUserId();
        PmsProjectQuery query = new PmsProjectQuery();
        query.setDeliUserId(userId);
        query.setNoContractFlag(1);
        return pmsProjectDAO.queryProjectUpdateWork(query);
    }

    @Override
    public long queryProjectUpdateWorkCount(Long userId) {
        PmsProjectQuery query = new PmsProjectQuery();
        query.setDeliUserId(userId);
        query.setNoContractFlag(1);
        return pmsProjectDAO.count0(query);

    }

    @Override
    public long queryProjectUpdateBudgetWorkCount(Long userId) {
        PmsProjectQuery query = new PmsProjectQuery();
        query.setPmResId(userId);
        query.setNoContractFlag(2);
        return pmsProjectDAO.count1(query);
    }

    @Override
    public List<PmsProjectVO> queryProjectUpdateBudgetWork() {
        Long userId = GlobalUtil.getLoginUserId();
        PmsProjectQuery query = new PmsProjectQuery();
        query.setPmResId(userId);
        query.setNoContractFlag(2);
        return pmsProjectDAO.queryProjectUpdateBudgetWork(query);
    }


    @Override
    public PmsProjectVO updateChange(PmsProjectPayload payload) {
        PmsProjectVO pmsProjectVO = pmsProjectDAO.queryByKey(payload.getId());
        if (!ObjectUtils.isEmpty(pmsProjectVO)) {
            if (pmsProjectVO.getProjStatus().equals(ProjectStatusEnum.ACTIVE.getCode())) {
                if (pmsProjectVO.getChangeFlag() == null || pmsProjectVO.getChangeFlag() == 0) {
                    pmsProjectVO = (PmsProjectVO) udcUtil.translate(pmsProjectVO);
                    // PmsProjectPayload oldPayload =
                    // .INSTANCE.toPayload(pmsProjectVO);

                    PmsProjectVO newPmsProjectVO = new PmsProjectVO();
                    BeanCopyUtil.beanCopy(pmsProjectVO, newPmsProjectVO);
                    newPmsProjectVO.setPlanEndDate(payload.getPlanEndDate());
                    newPmsProjectVO.setPlanStartDate(payload.getPlanStartDate());
                    newPmsProjectVO.setPlanOnlineDate(payload.getPlanOnlineDate());
                    //是否更改项目经理
                    Boolean isUpdatePm = false;
                    if (payload.getPmResId() != null && payload.getPmResId().longValue() != pmsProjectVO.getPmResId().longValue()) {
                        isUpdatePm = true;
                        newPmsProjectVO.setPmResId(payload.getPmResId());
                        newPmsProjectVO.setPmResName(cacheUtil.getUserName(payload.getPmResId()));
                    }
                    //处理运维项目获取计划变更
                    if (pmsProjectVO.getWorkType().equals(SaleConWorkTypeEnum.OPERATION.getCode())) {
                        PmsProjectReportPlanQuery queryPlan = new PmsProjectReportPlanQuery();
                        queryPlan.setProjId(payload.getId());
                        //获取汇报计划
                        List<PmsProjectReportPlanVO> pmsProjectReportPlanVOS = pmsProjectReportPlanService.queryListDynamic(queryPlan);
                        if (!ObjectUtils.isEmpty(pmsProjectReportPlanVOS)) {
                            pmsProjectVO.setProjectReportPlanVOs(pmsProjectReportPlanVOS);
                            //如果计划没发生变更直接赋值老数据
                            if (ObjectUtils.isEmpty(payload.getProjectReportPlanPayloads())) {
                                newPmsProjectVO.setProjectReportPlanVOs(pmsProjectReportPlanVOS);
                            } else {
                                newPmsProjectVO.setProjectReportPlanVOs(PmsProjectReportPlanConvert.INSTANCE.toVOs(payload.getProjectReportPlanPayloads()));
                                //合同总金额
                                BigDecimal amt = pmsProjectVO.getSumAmt() == null ? BigDecimal.ZERO : pmsProjectVO.getSumAmt();
                                //税率
                                BigDecimal taxRate = pmsProjectVO.getTaxRate() == null ? BigDecimal.ZERO : pmsProjectVO.getTaxRate();
                                //不含税总金额
                                BigDecimal notTaxAmt = amt.divide(BigDecimal.ONE.add(taxRate), 2, RoundingMode.HALF_UP);
                                //核验数据
                                checkUpdateReportPlan(pmsProjectReportPlanVOS, payload, notTaxAmt);
                                //赋值要删除的数据
                                newPmsProjectVO.setDelReportPlanIds(payload.getDelReportPlanIds());
                            }

                        }
                    }
                    //保存变更数据
                    Long saveId = changeService.save(ChangeTypeEnum.PMS_PROJECT_CHANGE.getCode(), pmsProjectVO, newPmsProjectVO, payload.getId() + "");
                    //发起工作流
                    ProcessInfo processInfo = startChangeWorkFlow(pmsProjectVO, saveId, isUpdatePm);
                    int changeFlag = 1;
                    String changeStatus = WorkFlowStatusEnum.APPROVING_WORK.getCode();
                    if (processInfo.getProcInstStatus().name().equals(ProcInstStatus.APPROVED.name())) {
                        changeFlag = 0;
                        changeStatus = WorkFlowStatusEnum.APPROVED_WORK.getCode();
                    }
                    PmsProjectPayload payload0 = new PmsProjectPayload();
                    payload0.setId(payload.getId());
                    payload0.setChangeFlag(changeFlag);

                    ComChangePayload changePayload = new ComChangePayload();
                    changePayload.setId(saveId);
                    changePayload.setProcInstId(processInfo.getProcInstId());
                    changePayload.setApprStatus(processInfo.getProcInstStatus().name());
                    changePayload.setChangeStatus(changeStatus);
                    //开启事务执行修改，主要是修改审批状态
                    transactionUtilService.executeWithRunnable(() -> {
                        pmsProjectDAO.updateByKeyDynamic(payload0);
                        changeService.updateWorkFlow(changePayload);
                    });
                } else {
                    throw TwException.error("", "变更中的项目不能重复发起变更");
                }
            } else {
                throw TwException.error("", "激活项目才可以发起变更");
            }

        } else {
            throw TwException.error("", "变更数据不存在，请核验！");
        }

        return null;
    }

    /**
     * 核验计划变更
     *
     * @param pmsProjectReportPlanVOS
     * @param payload
     */
    void checkUpdateReportPlan(List<PmsProjectReportPlanVO> pmsProjectReportPlanVOS, PmsProjectPayload payload, BigDecimal notTaxAmt) {
        List<Long> delReportPlanIds = new ArrayList<>();

        pmsProjectReportPlanVOS.forEach(oldPlan -> {
            Optional<PmsProjectReportPlanPayload> first = payload.getProjectReportPlanPayloads().stream().filter(newPlan -> DateUtil.differenceMonth(newPlan.getPeriodDate(), oldPlan.getPeriodDate()) == 0).findFirst();
            if (first.isPresent()) {
                PmsProjectReportPlanPayload newPlanPayload = first.get();
                newPlanPayload.setId(oldPlan.getId());
                if (oldPlan.getBriefId() != null) {
                    //表示已经生成过汇报
                    if (oldPlan.getAmt().compareTo(newPlanPayload.getAmt()) != 0) {
                        throw TwException.error("", "已生成项目汇报计划金额不能变更");
                    }
                    newPlanPayload.setBriefId(oldPlan.getBriefId());
                    newPlanPayload.setBriefNo(oldPlan.getBriefNo());
                }
            } else {
                if (oldPlan.getBriefId() != null) {
                    throw TwException.error("", "已生成项目汇报计划不可删除");
                }
                delReportPlanIds.add(oldPlan.getId());
            }
        });
        //赋值待删除的计划ids
        payload.setDelReportPlanIds(delReportPlanIds);
        //核验金额
        checkReportPlan(notTaxAmt, payload.getProjectReportPlanPayloads());
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void processStatusChange(ProcessStatusChangePayload payload) {
        String businessKey = payload.getBusinessKey();
        ProcInstStatus procInstStatus = payload.getProcInstStatus();
//        PmsProjectPayload PmsProjectPayload = new PmsProjectPayload();
//        PmsProjectPayload.setId(Long.parseLong(businessKey));
        //根据业务key查询当前业务对象

        //根据业务key查询当前业务对象
        ComChangeVO comChangeVO = changeService.queryByKey(Long.valueOf(businessKey));
        if (comChangeVO != null) {
            PmsProjectVO projectVO = new PmsProjectVO();
            projectVO.setId(Long.valueOf(comChangeVO.getChangeDocId()));

            ComChangePayload changePayload = new ComChangePayload();
            changePayload.setId(comChangeVO.getId());
            changePayload.setApprStatus(procInstStatus.name());
            changePayload.setProcInstId(comChangeVO.getProcInstId());
            switch (procInstStatus) {
                case NOTSUBMIT://创建人提交节点
                    //一般情况将单据状态变成"新建",流程状态改为未提交
                    changePayload.setChangeStatus(WorkFlowStatusEnum.NOTSUBMIT.getCode());
                    break;
                case INTERRUPT://中断（删除工作流，初始化单据，管理员操作）
                    //一般情况将单据状态变成"草稿",并且将单据上的"流程实例状态"，"流程实例ID"清成null(不是空字符串)
                    changePayload.setChangeStatus(WorkFlowStatusEnum.CREATE_WORK.getCode());
                    changePayload.setProcInstId(null);
                    projectVO.setChangeFlag(0);
                    updateWorkFlow(projectVO);
                    break;
                case INVALID://先删除流程再删除单据
                    //一般情况将单据状态变成"新建",并且将单据上的"流程实例状态"，"流程实例ID"清成null
                    changePayload.setChangeStatus(WorkFlowStatusEnum.CREATE_WORK.getCode());
                    changePayload.setProcInstId(null);
                    changePayload.setDeleteFlag(1);
                    projectVO.setChangeFlag(0);
                    //projectVO.setDeleteFlag(1);
                    updateWorkFlow(projectVO);
                    break;
                case REJECTED://审批人拒绝，回到第一个节点
                    changePayload.setChangeStatus(WorkFlowStatusEnum.REJECTED_WORK.getCode());
                    break;
                case APPROVED:
                    projectVO = JSON.parseObject(comChangeVO.getChangeContent(), PmsProjectVO.class);
                    projectVO.setChangeFlag(0);
                    changePayload.setChangeStatus(WorkFlowStatusEnum.APPROVED_WORK.getCode());
                    updateWorkFlow(projectVO);
                    break;
                case APPROVING:
                    break;
            }
            changeService.updateWorkFlow(changePayload);

        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void projectJobHandler() {
        PmsProjectQuery query = new PmsProjectQuery();
        query.setProjStatus(ProjectStatusEnum.ACTIVE.getCode());
        query.setPlanOnlineDate(LocalDate.now());
        List<PmsProjectVO> pmsProjectVOS = pmsProjectDAO.queryListDynamic(query);
        if (!ObjectUtils.isEmpty(pmsProjectVOS)) {
            Map<Long, PmsProjectVO> projectVOMap = pmsProjectVOS.stream().collect(Collectors.toMap(PmsProjectVO::getContractId, Function.identity()));
            ConReceivablePlanQuery queryReceivablePlan = new ConReceivablePlanQuery();
            queryReceivablePlan.setSaleConIds(new ArrayList<>(projectVOMap.keySet()));
            //累计收款比例达到 50% 后，下架项目风险等级为高的标识，展示为“-”
            List<Long> updateNullIds = new ArrayList<>();
            //交付项目：若到预计上线日期当天，关联的收款阶段累计收款比例未到达50%，则项目列表中的该项目风险等级自动标识为高（红色）
            List<Long> updateHighIds = new ArrayList<>();
            //收款计划
            List<ConReceivablePlanVO> recvPlanViewVOs = conReceivablePlanService.queryListDynamic(queryReceivablePlan);
            if (!ObjectUtils.isEmpty(recvPlanViewVOs)) {
                Map<Long, List<ConReceivablePlanVO>> collect = recvPlanViewVOs.stream().collect(Collectors.groupingBy(ConReceivablePlanVO::getSaleConId));
                collect.entrySet().stream().forEach(entry -> {
                    List<ConReceivablePlanVO> recvPlanViews = entry.getValue();
                    // 计算应收款金额
                    BigDecimal receAmt = recvPlanViews.stream()
                            .map(ConReceivablePlanVO::getReceAmt)
                            .filter(Objects::nonNull)
                            .reduce(BigDecimal::add)
                            .orElse(BigDecimal.ZERO);

                    // 计算实际收款金额
                    BigDecimal actualReceivedAmt = recvPlanViews.stream()
                            .map(ConReceivablePlanVO::getActualRecvAmt)
                            .filter(Objects::nonNull)
                            .reduce(BigDecimal::add)
                            .orElse(BigDecimal.ZERO);

                    // 计算实际收款百分比
                    BigDecimal actualReceivedRate = BigDecimal.ZERO;
                    if (BigDecimal.ZERO.compareTo(receAmt) != 0) {
                        actualReceivedRate = actualReceivedAmt.divide(receAmt, 4, RoundingMode.HALF_UP).movePointRight(2);
                    }
                    //对高风险的项目置为低风险
                    PmsProjectVO pmsProjectVO = projectVOMap.get(entry.getKey());
                    if (BigDecimal.ZERO.compareTo(receAmt) == 0 || actualReceivedRate.compareTo(BigDecimal.valueOf(50)) >= 0) {
                        if (StringUtils.hasText(pmsProjectVO.getRiskLevel()) && pmsProjectVO.getRiskLevel().equals(ProjectRiskLevelEnum.RISK9.getCode())) {
                            updateNullIds.add(pmsProjectVO.getId());
                        }
                    } else {
                        if (!StringUtils.hasText(pmsProjectVO.getRiskLevel()) || !pmsProjectVO.getRiskLevel().equals(ProjectRiskLevelEnum.RISK9.getCode())) {
                            updateHighIds.add(pmsProjectVO.getId());
                        }
                    }
                });
            }
            if (updateNullIds.size() > 0) {
                pmsProjectDAO.updateRiskLevel(updateNullIds, "");
            }
            if (updateHighIds.size() > 0) {
                pmsProjectDAO.updateRiskLevel(updateHighIds, ProjectRiskLevelEnum.RISK9.getCode());
            }
        }
    }

    @Override
    public void updateNoContractData(PmsProjectPayload payload) {
        if (payload.getId() != null) {
            PmsProjectVO pmsProjectVO = pmsProjectDAO.queryByKey(payload.getId());
            if (pmsProjectVO != null) {
                Long loginUserId = GlobalUtil.getLoginUserId();
                if (loginUserId.equals(pmsProjectVO.getDeliUserId())) {
                    if (payload.getNoContractFlag() == null || payload.getNoContractFlag() != 0) {
                        //项目预算需变更提示
                        payload.setNoContractFlag(2);
                    } else {
                        payload.setNoContractFlag(0);
                    }
                    pmsProjectDAO.updateByKeyDynamic(payload);
                } else {
                    throw TwException.error("", "无操无合同入场虚拟合同项目数据变更的权限！");
                }

            } else {
                throw TwException.error("", "变更数据不存在");
            }

        } else {
            throw TwException.error("", "项目id不可为空");
        }
    }

    @Override
    public void updateBudgetAfterUpdateProject(Long key) {
        PmsProjectVO pmsProjectVO = pmsProjectDAO.queryByKey(key);
        if (pmsProjectVO != null && pmsProjectVO.getNoContractFlag() != null && pmsProjectVO.getNoContractFlag() != 0) {
            PmsProjectPayload payload = new PmsProjectPayload();
            payload.setId(key);
            payload.setNoContractFlag(0);
            pmsProjectDAO.updateByKeyDynamic(payload);
        }

    }

    @Override
    public void noContractActivity(Long contractId) {
        PmsProjectVO pmsProjectVO = pmsProjectDAO.queryByContractId(contractId);
        if (pmsProjectVO != null) {
            PmsProjectPayload payload = new PmsProjectPayload();
            payload.setId(pmsProjectVO.getId());
            payload.setNoContractFlag(1);

            pmsProjectDAO.updateByKeyDynamic(payload);
        }
    }

    @Override
    public List<PmsProjectVO> queryListByProjectMember(Long userId, Boolean selectAll) {
        if (userId == null) {
            userId = GlobalUtil.getLoginUserId();
        }
        PmsProjectQuery query = new PmsProjectQuery();
        query.setLoginUserId(userId);
        if (selectAll != null && selectAll) {
            List<String> strings = Arrays.asList(ProjectStatusEnum.ACTIVE.getCode(), ProjectStatusEnum.PENDING.getCode(), ProjectStatusEnum.CLOSING.getCode(), ProjectStatusEnum.CLOSED.getCode(), ProjectStatusEnum.OVERDUE_ACCOUNTS.getCode());
            query.setProjStatusList(strings);
        } else {
            query.setProjStatus(ProjectStatusEnum.ACTIVE.getCode());
        }

        List<PmsProjectVO> pmsProjectVOS = pmsProjectDAO.queryProjectListByMemberId(query);
        if (!CollectionUtils.isEmpty(pmsProjectVOS)) {
            pmsProjectVOS.stream().forEach(e -> e.setCustName(cacheUtil.getCompanyNameByBookId(e.getCustId())));
            List<Long> collect = pmsProjectVOS.stream().filter(vo -> vo.getContractId() != null).map(PmsProjectVO::getContractId).distinct().collect(Collectors.toList());
            tranContractData(pmsProjectVOS, collect);
        }
        return pmsProjectVOS;
    }

    @Override
    public PmsProjectVO findIdByNo(String projectNo) {
        return pmsProjectDAO.findIdByNo(projectNo);
    }

    @Override
    public long countByCustomerId(Long customerId) {
        PmsProjectQuery query = new PmsProjectQuery();
        query.setCustomerId(customerId);
        query.setMainType("SUB");
        return pmsProjectDAO.count(query);
    }


    /**
     * 核验计划金额
     *
     * @param notTaxAmt
     * @param projectReportPlanPayloads
     */
    void checkReportPlan(BigDecimal notTaxAmt, List<PmsProjectReportPlanPayload> projectReportPlanPayloads) {
//        // 总计划金额金额
//        BigDecimal invoicedAmt = projectReportPlanPayloads.stream()
//                .map(PmsProjectReportPlanPayload::getAmt)
//                .filter(Objects::nonNull)
//                .reduce(BigDecimal::add)
//                .orElse(BigDecimal.ZERO);
//        if (notTaxAmt.subtract(invoicedAmt).abs().compareTo(BigDecimal.ONE) > 0) {
//            throw TwException.error("", "总计划金额和合同不含税金额不等");
//        }
    }

    /**
     * 更新数据
     *
     * @param projectVO
     */
    public void updateWorkFlow(PmsProjectVO projectVO) {
        PmsProjectPayload payload = PmsProjectConvert.INSTANCE.toPayload(projectVO);
        List<PmsProjectReportPlanVO> projectReportPlanVOs = projectVO.getProjectReportPlanVOs();
        List<PmsProjectReportPlanPayload> projectReportPlanPayloads = PmsProjectReportPlanConvert.INSTANCE.toPayloads(projectReportPlanVOs);
        payload.setProjectReportPlanPayloads(projectReportPlanPayloads);
        //项目更新
        pmsProjectDAO.updateByKeyDynamic(payload);
        //先删除老计划再重新生成新的计划
        if (!ObjectUtils.isEmpty(payload.getDelReportPlanIds())) {
            pmsProjectReportPlanService.deleteSoft(payload.getDelReportPlanIds());
        }
        if (!ObjectUtils.isEmpty(payload.getProjectReportPlanPayloads())) {
            // 保存项目汇报计划
            payload.getProjectReportPlanPayloads().forEach(reportPlan -> {
                reportPlan.setProjId(payload.getId());
            });
            pmsProjectReportPlanService.batchInsert(payload.getProjectReportPlanPayloads());
        }
    }

    /**
     * 新建变更工作流
     *
     * @param pmsProjectVO
     * @return
     */
    private ProcessInfo startChangeWorkFlow(PmsProjectVO pmsProjectVO, Long saveId, Boolean isUpdatePm) {
        List<Long> userIds = roleService.queryUserIdByRoleCode(RoleEnum.PROJ_CHANGE_FINANCE_APPROVER.getCode());
        if (ObjectUtils.isEmpty(userIds)) {
            throw TwException.error("", "财务审批角色人员不存在");
        }
        HashMap<String, Object> batchMap = new HashMap<>();
        //财务角色
        batchMap.put("Activity_0xnrn8j", Lists.newArrayList(userIds));
        // 交付Bu负责人
        PrdOrgOrganizationVO org = cacheUtil.getOrg(pmsProjectVO.getDeliBuId());
        batchMap.put("Activity_11vp8hd", Lists.newArrayList(org.getManageId()));
        //是否变更项目经理
        batchMap.put("isUpdatePm", isUpdatePm);
        ProcessInfo processInfo = workflowUtil.startProcess(StartProcessPayload.of(
                PmsProcDefKey.PMS_PROJECT_CHANGE.name(),
                "P07.项目关键信息变更审批-" + pmsProjectVO.getProjName(),
                saveId + "",
                batchMap)
        );
        return processInfo;
    }


}
