package com.elitesland.tw.tw5.server.prd.salecon.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 业绩统计明细
 *
 * @author likunpeng
 * @date 2023-04-24
 */
@Entity
@Table(name = "con_achieve_d", indexes = {
        @Index(name = "con_achieve_d_achieve_id_IDX", columnList = "achieve_id")
})
@org.hibernate.annotations.Table(appliesTo = "con_achieve_d", comment = "业绩统计明细")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class ConAchieveDDO extends BaseModel implements Serializable {
    /**
     * 业绩统计ID
     */
    @Comment("业绩统计ID")
    @Column(name = "achieve_id")
    private Long achieveId;
    /**
     * 部门类别
     */
    @Comment("部门类别")
    @Column()
    private String buType;
    /**
     * 部门ID
     */
    @Comment("部门ID")
    @Column()
    private Long buId;
    /**
     * 业绩类别
     */
    @Comment("业绩类别")
    @Column()
    private String achieveType;
    /**
     * 价值角色
     */
    @Comment("价值角色")
    @Column()
    private String valueRole;
    /**
     * 部门归属人员ID
     */
    @Comment("部门归属人员ID")
    @Column()
    private Long chargeResId;
    /**
     * 比例
     */
    @Comment("比例")
    @Column()
    private String ratio;
    /**
     * 金额
     */
    @Comment("金额")
    @Column()
    private BigDecimal amt;

    /**
     * 4.0id
     */
    @Comment("4.0id")
    @Column()
    private Long achievedIdV4;

    public void copy(ConAchieveDDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
