package com.elitesland.tw.tw5.server.prd.salecon.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import javax.validation.constraints.*;
import java.math.BigDecimal;

/**
 * 销售合同-T&M-服务价格
 *
 * @author sam.li
 * @date 2024-05-07
 */
@Entity
@Table(name = "con_service_price", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "con_service_price", comment = "销售合同-T&M-服务价格")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class ConServicePriceDO extends BaseModel implements Serializable  {
    /** 合同ID */
    @Comment("合同ID")
    @Column()
    private Long saleConId;
    /** 结算周期 */
    @Comment("结算周期")
    @Column()
    private String settlementCycle;
    /** 结算方式 */
    @Comment("结算方式")
    @Column()
    private String settlementMethod;
    /** 角色 */
    @Comment("角色")
    @Column()
    private String role;
    /** 级别 */
    @Comment("级别")
    @Column()
    private String level;
    /** 人天单价 */
    @Comment("人天单价")
    @Column()
    private BigDecimal priceDay;

    /** 子合同编号 */
    @Comment("子合同编号")
    @Column()
    private String saleConCode;
    public void copy(ConServicePriceDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
