package com.elitesland.tw.tw5.server.prd.system.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.system.payload.PrdSystemFinYearPayload;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemFinYearQuery;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemFinYearService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemFinYearVO;
import com.elitesland.tw.tw5.server.prd.system.convert.PrdSystemFinYearConvert;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemFinYearDAO;
import com.elitesland.tw.tw5.server.prd.system.entity.PrdSystemFinYearDO;
import com.elitesland.tw.tw5.server.prd.system.repo.PrdSystemFinYearRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.ZoneId;
import java.util.Date;
import java.util.List;
import java.util.Optional;

/**
 * 财务年度
 *
 * @author likunpeng
 * @date 2023-04-12
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class PrdSystemFinYearServiceImpl extends BaseServiceImpl implements PrdSystemFinYearService {

    private final PrdSystemFinYearRepo prdSystemFinYearRepo;
    private final PrdSystemFinYearDAO prdSystemFinYearDAO;

    @Override
    public PagingVO<PrdSystemFinYearVO> queryPaging(PrdSystemFinYearQuery query) {
        return prdSystemFinYearDAO.queryPaging(query);
    }

    @Override
    public List<PrdSystemFinYearVO> queryListDynamic(PrdSystemFinYearQuery query) {
        return prdSystemFinYearDAO.queryListDynamic(query);
    }

    @Override
    public PrdSystemFinYearVO queryByKey(Long key) {
        PrdSystemFinYearDO entity = prdSystemFinYearRepo.findById(key).orElseGet(PrdSystemFinYearDO::new);
        Assert.notNull(entity.getId(), "不存在");
        PrdSystemFinYearVO vo = PrdSystemFinYearConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public PrdSystemFinYearVO insert(PrdSystemFinYearPayload payload) {
        PrdSystemFinYearDO entityDo = PrdSystemFinYearConvert.INSTANCE.toDo(payload);
        return PrdSystemFinYearConvert.INSTANCE.toVo(prdSystemFinYearRepo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public PrdSystemFinYearVO update(PrdSystemFinYearPayload payload) {
        PrdSystemFinYearDO entity = prdSystemFinYearRepo.findById(payload.getId()).orElseGet(PrdSystemFinYearDO::new);
        Assert.notNull(entity.getId(), "不存在");
        PrdSystemFinYearDO entityDo = PrdSystemFinYearConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return PrdSystemFinYearConvert.INSTANCE.toVo(prdSystemFinYearRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            prdSystemFinYearDAO.deleteSoft(keys);

        }
    }

    @Override
    @Transactional
    public PrdSystemFinYearVO findByFinYear(Integer finYear) {
        PrdSystemFinYearDO prdSystemFinYearDO = prdSystemFinYearRepo.findPrdSystemFinYearDOByFinYearAndDeleteFlag(finYear, 0);
        //如果没有此年度 就添加
        if (prdSystemFinYearDO == null) {
            Date beginDate = new Date();
            Date endDate = new Date();
            String beginDateStr = finYear + "-01-01";
            String endDateStr = finYear + "-12-31";
            try {
                beginDate = new SimpleDateFormat("yyyy-MM-dd").parse(beginDateStr);
                endDate = new SimpleDateFormat("yyyy-MM-dd").parse(endDateStr);
            } catch (ParseException e) {
                e.printStackTrace();
            }
            //设置值
            PrdSystemFinYearDO entityDo = new PrdSystemFinYearDO();
            entityDo.setFinYear(finYear);
            ZoneId zoneId = ZoneId.systemDefault();
            entityDo.setBeginDate(beginDate.toInstant().atZone(zoneId).toLocalDate());
            entityDo.setEndDate(endDate.toInstant().atZone(zoneId).toLocalDate());
            entityDo.setYearStatus("OPEN");
            //保存
            PrdSystemFinYearDO save = prdSystemFinYearDAO.save(entityDo);
            return PrdSystemFinYearConvert.INSTANCE.toVo(save);
        }
        return PrdSystemFinYearConvert.INSTANCE.toVo(prdSystemFinYearDO);
    }

}
