package com.elitesland.tw.tw5.server.prd.task.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmOpportunityQuery;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOpportunityService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOpportunityListVO;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdCompositeAbilityQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdEmployeCompositeAbilityQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdCompositeAbilityService;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdEmployeCompositeAbilityService;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdCompositeAbilityVO;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdEmployeCompositeAbilityVO;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgEmployeeEqvaRatioService;
import com.elitesland.tw.tw5.api.prd.pms.service.BuProjectService;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectMembersService;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectService;
import com.elitesland.tw.tw5.api.prd.pms.vo.BuProjectVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectVO;
import com.elitesland.tw.tw5.api.prd.task.payload.TaskInfoPayload;
import com.elitesland.tw.tw5.api.prd.task.payload.TaskPackagePayload;
import com.elitesland.tw.tw5.api.prd.task.query.TaskPackageQuery;
import com.elitesland.tw.tw5.api.prd.task.service.TaskInfoService;
import com.elitesland.tw.tw5.api.prd.task.service.TaskPackageService;
import com.elitesland.tw.tw5.api.prd.task.vo.TaskInfoVO;
import com.elitesland.tw.tw5.api.prd.task.vo.TaskPackageVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.PmsReasonTypeEnum;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.ProjectStatusEnum;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.TaskStatusEnum;
import com.elitesland.tw.tw5.server.prd.prj.dao.PrjProjectDAO;
import com.elitesland.tw.tw5.server.prd.task.convert.TaskPackageConvert;
import com.elitesland.tw.tw5.server.prd.task.dao.TaskInfoDAO;
import com.elitesland.tw.tw5.server.prd.task.dao.TaskPackageDAO;
import com.elitesland.tw.tw5.server.prd.task.entity.TaskPackageDO;
import com.elitesland.tw.tw5.server.prd.task.repo.TaskPackageRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * 任务
 *
 * @author xxb
 * @date 2023-11-16
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class TaskPackageServiceImpl extends BaseServiceImpl implements TaskPackageService {
    private final TaskPackageRepo taskPackageRepo;
    private final TaskPackageDAO taskPackageDAO;
    private final TaskInfoDAO taskInfoDAO;
    private final TaskInfoService taskInfoService;
    private final PrdEmployeCompositeAbilityService prdEmployeCompositeAbilityService;
    private final PrdCompositeAbilityService prdCompositeAbilityService;
    private final CacheUtil cacheUtil;
    private final PmsProjectService pmsProjectService;
    private final BuProjectService buProjectService;
    private final CrmOpportunityService opportunityService;
    private final PmsProjectMembersService pmsProjectMembersService;
    //    private final BuProjectMembersService buProjectMembersService;
    private final PrjProjectDAO projectDAO;
    private final PrdOrgEmployeeEqvaRatioService prdOrgEmployeeEqvaRatioService;

    @Override
    public TaskPackageVO initTaskPackage(String reasonType, Long reasonId, Long receiverResId) {
        if (ObjectUtils.isEmpty(reasonType)) {
            throw TwException.error("", "事由类型不能为空，请核验！");
        }
        if (ObjectUtils.isEmpty(reasonId)) {
            throw TwException.error("", "事由ID不能为空，请核验！");
        }
        if (ObjectUtils.isEmpty(receiverResId)) {
            throw TwException.error("", "接保资源不能为空，请核验！");
        }
        TaskPackageVO taskPackageVO = new TaskPackageVO();
        taskPackageVO.setTaskPackageStatus(TaskStatusEnum.CREATE.getCode());
        taskPackageVO.setDisterResId(GlobalUtil.getLoginUserId());
        taskPackageVO.setReceiverResId(receiverResId);
        taskPackageVO.setReceiverBuId(cacheUtil.getDefaultOrgIdByUserId(receiverResId));
        taskPackageVO.setReasonId(reasonId);
        taskPackageVO.setReasonType(reasonType);

        if (reasonType.equals(PmsReasonTypeEnum.PROJ_CONTRACT.getCode())) {
            PmsProjectVO pmsProjectVO = pmsProjectService.querySimpleProjectByKey(reasonId);
            if (ObjectUtils.isEmpty(pmsProjectVO)) {
                throw TwException.error("", "项目不存在，请核验！");
            }
            taskPackageVO.setReasonName(pmsProjectVO.getProjName());
            taskPackageVO.setSettlePrice(pmsProjectVO.getEqvaPrice());
            // 默认是项目经理
            taskPackageVO.setAcceptorId(pmsProjectVO.getPmResId());
        }
        if (reasonType.equals(PmsReasonTypeEnum.PROJ_BU.getCode())) {
            BuProjectVO buProjectVO = buProjectService.queryByKey(reasonId);
            if (ObjectUtils.isEmpty(buProjectVO)) {
                throw TwException.error("", "项目不存在，请核验！");
            }
            taskPackageVO.setReasonName(buProjectVO.getProjName());
            taskPackageVO.setSettlePrice(buProjectVO.getEqvaPrice());
            // 默认是项目经理
            taskPackageVO.setAcceptorId(buProjectVO.getPmResId());
        }
        if (reasonType.equals(PmsReasonTypeEnum.PROJ_OPPO.getCode())) {
            CrmOpportunityQuery query = new CrmOpportunityQuery();
            query.setProjectId(reasonId);
            List<CrmOpportunityListVO> crmOpportunityListVOS = opportunityService.queryListDynamic(query);
            if (ObjectUtils.isEmpty(crmOpportunityListVOS)) {
                throw TwException.error("", "项目不存在，请核验！");
            }
            CrmOpportunityListVO crmOpportunityListVO = crmOpportunityListVOS.get(0);

            taskPackageVO.setReasonName(crmOpportunityListVO.getProjectName());
            taskPackageVO.setSettlePrice(crmOpportunityListVO.getEqvaPrice());
            // 默认是项目经理
            taskPackageVO.setAcceptorId(crmOpportunityListVO.getPreSaleUserId());
        }
        if (taskPackageVO.getSettlePrice() == null) {
            //结算单价为空，默认为2000
            taskPackageVO.setSettlePrice(BigDecimal.valueOf(2000));
        }
        //根据接收资源 查询出默认复合能力
        PrdEmployeCompositeAbilityQuery prdEmployeCompositeAbilityQuery = new PrdEmployeCompositeAbilityQuery();
        prdEmployeCompositeAbilityQuery.setUserId(receiverResId);
        prdEmployeCompositeAbilityQuery.setMainFlag(true);
        List<PrdEmployeCompositeAbilityVO> employeCompositeAbilityVOS = prdEmployeCompositeAbilityService.getList(prdEmployeCompositeAbilityQuery);
        if (!ObjectUtils.isEmpty(employeCompositeAbilityVOS)) {
            PrdEmployeCompositeAbilityVO employeCompositeAbilityVO = employeCompositeAbilityVOS.get(0);
            taskPackageVO.setCompositeAbilityId(employeCompositeAbilityVO.getAbilityId());
            taskPackageVO.setCompositeAbilityName(employeCompositeAbilityVO.getAbilityName());
            // 查询工种
            PrdCompositeAbilityQuery prdCompositeAbilityQuery = new PrdCompositeAbilityQuery();
            prdCompositeAbilityQuery.setDocNo(employeCompositeAbilityVO.getDocNo());
            List<PrdCompositeAbilityVO> compositeAbilityVOS = prdCompositeAbilityService.getList(prdCompositeAbilityQuery);
            if (!ObjectUtils.isEmpty(compositeAbilityVOS)) {
                PrdCompositeAbilityVO compositeAbilityVO = compositeAbilityVOS.get(0);
                taskPackageVO.setJobType1(compositeAbilityVO.getJobType1());
                taskPackageVO.setJobType2(compositeAbilityVO.getJobType2());
            }
        }

        return taskPackageVO;
    }

    @Override
    public TaskPackageVO queryByKey(Long key, Boolean needTasks) {
        TaskPackageVO taskPackageVO = taskPackageDAO.queryByKey(key);
        if (ObjectUtils.isEmpty(taskPackageVO)) {
            throw TwException.error("", "任务包不存在，请核验！");
        }
        //  赋值复合能力名称
        if (!ObjectUtils.isEmpty(taskPackageVO.getCompositeAbilityId())) {
            PrdCompositeAbilityVO compositeAbilityVO = prdCompositeAbilityService.get(taskPackageVO.getCompositeAbilityId());
            if (!ObjectUtils.isEmpty(compositeAbilityVO)) {
                taskPackageVO.setCompositeAbilityName(compositeAbilityVO.getName());
            }
        }
        if (needTasks != null && needTasks) {
            // 查询任务列表
            List<TaskInfoVO> taskInfoVOS = taskInfoDAO.queryByTaskPackageId(key);
            // 总当量、总金额 现算
            if (!ObjectUtils.isEmpty(taskInfoVOS)) {
                //List<TaskInfoVO> availdoVOS = taskInfoVOS.stream().filter(vo -> !vo.getTaskStatus().equals(TaskStatusEnum.APPLYING.getCode())).collect(Collectors.toList());
                BigDecimal totalEqva = taskInfoVOS.stream().filter(v -> !ObjectUtils.isEmpty(v.getTotalEqva())).map(TaskInfoVO::getTotalEqva).reduce(BigDecimal.ZERO, BigDecimal::add);
                taskPackageVO.setTotalEqva(totalEqva);
                taskPackageVO.setTotalAmt(totalEqva.multiply(taskPackageVO.getIncomePrice()));
                taskPackageVO.setTaskInfoVOS(taskInfoVOS);
            }
        } else {
            BigDecimal totalEqva = taskInfoDAO.queryTotalEqvaByTaskPackageId(key);
            if (totalEqva != null) {
                taskPackageVO.setTotalEqva(totalEqva);
                taskPackageVO.setTotalAmt(totalEqva.multiply(taskPackageVO.getIncomePrice()));
            }
        }
        return taskPackageVO;
    }

    @Override
    public PagingVO<TaskPackageVO> queryPaging(TaskPackageQuery query) {
        PagingVO<TaskPackageVO> taskPackageVO = taskPackageDAO.queryPaging(query);
        if (taskPackageVO.getTotal() > 0) {
            List<Long> collect = taskPackageVO.getRecords().stream().map(TaskPackageVO::getId).collect(Collectors.toList());
            List<TaskInfoVO> taskInfoVOS = taskInfoDAO.queryByTaskPackageIds(collect);
            taskPackageVO.getRecords().forEach(packageVO -> {

//                // 计算实际收款金额
//                BigDecimal actualReceivedAmt = recvPlanViews.stream()
//                        .map(ConReceivablePlanVO::getActualRecvAmt)
//                        .filter(Objects::nonNull)
//                        .reduce(BigDecimal::add)
//                        .orElse(BigDecimal.ZERO);
                BigDecimal totalEqva = taskInfoVOS.stream()
                        .filter(taskInfoVO -> taskInfoVO.getTaskPackageId().equals(packageVO.getId()))
                        .map(TaskInfoVO::getTotalEqva)
                        .filter(Objects::nonNull)
                        .reduce(BigDecimal::add)
                        .orElse(BigDecimal.ZERO);
                packageVO.setTotalEqva(totalEqva);
                packageVO.setTotalAmt(totalEqva.multiply(packageVO.getIncomePrice()));

            });
        }
        return taskPackageVO;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public TaskPackageVO addTaskPackageByMember(TaskPackagePayload taskPackagePayload) {
        //数据校验
        checkData(taskPackagePayload);

        String reasonType = taskPackagePayload.getReasonType();
        Long reasonId = taskPackagePayload.getReasonId();
        String reasonName = taskPackagePayload.getReasonName();
        Long receiverResId = taskPackagePayload.getReceiverResId();
        LocalDate startDate = taskPackagePayload.getStartDate();
        LocalDate endDate = taskPackagePayload.getEndDate();
        taskPackagePayload.setReceiverBuId(cacheUtil.getDefaultOrgIdByUserId(receiverResId));
        // 验收人如果为空，默认发包人
        if (ObjectUtils.isEmpty(taskPackagePayload.getAcceptorId())) {
            taskPackagePayload.setAcceptorId(GlobalUtil.getLoginUserId());
        }
        // 任务包状态是 派发
        taskPackagePayload.setTaskPackageStatus(TaskStatusEnum.CREATE.getCode());

        // 计算总当量、总金额
        List<TaskInfoPayload> taskInfoPayloads = taskPackagePayload.getTaskInfoPayloads();
        //任务包名称：系统自动生成，生成规则：项目名称+任务包+资源姓名+开始日期~结束日期，举例：柠萌项目任务包-丁元梦-2023/11/01~2023/11/20
        String taskPackageName = reasonName + "任务包-" + cacheUtil.getUserName(receiverResId) + "-" + startDate.toString() + "~" + endDate.toString();
        taskPackagePayload.setTaskPackageName(taskPackageName);
        // 保存 任务包信息
        TaskPackageDO taskPackageDO = TaskPackageConvert.INSTANCE.toDo(taskPackagePayload);
        taskPackageDO = taskPackageDAO.save(taskPackageDO);
        Long taskPackageId = taskPackageDO.getId();
        //保存  任务信息
        if (!ObjectUtils.isEmpty(taskInfoPayloads)) {
            taskInfoPayloads.forEach(taskInfoPayload -> {
                taskInfoPayload.setTaskPackageId(taskPackageId);
                taskInfoPayload.setTaskStatus(TaskStatusEnum.CREATE.getCode());
                taskInfoPayload.setTaskResId(receiverResId);
                taskInfoPayload.setTaskApplyFlag(0);
                taskInfoPayload.setReasonType(reasonType);
                taskInfoPayload.setReasonId(reasonId);
                taskInfoPayload.setDisterResId(null);
            });
            taskInfoService.batchSave(taskInfoPayloads);
        }

//        if (ObjectUtils.isEmpty(taskPackagePayload.getId())) {
//            //修改项目成员任务包id
//            updateProjMember(taskPackageId, reasonType, taskPackagePayload.getMemberId());
//        }
        return TaskPackageConvert.INSTANCE.toVo(taskPackageDO);
    }

    @Override
    public TaskPackageVO addTaskPackage(TaskPackagePayload taskPackagePayload) {
        //只能新增
        taskPackagePayload.setId(null);
        //数据校验
        checkData(taskPackagePayload);
        Long receiverResId = taskPackagePayload.getReceiverResId();
        taskPackagePayload.setReceiverBuId(cacheUtil.getDefaultOrgIdByUserId(receiverResId));
        // 验收人如果为空，默认发包人
        if (ObjectUtils.isEmpty(taskPackagePayload.getAcceptorId())) {
            taskPackagePayload.setAcceptorId(taskPackagePayload.getDisterResId());
        }
        // 任务包状态是 派发
        taskPackagePayload.setTaskPackageStatus(TaskStatusEnum.INPROCESS.getCode());
        //  任务包名称：系统自动生成，生成规则：项目名称+任务包+资源姓名+开始日期~结束日期，举例：柠萌项目任务包-丁元梦-2023/11/01~2023/11/20
        String taskPackageName = taskPackagePayload.getReasonName() + "任务包-" + cacheUtil.getUserName(receiverResId) + "-" + taskPackagePayload.getStartDate().toString() + "~" + taskPackagePayload.getEndDate().toString();
        taskPackagePayload.setTaskPackageName(taskPackageName);
        // 保存 任务包信息
        TaskPackageDO taskPackageDO = TaskPackageConvert.INSTANCE.toDo(taskPackagePayload);
        taskPackageDO = taskPackageDAO.save(taskPackageDO);

        if (taskPackagePayload.getReasonType().equals(PmsReasonTypeEnum.PROJ_CONTRACT.getCode())) {
            //合同项目反向添加项目成员
            pmsProjectMembersService.insertFromTask(taskPackagePayload.getReasonId(), receiverResId);
        }

        return TaskPackageConvert.INSTANCE.toVo(taskPackageDO);
    }

    /**
     * 数据校验
     *
     * @param taskPackagePayload
     */
    void checkData(TaskPackagePayload taskPackagePayload) {
        // 字段验证
        if (!ObjectUtils.isEmpty(taskPackagePayload.getId())) {
            TaskPackageVO taskPackageVO = taskPackageDAO.queryByKey(taskPackagePayload.getId());
            if (taskPackageVO == null) {
                throw TwException.error("", "编辑任务包不存在");
            }
            if (!taskPackageVO.getTaskPackageStatus().equals(TaskStatusEnum.CREATE.getCode())) {
                throw TwException.error("", "仅支持新建状态修改");
            }
        }
        if (ObjectUtils.isEmpty(taskPackagePayload.getReasonType())) {
            throw TwException.error("", "事由类型不能为空，请核验！");
        }
        if (ObjectUtils.isEmpty(taskPackagePayload.getReasonId())) {
            throw TwException.error("", "事由ID不能为空，请核验！");
        }

//        if (ObjectUtils.isEmpty(taskPackagePayload.getDisterResId())) {
//            taskPackagePayload.setDisterResId(GlobalUtil.getLoginUserId());
//        }
        if (ObjectUtils.isEmpty(taskPackagePayload.getReceiverResId())) {
            throw TwException.error("", "接收资源ID不可为空");
        }
        if (ObjectUtils.isEmpty(taskPackagePayload.getStartDate())) {
            throw TwException.error("", "开始日期不能为空，请核验！");
        }
        if (ObjectUtils.isEmpty(taskPackagePayload.getEndDate())) {
            throw TwException.error("", "结束日期不能为空，请核验！");
        }
        if (ObjectUtils.isEmpty(taskPackagePayload.getAcceptMethod())) {
            throw TwException.error("", "验收方式不能为空，请核验！");
        }
        if (ObjectUtils.isEmpty(taskPackagePayload.getPricingMethod())) {
            throw TwException.error("", "计价方式不能为空，请核验！");
        }
        if (ObjectUtils.isEmpty(taskPackagePayload.getIncomePrice())) {
            throw TwException.error("", "当量收入单价不能为空，请核验！");
        }
        if (ObjectUtils.isEmpty(taskPackagePayload.getSettlePrice())) {
            throw TwException.error("", "预算收入单价不能为空，请核验！");
        }
//        PrdOrgEmployeeVO employee = cacheUtil.getEmployee(taskPackagePayload.getReceiverResId());
//        if (!employee.getResourceStatus().equals(SystemDefaultEnum.DefaultResourceStatus.getCode())) {
//            throw TwException.error("", "接包人资源状态非在职");
//        }
//        if (!employee.getHrStatus().equals(SystemDefaultEnum.DefaultHrStatus.getCode())) {
//            throw TwException.error("", "接包人人事状态非有效");
//        }
        BigDecimal guaranteeRate = taskPackagePayload.getGuaranteeRate();
        if (ObjectUtils.isEmpty(guaranteeRate)) {
            taskPackagePayload.setGuaranteeRate(BigDecimal.ZERO);
        } else {
            if (guaranteeRate.compareTo(BigDecimal.ZERO) < 0) {
                throw TwException.error("", "质保金比例不能小于0%，请核验！");
            }
            if (guaranteeRate.compareTo(BigDecimal.ONE) >= 0) {
                throw TwException.error("", "质保金比例不能大于等于100%，请核验！");
            }
        }
        if (taskPackagePayload.getReasonType().equals(PmsReasonTypeEnum.PROJ_CONTRACT.getCode())) {
            PmsProjectVO pmsProjectVO = pmsProjectService.queryByKey(taskPackagePayload.getReasonId());
            if (pmsProjectVO == null) {
                throw TwException.error("", "派发项目存在");
            }
            if (!pmsProjectVO.getProjStatus().equals(ProjectStatusEnum.ACTIVE.getCode())) {
                throw TwException.error("", "仅支持项目激活状态派发");
            }
            taskPackagePayload.setReasonName(pmsProjectVO.getProjName());
            taskPackagePayload.setDisterResId(pmsProjectVO.getPmResId());
        }
        if (taskPackagePayload.getReasonType().equals(PmsReasonTypeEnum.PROJ_OPPO.getCode())) {
            CrmOpportunityQuery query = new CrmOpportunityQuery();
            query.setProjectId(taskPackagePayload.getReasonId());
            List<CrmOpportunityListVO> crmOpportunityListVOS = opportunityService.queryListDynamic(query);
            if (ObjectUtils.isEmpty(crmOpportunityListVOS)) {
                throw TwException.error("", "事由不存在");
            }
            CrmOpportunityListVO crmOpportunityVO = crmOpportunityListVOS.get(0);

            if (!crmOpportunityVO.getProjectStatus().equals(ProjectStatusEnum.ACTIVE.getCode())) {
                throw TwException.error("", "仅支持项目激活状态派发");
            }
            taskPackagePayload.setReasonName(crmOpportunityVO.getProjectName());
            taskPackagePayload.setDisterResId(crmOpportunityVO.getPreSaleUserId());
        }
        if (taskPackagePayload.getReasonType().equals(PmsReasonTypeEnum.PROJ_BU.getCode())) {
            BuProjectVO buProjectVO = buProjectService.queryByKey(taskPackagePayload.getReasonId());
            if (buProjectVO == null) {
                throw TwException.error("", "派发项目不存在");
            }
            if (!buProjectVO.getProjStatus().equals(ProjectStatusEnum.ACTIVE.getCode())) {
                throw TwException.error("", "仅支持激活项目派发");
            }
            if (buProjectVO.getProjYear() != LocalDate.now().getYear()) {
                throw TwException.error("", "仅支持本年度项目派发");
            }
            taskPackagePayload.setReasonName(buProjectVO.getProjName());
            taskPackagePayload.setDisterResId(buProjectVO.getPmResId());
        }
        BigDecimal eqvaRatio = prdOrgEmployeeEqvaRatioService.getEqvaRatio(taskPackagePayload.getReceiverResId(), null);
        if (eqvaRatio == null) {
            throw TwException.error("", "当量系数获取失败");
        }
        taskPackagePayload.setEqvaRatio(eqvaRatio);
    }

//    /**
//     * 修改项目成员任务包id
//     *
//     * @param taskPackageId
//     * @param reasonType
//     * @param memberId
//     */
//    void updateProjMember(Long taskPackageId, String reasonType, Long memberId) {
//        // 将任务包id 更新到项目成员表中
//        if (reasonType.equals(PmsReasonTypeEnum.PROJ_CONTRACT.getCode())) {
//            PmsProjectMembersPayload membersPayload = new PmsProjectMembersPayload();
//            membersPayload.setId(memberId);
//            membersPayload.setTaskPackageId(taskPackageId);
//            pmsProjectMembersService.updateByKeyDynamic(membersPayload);
//        }
//        if (reasonType.equals(PmsReasonTypeEnum.PROJ_BU.getCode())) {
//            BuProjectMembersPayload membersPayload = new BuProjectMembersPayload();
//            membersPayload.setId(memberId);
//            membersPayload.setTaskPackageId(taskPackageId);
//            buProjectMembersService.updateByKeyDynamic(membersPayload);
//        }
//        if (reasonType.equals(PmsReasonTypeEnum.PROJ_OPPO.getCode())) {
//            PrjProjectMemberPayload membersPayload = new PrjProjectMemberPayload();
//            membersPayload.setId(memberId);
//            membersPayload.setTaskPackageId(taskPackageId);
//            projectDAO.updateMemberByKeyDynamic(membersPayload);
//        }
//
//    }


    @Override
    public List<TaskPackageVO> taskPackageList(TaskPackageQuery taskPackageQuery) {
        List<TaskPackageVO> taskPackageVOS = taskPackageDAO.queryListDynamic(taskPackageQuery);
        if (!ObjectUtils.isEmpty(taskPackageVOS) && taskPackageQuery.getReceiverResId() != null && TaskStatusEnum.INPROCESS.getCode().equals(taskPackageQuery.getTaskPackageStatus())) {
            //查询指定人任务包
            BigDecimal eqvaRatio = prdOrgEmployeeEqvaRatioService.getEqvaRatio(taskPackageQuery.getReceiverResId(), LocalDate.now());
            taskPackageVOS.forEach(vo -> {
                Boolean createTaskFlage = false;
                if ((vo.getEqvaRatio() == null ? BigDecimal.ZERO : vo.getEqvaRatio()).compareTo(eqvaRatio) == 0) {
                    createTaskFlage = true;
                }
                vo.setCreateTaskFlag(createTaskFlage);
            });
        }
        return taskPackageVOS;
    }

    @Override
    public long taskPackageCount(TaskPackageQuery taskPackageQuery) {
        return taskPackageDAO.count(taskPackageQuery);
    }

    @Override
    public List<TaskPackageVO> taskMyPackageList(TaskPackageQuery taskPackageQuery) {
        taskPackageQuery.setReceiverResId(GlobalUtil.getLoginUserId());
        //列表查询处理中的任务包
        taskPackageQuery.setTaskPackageStatus(TaskStatusEnum.INPROCESS.getCode());
        if (taskPackageQuery.getReasonId() != null) {
            if (taskPackageQuery.getReasonId().longValue() == 0) {
                taskPackageQuery.setReasonId(null);
                /**
                 * 无项目操作
                 *   无任务任务包
                 *   BU项目任务包（权限 优先级不高）
                 *   商机项目任务包（权限 优先级不高）
                 */
                List<String> strings = Arrays.asList(PmsReasonTypeEnum.PROJ_BU.getCode(), PmsReasonTypeEnum.PROJ_OPPO.getCode());
                taskPackageQuery.setReasonTypes(strings);
            } else {
                //有项目查合同项目任务包
                taskPackageQuery.setReasonType(PmsReasonTypeEnum.PROJ_CONTRACT.getCode());
            }
        }
        return taskPackageDAO.queryListDynamic(taskPackageQuery);
    }

    @Override
    public List<TaskPackageVO> taskMyPackageListDib(TaskPackageQuery taskPackageQuery) {
        // TODO taskPackageQuery.getReasonId()必须有值，否则赋默认值
        taskPackageQuery.setReceiverResId(GlobalUtil.getLoginUserId());
        //列表查询处理中的任务包
        taskPackageQuery.setTaskPackageStatus(TaskStatusEnum.INPROCESS.getCode());
        return taskPackageDAO.queryListDynamic(taskPackageQuery);
    }

    @Override
    public long updateByKeyDynamic(TaskPackagePayload payload) {
        return taskPackageDAO.updateByKeyDynamic(payload);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            List<TaskPackageVO> taskPackageVOS = taskPackageDAO.queryByKeys(keys);
            long count = taskPackageVOS.stream().filter(vo -> !vo.getTaskPackageStatus().equals(TaskStatusEnum.CREATE.getCode())).count();
            if (count > 0) {
                throw TwException.error("", "仅支持新建状态下的任务包删除");
            }
            taskPackageDAO.deleteSoft(keys);

            taskInfoDAO.deleteSoftByPackageIds(keys);
        }

    }

}
