package com.elitesland.tw.tw5.server.prd.ts.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;
import java.math.BigDecimal;

import org.hibernate.annotations.Where;

import javax.persistence.*;
import javax.validation.constraints.*;

/**
 * notask_approval_1
 *
 * @author zoey
 * @date 2024-04-30
 */
@Entity
@Table(name = "ts_notask_approval_config_rule", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "ts_notask_approval_config_rule", comment = "notask_approval_1")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class TsNotaskApprovalConfigRuleDO extends BaseModel implements Serializable  {
    /** 报配置主表id */
    @Comment("报配置主表id")
    @Column()
    private Long configId;
    /** 活动 */
    @Comment("活动")
    @Column()
    private String activity;
    /** 用户配置 */
    @Comment("用户配置")
    @Column()
    private Integer isUser;
    /** 人员 */
    @Comment("人员")
    @Column()
    private String users;
    /** 范围（udc:每人，事业部） */
    @Comment("范围（udc:每人，事业部）")
    @Column()
    private String scope;
    /** 填报天数上限 */
    @Comment("填报天数上限")
    @Column()
    private BigDecimal upperLimit;
    /** UT值 */
    @Comment("UT值")
    @Column()
    private Integer ut;
    /** 触发条件 */
    @Comment("触发条件")
    @Column()
    private String triggerCondition;
    /** 条件触发的天数 */
    @Comment("条件触发的天数")
    @Column()
    private BigDecimal conditionDays;
    /** 报配置主表id */
    @Comment("报配置主表id")
    @Column()
    private Long apprUserId;

    /** 审批1角色 */
    @Comment("审批1角色")
    @Column()
    private String firstApprUserRole;

    public void copy(TsNotaskApprovalConfigRuleDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
