/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.acc.controller;

import com.elitesland.tw.tw5.api.prd.acc.payload.AccReimPayload;
import com.elitesland.tw.tw5.api.prd.acc.service.AccReimService;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccReimVO;
import com.elitesland.tw.tw5.api.prd.adm.service.AdmFeeApplyService;
import com.elitesland.tw.tw5.api.prd.inv.service.InvInvoiceService;
import com.elitesland.tw.tw5.server.prd.acc.common.functionEnum.AccReimDocStatusEnum;
import com.elitesland.tw.tw5.server.prd.inv.common.InvoiceReimStatusEnum;
import com.elitesland.workflow.WorkflowCallBack;
import com.elitesland.workflow.WorkflowResult;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import com.elitesland.workflow.payload.TaskAssigneePayload;
import com.elitesland.workflow.payload.TaskCompletedPayload;
import com.elitesland.workflow.payload.TaskCreatedPayload;
import java.time.LocalDateTime;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rpc/workflow/ACC_OTHERS/callBack"})
@Transactional
public class AccReimOthersCallbackController
implements WorkflowCallBack {
    private static final Logger log = LoggerFactory.getLogger(AccReimOthersCallbackController.class);
    private final AccReimService accReimService;
    private final InvInvoiceService invInvoiceService;
    private final AdmFeeApplyService admFeeApplyService;

    @PostMapping(value={"/taskAssignee"})
    public WorkflowResult<ArrayList<String>> taskAssignee(@RequestBody TaskAssigneePayload payload) {
        return WorkflowResult.success(null);
    }

    @PostMapping(value={"/taskCreated"})
    public WorkflowResult<Void> taskCreated(@RequestBody TaskCreatedPayload payload) {
        return WorkflowResult.success(null);
    }

    @PostMapping(value={"/taskCompleted"})
    public WorkflowResult<Void> taskCompleted(@RequestBody TaskCompletedPayload payload) {
        String taskKey = payload.getTaskKey();
        String businessKey = payload.getBusinessKey();
        AccReimPayload accReimPayload = new AccReimPayload();
        accReimPayload.setId(Long.valueOf(Long.parseLong(businessKey)));
        if (FlowTaskKey.Activity_0yd0oo0.code.equals(taskKey)) {
            accReimPayload.setReimStatus(AccReimDocStatusEnum.PENDING_RECEIVE.getCode());
        }
        if (FlowTaskKey.Activity_0lbdadr.code.equals(taskKey)) {
            accReimPayload.setFinPicApprTime(LocalDateTime.now());
        }
        this.accReimService.partialUpdate(accReimPayload);
        return WorkflowResult.success(null);
    }

    @PostMapping(value={"/processStatusChange"})
    public WorkflowResult<Void> processStatusChange(@RequestBody ProcessStatusChangePayload payload) {
        String businessKey = payload.getBusinessKey();
        Long reimId = Long.valueOf(businessKey);
        ProcInstStatus procInstStatus = payload.getProcInstStatus();
        AccReimPayload accReimPayload = new AccReimPayload();
        accReimPayload.setId(reimId);
        AccReimVO accReimVO = this.accReimService.queryOneByKey(reimId);
        if (!ObjectUtils.isEmpty((Object)accReimVO)) {
            switch (procInstStatus) {
                case NOTSUBMIT: {
                    accReimPayload.setReimStatus(AccReimDocStatusEnum.CREATE.getCode());
                    accReimPayload.setApprStatus(ProcInstStatus.NOTSUBMIT.name());
                    break;
                }
                case INTERRUPT: {
                    this.invInvoiceService.updateReimStatusByReimId(reimId, InvoiceReimStatusEnum.NEW.getCode());
                    this.admFeeApplyService.unbindReim(reimId);
                    break;
                }
                case INVALID: {
                    accReimPayload.setApprStatus(ProcInstStatus.INVALID.name());
                    accReimPayload.setDeleteFlag(Integer.valueOf(1));
                    this.invInvoiceService.updateReimStatusByReimId(reimId, InvoiceReimStatusEnum.NEW.getCode());
                    this.admFeeApplyService.unbindReim(reimId);
                    break;
                }
                case REJECTED: {
                    accReimPayload.setReimStatus(AccReimDocStatusEnum.CREATE.getCode());
                    accReimPayload.setApprStatus(ProcInstStatus.REJECTED.name());
                    String taskDefKey = payload.getCommentInfo().getTaskDefKey();
                    if (!FlowTaskKey.Activity_0cn8khq.code.equals(taskDefKey)) break;
                    accReimPayload.setFinRejectFlag(Integer.valueOf(1));
                    break;
                }
                case APPROVED: {
                    accReimPayload.setReimStatus(AccReimDocStatusEnum.PENDING_CHARGE.getCode());
                    accReimPayload.setApprStatus(ProcInstStatus.APPROVED.name());
                    this.invInvoiceService.updateReimStatusByReimId(reimId, InvoiceReimStatusEnum.APPROVED.getCode());
                    break;
                }
                case APPROVING: {
                    accReimPayload.setApprStatus(ProcInstStatus.APPROVING.name());
                }
            }
            this.accReimService.partialUpdate(accReimPayload);
        }
        return WorkflowResult.success(null);
    }

    public AccReimOthersCallbackController(AccReimService accReimService, InvInvoiceService invInvoiceService, AdmFeeApplyService admFeeApplyService) {
        this.accReimService = accReimService;
        this.invInvoiceService = invInvoiceService;
        this.admFeeApplyService = admFeeApplyService;
    }

    static enum FlowTaskKey {
        Activity_1luosio("Activity_1luosio", "\u76f4\u5c5e\u4e0a\u7ea7\u5ba1\u6279"),
        Activity_0cn8khq("Activity_0cn8khq", "\u8d22\u52a1\u7a3d\u6838\u4e13\u5458"),
        Activity_0lbdadr("Activity_0lbdadr", "\u8d22\u52a1\u8d1f\u8d23\u4eba"),
        Activity_0co8b7h("Activity_0co8b7h", "\u603b\u88c1"),
        Activity_0yd0oo0("Activity_0yd0oo0", "\u8d39\u7528\u627f\u62c5\u4e8b\u4e1a\u90e8\u8d1f\u8d23\u4eba");

        private String code;
        private String desc;

        private FlowTaskKey(String code, String desc) {
            this.code = code;
            this.desc = desc;
        }
    }
}

