/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.acc.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.prd.acc.payload.AccReimTaxPayload;
import com.elitesland.tw.tw5.api.prd.acc.query.AccReimTaxQuery;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccReimExportVO;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccReimTaxVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.acc.entity.AccReimTaxDO;
import com.elitesland.tw.tw5.server.prd.acc.entity.QAccBusinessItemDO;
import com.elitesland.tw.tw5.server.prd.acc.entity.QAccFinancialSubjectDO;
import com.elitesland.tw.tw5.server.prd.acc.entity.QAccReimDO;
import com.elitesland.tw.tw5.server.prd.acc.entity.QAccReimDetailDO;
import com.elitesland.tw.tw5.server.prd.acc.entity.QAccReimTaxDO;
import com.elitesland.tw.tw5.server.prd.acc.repo.AccReimTaxRepo;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Repository
public class AccReimTaxDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final AccReimTaxRepo repo;
    private final QAccReimTaxDO qdo = QAccReimTaxDO.accReimTaxDO;
    private final QAccReimDO qMasdo = QAccReimDO.accReimDO;
    private final QAccReimDetailDO qDtldo = QAccReimDetailDO.accReimDetailDO;
    private final QAccFinancialSubjectDO qFinancialSubjectDO = QAccFinancialSubjectDO.accFinancialSubjectDO;
    private final QAccBusinessItemDO qBusinessItemDO = QAccBusinessItemDO.accBusinessItemDO;

    private JPAQuery<AccReimTaxVO> getJpaQuerySelect() {
        return (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(AccReimTaxVO.class, (Expression[])new Expression[]{this.qdo.id, this.qMasdo.id.as("reimId"), this.qMasdo.remark, this.qMasdo.createUserId, this.qMasdo.creator, this.qMasdo.createTime, this.qMasdo.modifyUserId, this.qMasdo.updater, this.qMasdo.modifyTime, this.qMasdo.reimNo, this.qMasdo.reimUserId, this.qMasdo.reimOrgId, this.qMasdo.reimResGrade, this.qMasdo.reasonType, this.qMasdo.reimDocType, this.qMasdo.relatedDocId, this.qMasdo.relatedDocName, this.qMasdo.relatedBudgetId, this.qMasdo.expenseProjectId, this.qMasdo.expenseOrgId, this.qMasdo.expenseCompany, this.qMasdo.expenseByType, this.qMasdo.accountingDate, this.qMasdo.reimStatus, this.qMasdo.reimTotalAmt, this.qMasdo.adjustAmt, this.qMasdo.reasonId, this.qMasdo.reasonName, this.qMasdo.batchNo, this.qMasdo.payMode, this.qMasdo.finChargeUpTime, this.qMasdo.fileCode, this.qMasdo.applyDate, this.qMasdo.apprProcName, this.qMasdo.finPicApprTime, this.qMasdo.bankTime, this.qMasdo.apprStatus, this.qMasdo.contractId, this.qMasdo.procInstId, this.qMasdo.procInstName, this.qMasdo.finPeriodId, this.qDtldo.id.as("reimDtlId"), this.qDtldo.expenseDate, this.qDtldo.reimAmt, this.qDtldo.taxAmt, this.qDtldo.taxRate, this.qDtldo.reimRemark, this.qdo.finAccSubjId, this.qFinancialSubjectDO.accName.as("finAccSubjName")})).from((EntityPath)this.qdo)).leftJoin((EntityPath)this.qMasdo)).on((Predicate)this.qdo.reimId.eq(this.qMasdo.id))).leftJoin((EntityPath)this.qDtldo)).on((Predicate)this.qDtldo.id.eq(this.qdo.reimDtlId).and((Predicate)this.qDtldo.deleteFlag.eq((Object)0)))).leftJoin((EntityPath)this.qFinancialSubjectDO)).on((Predicate)this.qdo.finAccSubjId.eq(this.qFinancialSubjectDO.id).and((Predicate)this.qFinancialSubjectDO.deleteFlag.eq((Object)0)));
    }

    private JPAQuery<AccReimTaxVO> getJpaQueryWhere(AccReimTaxQuery query) {
        JPAQuery<AccReimTaxVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.qdo._super, (TwQueryParam)query);
        jpaQuery.orderBy(SqlUtil.getSortedColumn(this.qdo, query.getOrders()));
        return jpaQuery;
    }

    public long count(AccReimTaxQuery query) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.qdo.count()).from((EntityPath)this.qdo)).leftJoin((EntityPath)this.qMasdo)).on((Predicate)this.qdo.reimId.eq(this.qMasdo.id))).leftJoin((EntityPath)this.qDtldo)).on((Predicate)this.qDtldo.id.eq(this.qdo.reimDtlId).and((Predicate)this.qDtldo.deleteFlag.eq((Object)0)))).leftJoin((EntityPath)this.qFinancialSubjectDO)).on((Predicate)this.qdo.finAccSubjId.eq(this.qFinancialSubjectDO.id).and((Predicate)this.qFinancialSubjectDO.deleteFlag.eq((Object)0)));
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.qdo._super, (TwQueryParam)query);
        long total = (Long)jpaQuery.fetchOne();
        return total;
    }

    private Predicate where(AccReimTaxQuery query) {
        String likeStr;
        ArrayList<BooleanExpression> list = new ArrayList<BooleanExpression>();
        if (!ObjectUtils.isEmpty((Object)query.getId())) {
            list.add(this.qdo.id.eq((Object)query.getId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getIds())) {
            list.add(this.qdo.id.in((Collection)query.getIds()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getReimId())) {
            list.add(this.qdo.reimId.eq((Object)query.getReimId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getReimDtlId())) {
            list.add(this.qdo.reimDtlId.eq((Object)query.getReimDtlId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getFinAccSubjId())) {
            list.add(this.qdo.finAccSubjId.eq((Object)query.getFinAccSubjId()));
        }
        list.add(this.qdo.taxRate.gt((Number)0));
        if (!ObjectUtils.isEmpty((Object)query.getTaxAmt())) {
            list.add(this.qdo.taxAmt.eq((Object)query.getTaxAmt()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getReimIdList())) {
            list.add(this.qdo.reimId.in((Collection)query.getReimIdList()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getReimNo())) {
            likeStr = SqlUtil.toSqlLikeString(query.getReimNo());
            list.add(this.qMasdo.reimNo.like(likeStr));
        }
        if (!ObjectUtils.isEmpty((Object)query.getReimUserId())) {
            list.add(this.qMasdo.reimUserId.eq((Object)query.getReimUserId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getReimDocType())) {
            list.add(this.qMasdo.reimDocType.eq((Object)query.getReimDocType()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getAccountingDateStart()) && !ObjectUtils.isEmpty((Object)query.getAccountingDateEnd())) {
            list.add(this.qMasdo.accountingDate.goe((Comparable)query.getAccountingDateStart()).and((Predicate)this.qMasdo.accountingDate.loe((Comparable)query.getAccountingDateEnd())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getBatchNo())) {
            likeStr = SqlUtil.toSqlLikeString(query.getBatchNo());
            list.add(this.qMasdo.batchNo.like(likeStr));
        }
        if (!ObjectUtils.isEmpty((Object)query.getExpenseCompany())) {
            list.add(this.qMasdo.expenseCompany.eq((Object)query.getExpenseCompany()));
        }
        return ExpressionUtils.allOf(list);
    }

    public AccReimTaxVO queryByKey(Long id) {
        JPAQuery<AccReimTaxVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.id.eq((Object)id));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (AccReimTaxVO)jpaQuery.fetchFirst();
    }

    public List<AccReimTaxVO> queryListDynamic(AccReimTaxQuery query) {
        JPAQuery<AccReimTaxVO> jpaQuery = this.getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    public PagingVO<AccReimTaxVO> queryPaging(AccReimTaxQuery query) {
        long total = this.count(query);
        if (total == 0L) {
            return PagingVO.empty();
        }
        JPAQuery<AccReimTaxVO> jpaQuery = this.getJpaQueryWhere(query);
        List result = ((JPAQuery)((JPAQuery)jpaQuery.offset(query.getPageRequest().getOffset())).limit((long)query.getPageRequest().getPageSize())).fetch();
        return PagingVO.builder().records(result).total(total).build();
    }

    public AccReimTaxDO save(AccReimTaxDO ado) {
        return (AccReimTaxDO)this.repo.save(ado);
    }

    public List<AccReimTaxDO> saveAll(List<AccReimTaxDO> dos) {
        return this.repo.saveAll(dos);
    }

    @Transactional
    public long updateByKeyDynamic(AccReimTaxPayload payload) {
        List nullFields;
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).where(new Predicate[]{this.qdo.id.eq((Object)payload.getId())});
        if (payload.getId() != null) {
            update.set(this.qdo.id, (Object)payload.getId());
        }
        if (payload.getReimId() != null) {
            update.set(this.qdo.reimId, (Object)payload.getReimId());
        }
        if (payload.getReimDtlId() != null) {
            update.set(this.qdo.reimDtlId, (Object)payload.getReimDtlId());
        }
        if (payload.getFinAccSubjId() != null) {
            update.set(this.qdo.finAccSubjId, (Object)payload.getFinAccSubjId());
        }
        if (payload.getTaxRate() != null) {
            update.set(this.qdo.taxRate, (Object)payload.getTaxRate());
        }
        if (payload.getTaxAmt() != null) {
            update.set(this.qdo.taxAmt, (Object)payload.getTaxAmt());
        }
        if ((nullFields = payload.getNullFields()) != null && nullFields.size() > 0) {
            if (nullFields.contains("id")) {
                update.setNull(this.qdo.id);
            }
            if (nullFields.contains("reimId")) {
                update.setNull(this.qdo.reimId);
            }
            if (nullFields.contains("reimDtlId")) {
                update.setNull(this.qdo.reimDtlId);
            }
            if (nullFields.contains("finAccSubjId")) {
                update.setNull(this.qdo.finAccSubjId);
            }
            if (nullFields.contains("taxRate")) {
                update.setNull(this.qdo.taxRate);
            }
            if (nullFields.contains("taxAmt")) {
                update.setNull(this.qdo.taxAmt);
            }
        }
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.id.in(keys)});
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public long delByReimId(Long reimId) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.reimId.eq((Object)reimId)});
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public List<AccReimExportVO> getExportTaxData(Set<Long> idList) {
        JPAQuery query = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.selectDistinct((Expression)Projections.bean(AccReimExportVO.class, (Expression[])new Expression[]{this.qMasdo.id, this.qMasdo.expenseCompany, this.qMasdo.reasonType, this.qMasdo.reasonId, this.qMasdo.reasonName, this.qMasdo.reimNo, this.qMasdo.reimUserId, this.qMasdo.reimDocType, this.qMasdo.reimOrgId, this.qMasdo.expenseOrgId, this.qMasdo.expenseProjectId, this.qdo.taxAmt.as("reimAmt"), this.qdo.finAccSubjId, this.qdo.id.as("detailId"), this.qDtldo.busAccItemId, this.qBusinessItemDO.businessName.as("busAccItemName"), this.qDtldo.expenseDate, this.qFinancialSubjectDO.accCode.as("finAccSubjCode"), this.qFinancialSubjectDO.accName, this.qDtldo.reimRemark.as("dtlReimRemark"), this.qDtldo.invoiceNum})).from((EntityPath)this.qdo)).leftJoin((EntityPath)this.qMasdo)).on((Predicate)this.qdo.reimId.eq(this.qMasdo.id))).leftJoin((EntityPath)this.qDtldo)).on((Predicate)this.qDtldo.id.eq(this.qdo.reimDtlId).and((Predicate)this.qDtldo.deleteFlag.eq((Object)0)))).leftJoin((EntityPath)this.qFinancialSubjectDO)).on((Predicate)this.qdo.finAccSubjId.eq(this.qFinancialSubjectDO.id).and((Predicate)this.qFinancialSubjectDO.deleteFlag.eq((Object)0)))).leftJoin((EntityPath)this.qBusinessItemDO)).on((Predicate)this.qDtldo.busAccItemId.eq(this.qBusinessItemDO.id).and((Predicate)this.qBusinessItemDO.deleteFlag.eq((Object)0)))).where((Predicate)this.qdo.reimId.in(idList));
        return query.fetch();
    }

    public AccReimTaxDAO(JPAQueryFactory jpaQueryFactory, AccReimTaxRepo repo) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.repo = repo;
    }
}

