/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.budget.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.budget.payload.BudgetSubjectDetailPayload;
import com.elitesland.tw.tw5.api.prd.budget.query.BudgetSubjectDetailQuery;
import com.elitesland.tw.tw5.api.prd.budget.service.BudgetSubjectDetailService;
import com.elitesland.tw.tw5.api.prd.budget.vo.BudgetSubjectDetailVO;
import com.elitesland.tw.tw5.server.prd.budget.convert.BudgetSubjectDetailConvert;
import com.elitesland.tw.tw5.server.prd.budget.dao.BudgetSubjectDetailDAO;
import com.elitesland.tw.tw5.server.prd.budget.entity.BudgetSubjectDetailDO;
import com.elitesland.tw.tw5.server.prd.budget.repo.BudgetSubjectDetailRepo;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class BudgetSubjectDetailServiceImpl
extends BaseServiceImpl
implements BudgetSubjectDetailService {
    private static final Logger log = LoggerFactory.getLogger(BudgetSubjectDetailServiceImpl.class);
    private final BudgetSubjectDetailRepo budgetSubjectDetailRepo;
    private final BudgetSubjectDetailDAO budgetSubjectDetailDAO;

    public void batchSave(List<BudgetSubjectDetailPayload> subjectDetailPayloads) {
        ArrayList<BudgetSubjectDetailDO> sudgetSubjectDetailDOs = new ArrayList<BudgetSubjectDetailDO>();
        for (BudgetSubjectDetailPayload payload : subjectDetailPayloads) {
            sudgetSubjectDetailDOs.add(BudgetSubjectDetailConvert.INSTANCE.toDo(payload));
        }
        this.budgetSubjectDetailDAO.saveAll(sudgetSubjectDetailDOs);
    }

    public List<BudgetSubjectDetailVO> queryListDyBudgetId(Long budgetId) {
        BudgetSubjectDetailQuery query = new BudgetSubjectDetailQuery();
        query.setBudgetId(budgetId);
        return this.budgetSubjectDetailDAO.queryListDynamic(query);
    }

    public PagingVO<BudgetSubjectDetailVO> queryPaging(BudgetSubjectDetailQuery query) {
        return this.budgetSubjectDetailDAO.queryPaging(query);
    }

    public List<BudgetSubjectDetailVO> queryListDynamic(BudgetSubjectDetailQuery query) {
        return this.budgetSubjectDetailDAO.queryListDynamic(query);
    }

    public BudgetSubjectDetailVO queryByKey(Long key) {
        BudgetSubjectDetailDO entity = this.budgetSubjectDetailRepo.findById(key).orElseGet(BudgetSubjectDetailDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        BudgetSubjectDetailVO vo = BudgetSubjectDetailConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public BudgetSubjectDetailVO insert(BudgetSubjectDetailPayload payload) {
        BudgetSubjectDetailDO entityDo = BudgetSubjectDetailConvert.INSTANCE.toDo(payload);
        return BudgetSubjectDetailConvert.INSTANCE.toVo((BudgetSubjectDetailDO)this.budgetSubjectDetailRepo.save(entityDo));
    }

    @Transactional(rollbackFor={Exception.class})
    public BudgetSubjectDetailVO update(BudgetSubjectDetailPayload payload) {
        BudgetSubjectDetailDO entity = this.budgetSubjectDetailRepo.findById(payload.getId()).orElseGet(BudgetSubjectDetailDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        BudgetSubjectDetailDO entityDo = BudgetSubjectDetailConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return BudgetSubjectDetailConvert.INSTANCE.toVo((BudgetSubjectDetailDO)this.budgetSubjectDetailRepo.save(entity));
    }

    @Transactional(rollbackFor={Exception.class})
    public long updateByKeyDynamic(BudgetSubjectDetailPayload payload) {
        BudgetSubjectDetailDO entity = this.budgetSubjectDetailRepo.findById(payload.getId()).orElseGet(BudgetSubjectDetailDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        long result = this.budgetSubjectDetailDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            this.budgetSubjectDetailDAO.deleteSoft(keys);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public long deleteSoftByBudgetId(Long budgetId) {
        return this.budgetSubjectDetailDAO.deleteSoftByBudgetId(budgetId);
    }

    public BudgetSubjectDetailServiceImpl(BudgetSubjectDetailRepo budgetSubjectDetailRepo, BudgetSubjectDetailDAO budgetSubjectDetailDAO) {
        this.budgetSubjectDetailRepo = budgetSubjectDetailRepo;
        this.budgetSubjectDetailDAO = budgetSubjectDetailDAO;
    }
}

