/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.cas.service;

import cn.hutool.core.date.DateUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.tw.tw5.api.prd.cas.service.PrdCasSettingService;
import com.elitesland.tw.tw5.api.prd.cas.service.PrdCasSsoService;
import com.elitesland.tw.tw5.api.prd.cas.vo.PrdCasSettingVO;
import com.elitesland.tw.tw5.server.common.HttpUtil;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.util.JwtUtil;
import com.elitesland.tw.tw5.server.common.util.RedisUtils;
import com.elitesland.tw.tw5.server.prd.cas.constant.SsoAppEnum;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class PrdCasSsoServiceImpl
extends BaseServiceImpl
implements PrdCasSsoService {
    private static final Logger log = LoggerFactory.getLogger(PrdCasSsoServiceImpl.class);
    private final PrdCasSettingService casSettingService;
    private final RedisUtils redisUtils;
    private final HttpUtil httpUtil;

    public Map getTicketAndUrl(String appId, HttpServletRequest request, HttpServletResponse response) {
        Boolean vaildateResult;
        SysUserDTO loginUser = GlobalUtil.getLoginUser();
        if (ObjectUtils.isEmpty((Object)loginUser)) {
            throw TwException.error("", "\u767b\u5f55\u5931\u8d25,\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25\uff01");
        }
        PrdCasSettingVO prdCasSettingVO = this.casSettingService.queryByAppId(appId);
        String castgc = this.getCastgc(request.getCookies());
        String ticket = "";
        Map<String, String> userInfoMap = new HashMap();
        boolean reGet = false;
        if (castgc != null) {
            ticket = castgc;
            userInfoMap = (Map)this.redisUtils.get(castgc);
            if (userInfoMap == null || userInfoMap.get("LoginName") == null) {
                userInfoMap = new HashMap();
                reGet = true;
            } else if (!loginUser.getEmail().equals(userInfoMap.get("LoginName"))) {
                reGet = true;
            }
        }
        if (castgc == null || reGet) {
            ticket = UUID.randomUUID().toString();
            response.addCookie(new Cookie("CASTGC", ticket));
            userInfoMap.put("LoginName", loginUser.getEmail());
            userInfoMap.put("UserName", loginUser.getUsername());
            userInfoMap.put("UserMail", loginUser.getEmail());
            this.redisUtils.set(ticket, userInfoMap, 30L, TimeUnit.MINUTES);
        }
        if ((vaildateResult = this.vaildateCasLogin(userInfoMap, appId, ticket, prdCasSettingVO)).booleanValue()) {
            HashMap<String, String> resultMap = new HashMap<String, String>();
            resultMap.put("ticket", ticket);
            resultMap.put("redirectUri", prdCasSettingVO.getRedirectUri());
            return resultMap;
        }
        throw TwException.error("", "\u4ea4\u53c9\u9a8c\u8bc1\u5931\u8d25\uff0c\u767b\u5f55\u5931\u8d25\uff01");
    }

    private Boolean vaildateCasLogin(Map userInfoMap, String appId, String ticket, PrdCasSettingVO prdCasSettingVO) {
        Boolean vaildateResult = false;
        switch (SsoAppEnum.valueOf(appId)) {
            case YEEDOC: {
                HashMap<String, String> payloadMap = new HashMap<String, String>();
                payloadMap.put("jwt", JSONUtil.toJsonStr((Object)userInfoMap));
                payloadMap.put("exp", (String)DateUtil.offsetDay((Date)new Date(), (int)30));
                String validateToken = JwtUtil.getToken(null, payloadMap, prdCasSettingVO.getSecret());
                String validateUri = prdCasSettingVO.getValidateUri();
                if (!StringUtils.hasText((String)validateToken)) break;
                HttpRequest request = HttpRequest.get((String)validateUri);
                request.header("ticket", ticket);
                request.header("userInfo", validateToken);
                String requestHeaders = prdCasSettingVO.getRequestHeaders();
                Map requestHeadersMap = (Map)JSON.parse((String)requestHeaders);
                for (String s : requestHeadersMap.keySet()) {
                    request.header(s, String.valueOf(requestHeadersMap.get(s)));
                }
                String body = request.execute().body();
                Map parse = (Map)JSON.parse((String)body);
                if (!parse.get("IsSuccess").equals(true)) break;
                vaildateResult = true;
                break;
            }
            case FR_REPORT: {
                vaildateResult = true;
                break;
            }
        }
        return vaildateResult;
    }

    private String getCastgc(Cookie[] cookies) {
        Cookie[] cookieArray;
        int n;
        int n2;
        if (cookies != null && (n2 = 0) < (n = (cookieArray = cookies).length)) {
            Cookie cookie = cookieArray[n2];
            if (cookie.getName().equals("CASTGC")) {
                return cookie.getValue();
            }
            return null;
        }
        return null;
    }

    public PrdCasSsoServiceImpl(PrdCasSettingService casSettingService, RedisUtils redisUtils, HttpUtil httpUtil) {
        this.casSettingService = casSettingService;
        this.redisUtils = redisUtils;
        this.httpUtil = httpUtil;
    }
}

